# E0008: let statement cannot declare variables named 'let'

Variables declared with `let` cannot be named `let`.

```javascript
function getLotNumber() { return 42; }

let let = getLotNumber();
console.log(let);
```

To fix this error, name the variable something other than `let`, or declare the
variable with `var`:

```javascript
function getLotNumber() { return 42; }

let lot = getLotNumber();
console.log(lot);

var let = getLotNumber();
console.log(let);
```

Introduced in quick-lint-js version 0.2.0.
