# E0007: classes cannot be named 'let'

Classes declared with `class` cannot be named `let`.

```javascript
class let {
  bark() {
    console.log("woof");
  }
}
```

To fix this error, name the class something other than `let`, or declare the
class with `var`:

```javascript
class Dog {
  bark() {
    console.log("woof");
  }
}

var let = class {
  bark() {
    console.log("woof");
  }
};
```

Introduced in quick-lint-js version 0.2.0.
