// Copyright (C) 2020  Matthew "strager" Glazar
// See end of file for extended copyright information.

#include <gmock/gmock.h>
#include <gtest/gtest.h>
#include <quick-lint-js/diag-matcher.h>
#include <quick-lint-js/parse-support.h>
#include <quick-lint-js/port/char8.h>
#include <quick-lint-js/spy-visitor.h>

using ::testing::ElementsAreArray;

namespace quick_lint_js {
namespace {
class Test_Parse_TypeScript_Object : public Test_Parse_Expression {};

TEST_F(Test_Parse_TypeScript_Object, generic_method) {
  {
    Spy_Visitor p = test_parse_and_visit_expression(
        u8"{ method<T>(param: T): T {} }"_sv, no_diags, typescript_options);
    EXPECT_THAT(p.visits, ElementsAreArray({
                              "visit_enter_function_scope",       // method
                              "visit_variable_declaration",       // T
                              "visit_enter_type_scope",           // :
                              "visit_variable_type_use",          // T
                              "visit_exit_type_scope",            //
                              "visit_variable_declaration",       // param
                              "visit_enter_type_scope",           // :
                              "visit_variable_type_use",          // T
                              "visit_exit_type_scope",            //
                              "visit_enter_function_scope_body",  // {
                              "visit_exit_function_scope",        // }
                          }));
  }

  // NOTE(strager): 'async', 'get', and 'set' are special-cased in the parser.
  {
    Spy_Visitor p = test_parse_and_visit_expression(
        u8"{ get<T>(param: T): T {} }"_sv, no_diags, typescript_options);
    EXPECT_THAT(p.visits, ElementsAreArray({
                              "visit_enter_function_scope",       // method
                              "visit_variable_declaration",       // T
                              "visit_enter_type_scope",           // :
                              "visit_variable_type_use",          // T
                              "visit_exit_type_scope",            //
                              "visit_variable_declaration",       // param
                              "visit_enter_type_scope",           // :
                              "visit_variable_type_use",          // T
                              "visit_exit_type_scope",            //
                              "visit_enter_function_scope_body",  // {
                              "visit_exit_function_scope",        // }
                          }));
  }
}

// See TODO[JavaScript-generic-method-in-object].
}
}

// quick-lint-js finds bugs in JavaScript programs.
// Copyright (C) 2020  Matthew "strager" Glazar
//
// This file is part of quick-lint-js.
//
// quick-lint-js is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// quick-lint-js is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with quick-lint-js.  If not, see <https://www.gnu.org/licenses/>.
