# E0312: missing parentheses around parameter; TypeScript optional parameter with type annotation requires parentheses

```config-for-examples
{
  "globals": {
    "fs": true,
    "outputPath": true,
    "result": true
  }
}
```

In TypeScript, parameters can be explicitly marked as optional and can have type
annotations. It is a syntax error to write an arrow function with a typed
optional parameter without parentheses around the parameter list:

```typescript
fs.promises.writeFile(outputPath, result)
  .then(async err?: Error => {
    if (err) throw err;
  });
```

To fix this error, write parentheses around the parameter list:

```typescript
fs.promises.writeFile(outputPath, result)
  .then(async (err?: Error) => {
    if (err) throw err;
  });
```

Introduced in quick-lint-js version 2.10.0.
