# E0299: abstract methods cannot be marked as a generator

```config-for-examples
{
  "globals": {
    "Generator": true
  }
}
```

`*` on a method allows using the `yield` keyword in the body of the method.
Abstract class methods do not have bodies. Therefore, `*` does not make sense on
abstract methods, and it is a syntax error to write it:

```typescript
abstract class RandomSource {
  abstract *makeRandomNumbers(): Generator<number>;
}
```

To fix this error, remove the `*`:

```typescript
abstract class RandomSource {
  abstract makeRandomNumbers(): Generator<number>;
}
```

Introduced in quick-lint-js version 2.10.0.
