# E0289: 'public' is not allowed in JavaScript

JavaScript properties are public by default. It is a syntax error to
write `public` explicitly:

```javascript
class Vec2D {
  public x = 0;
  public y = 0;

  public length() {
    return Math.sqrt(
      this.x * this.x +
      this.y * this.y);
  }
}
```

To fix this error, remove the `public` keyword:

```javascript
class Vec2D {
  x = 0;
  y = 0;

  length() {
    return Math.sqrt(
      this.x * this.x +
      this.y * this.y);
  }
}
```

Introduced in quick-lint-js version 2.10.0.
