# E0283: TypeScript &lt;Type&gt; casts are not allowed in JSX mode

```config-for-examples
{
  "globals": {
    "useEffect": true
  }
}
```

TypeScript supports two styles for type assertions: `<Type>variable` and
`variable as Type`. It is a syntax error to use the former style in a `.tsx`
file:

```typescript-jsx
interface Payload { data: string; }
interface PayloadError { error: string; }

function useFetchPayload(uri, onResult) {
  useEffect(async () => {
    let data = await (await fetch(uri)).json();
    onResult(<Payload | PayloadError>data);
  }, [uri]);
}
```

To fix this error, use `as` instead:

```typescript-jsx
interface Payload { data: string; }
interface PayloadError { error: string; }

function useFetchPayload(uri, onResult) {
  useEffect(async () => {
    let data = await (await fetch(uri)).json();
    onResult(data as Payload | PayloadError);
  }, [uri]);
}
```

Introduced in quick-lint-js version 2.9.0.
