# E0267: TypeScript types are not allowed in JavaScript

TypeScript type aliases can be declared with the `type` keyword. It is a syntax
error to write a TypeScript type alias in JavaScript code:

```javascript
type Response<T> = {
  ok: boolean;
  error?: string;
  data?: T;
};
```

To fix this error, rename your file to have a `.ts` or `.tsx` suffix.

Alternatively, use JSDoc to declare the type:

```javascript
/**
 * @typedef {Object} Response
 * @prop {boolean} ok
 * @prop {string} [error]
 * @prop {Object} data
 */
```

Introduced in quick-lint-js version 2.8.0.
