# E0250: enum member name cannot be numeric

TypeScript enum members can be named using an identifier or a string literal.
It is a syntax error to name an enum member using a number literal:

```typescript
enum LogLevel {
  ERROR = 0,
  WARNING = 1,
  INFO = 2,

  // For array-like access:
  0 = 0,
  1 = 1,
  2 = 2,
}
```

To fix this error, replace the enum with an object:

```typescript
const LogLevel = {
  ERROR: 0,
  WARNING: 1,
  INFO: 2,

  // For array-like access:
  0: 0,
  1: 1,
  2: 2,
} as const;
```

Introduced in quick-lint-js version 2.7.0.
