# E0246: 'extends' must be before 'implements'

TypeScript classes can extend another class and implement interfaces. It is a
syntax error to write the implemented interfaces before the extended class:

```typescript
import stream from "node:stream";
class MyStream
    implements stream.ReadableStream
    extends stream.Stream {
  // ...
}
```

To fix this error, write the `extends` clause before the `implements` clause:

```typescript
import stream from "node:stream";
class MyStream
    extends stream.Stream
    implements stream.ReadableStream {
  // ...
}
```

Introduced in quick-lint-js version 2.7.0.
