# E0243: interfaces cannot contain static blocks

`static` blocks in classes contain code which runs when the class is created at
run time. Because TypeScript interfaces exist only at compile time, `static`
blocks are not supported in interfaces:

```typescript
class ConsoleLogger implements Logger {
  log(message) {
    console.log(message);
  }
}

let logger: Logger;
interface Logger {
  log(message: string): void;

  static {
    logger = new ConsoleLogger();
  }
}
```

To fix this error, move the code in the `static` code block outside the
interface, then delete the empty `static` code block:

```typescript
class ConsoleLogger implements Logger {
  log(message) {
    console.log(message);
  }
}

let logger: Logger;
interface Logger {
  log(message: string): void;
}
logger = new ConsoleLogger();
```

Introduced in quick-lint-js version 2.6.0.
