# E0240: '!' is not allowed on methods

```config-for-examples
{
  "globals": {
    "BananaSkin": true
  }
}
```

In TypeScript, `!` after a field name indicates a *definite assignment
assertion*. Because `!` only applies to fields, is a syntax error to write `!`
after a method name:

```typescript
class Banana {
  skin!: BananaSkin | undefined;

  peel!() {
    this.skin = undefined;
  }
}
```

To fix this error, remove the `!`:

```typescript
class Banana {
  skin!: BananaSkin | undefined;

  peel() {
    this.skin = undefined;
  }
}
```

Introduced in quick-lint-js version 2.6.0.
