# E0234: 'protected' is not allowed in JavaScript

JavaScript does not support protected properties. It is a syntax error to
declare a class property as `protected`:

```javascript
class ObjectPool {
  protected makeImpl() {
    return {};
  }
}

class NodePool extends ObjectPool {
  protected makeImpl() {
    return new Node(null);
  }
}
```

To fix this error, remove the `protected` keyword, and consider putting a `_`
prefix in the property name to signal it should not be called outside the class:

```javascript
class ObjectPool {
  _makeImpl() {
    return {};
  }
}

class NodePool extends ObjectPool {
  _makeImpl() {
    return new Node(null);
  }
}
```

Introduced in quick-lint-js version 2.6.0.
