# E0218: TypeScript interface methods cannot be marked as a generator

```config-for-examples
{
  "globals": {
    "Generator": true
  }
}
```

`*` on a method allows using the `yield` keyword in the body of the method.
TypeScript interface methods do not have bodies. Therefore, `*` does not make
sense on TypeScript interface methods, and it is a syntax error to write it:

```typescript
interface RandomSource {
  *makeRandomNumbers(): Generator<number>;
}
```

To fix this error, remove the `*`:

```typescript
interface RandomSource {
  makeRandomNumbers(): Generator<number>;
}
```

Introduced in quick-lint-js version 2.6.0.
