# E0217: TypeScript interface methods cannot be marked 'async'

```config-for-examples
{
  "globals": {
    "LoadedData": true
  }
}
```

The `async` keyword on methods changes the body of that method. TypeScript
interface methods do not have bodies. Therefore, `async` does not make sense on
TypeScript interface methods, and it is a syntax error to write it:

```typescript
interface DataLoader {
  async load(): Promise<LoadedData>;
}
```

To fix this error, remove the `async` keyword:

```typescript
interface DataLoader {
  load(): Promise<LoadedData>;
}
```

Introduced in quick-lint-js version 2.6.0.
