# E0198: unexpected statement before first switch case, expected 'case' or 'default'

```config-for-examples
{
  "globals": {
    "isEven": true,
    "n": true
  }
}
```

`switch` statements contain zero or more labelled statements. It is a syntax
error to write a statement inside a `switch`'s body before the first label:

```javascript
function colorToHexCode(color) {
  switch (color) {
    throw new Error(`unknown color ${color}`);
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}

switch (isEven(n)) {
  console.log(`${n} is even`);
}
```

To fix this error, write a `default` or `case` label at the beginning of the
`switch`:

```javascript
function colorToHexCode(color) {
  switch (color) {
    default:
      throw new Error(`unknown color ${color}`);
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

Alternatively, replace `switch` with `if`:

```javascript
if (isEven(n)) {
  console.log(`${n} is even`);
}
```

Introduced in quick-lint-js version 2.3.0.
