# E0188: '=' changes variables; to compare, use '===' instead

```config-for-examples
{
  "globals": {
    "xs": true,
    "out": true
  }
}
```

In an `if` statement or a loop, it is likely a mistake to use `=` to compare a
variable with a constant:

```javascript
let headingLinks = [];
for (let el of document.querySelectorAll("a")) {
  if (el.parentNode.tag = "H1") {
    headingLinks.push(el);
  }
}

for (let x, i = 0; x = null; ++i) {
  if (xs[i] < 0) {
    break;
  } else if (xs[i] > 0) {
    x = xs[i];
  }
  out.push(x);
}
```

To fix this error, write `===` or `==` instead of `=` to compare for equality:

```javascript
let headingLinks = [];
for (let el of document.querySelectorAll("a")) {
  if (el.parentNode.tag === "H1") {
    headingLinks.push(el);
  }
}
```

Alternatively, if assignment was intended, write parentheses around the
assignment to suppress the warning:

```javascript
for (let x, i = 0; (x = null); ++i) {
  if (xs[i] < 0) {
    break;
  } else if (xs[i] > 0) {
    x = xs[i];
  }
  out.push(x);
}
```

Introduced in quick-lint-js version 2.0.0.
