# E0178: 'await' cannot be followed by an arrow function; use 'async' instead

```config-for-examples
{
  "globals": {
    "app": true,
    "doHomePage": true
  }
}
```

Arrow functions can contain `await` if they are marked `async`. It is an error
to write `await` instead of `async` when making an arrow function:

```javascript
app.get("/", await (req, res) => {
  await doHomePage(req, res);
});
```

To fix this error, write `async` instead of `await`:

```javascript
app.get("/", async (req, res) => {
  await doHomePage(req, res);
});
```

Introduced in quick-lint-js version 0.6.0.
