# E0153: forwarding exports are only allowed in export-from

An `export` statement can forward exports from another module. It is a syntax
error to forward exports without specifying which module to import from:

```javascript
export {"React"};
```

To fix this error, write `from` then the other module's name after the list of
exports:

```javascript
export {"React"} from "react";
```

Alternatively, import the symbols separately with an `import` statement:

```javascript
import {React} from "react";
export {React};
```

Introduced in quick-lint-js version 0.3.0.
