# E0137: missing condition for switch statement

A `switch` statement has a condition which determines which `case` or `default`
label to execute. It is an error to omit a `switch`'s condition:

```javascript
function colorToHexCode(color) {
  switch {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

To fix this error, write the condition with parentheses after the `switch`
keyword:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

Introduced in quick-lint-js version 0.2.0.
