# E0111: missing body for class

```config-for-examples
{
  "globals": {
    "parseConfig": true
  }
}
```

Classes require a body, which must be a list of properties and methods
surrounded by `{` and `}`. It is a syntax error to omit the body of a class:

```javascript
class Animal {}
class Doge extends Animal
class Kitty extends Animal
```

To fix this error, write the body of the class, including `{` and `}`:

```javascript
class Animal {}
class Doge extends Animal {}
class Kitty extends Animal {}
```

Introduced in quick-lint-js version 0.2.0.
