# E0096: missing for loop header

```config-for-examples
{
  "globals": {
    "benchmark": true,
    "collectBenchmarks": true,
    "runBenchmark": true
  }
}
```

It is a syntax error to have nothing between the `(` and `)` in a `for` loop:

```javascript
for () {
  runBenchmark(benchmark);
}
```

To fix this error, continue writing the `for` loop:

```javascript
for (const benchmark of collectBenchmarks()) {
  runBenchmark(benchmark);
}
```

Introduced in quick-lint-js version 0.2.0.
