# E0091: switch statement needs parentheses around condition

`switch` statements have a condition after the `switch` keyword. It is a syntax
error to write a condition without `(` and `)`:

```javascript
function colorToHexCode(color) {
  switch color {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

To fix this error, write `(` before the condition and `)` after the condition:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

Introduced in quick-lint-js version 0.2.0.
