# E0034: redeclaration of variable

```config-for-examples
{
  "globals": {
    "loadFriends": true
  }
}
```

In a given function or `{}` block, a variable can only be declared multiple
times if it is declared with `var` or `function`. Other types of variables can
be declared only once:

```javascript
let x, y, y, w;

const friends = loadFriends();
const friends = friends
  .filter(friend => friend.name !== "strager");

class Orange { name = "orange" }
class Orange { name = "banana" }

function jump(player, height) {
  let height = height || player.height/2;
}
```

To fix this error, assign to the existing variable, choose a different variable
name, or delete the extra variable:

```javascript
let x, y, z, w;

let friends = loadFriends();
friends = friends
  .filter(friend => friend.name !== "strager");

class Orange { name = "orange" }
class Banana { name = "banana" }

function jump(player, height) {
  height = height || player.height/2;
}
```

Introduced in quick-lint-js version 0.2.0.
