// Copyright (C) 2020  Matthew "strager" Glazar
// See end of file for extended copyright information.

// Code generated by tools/generate-trace-sources.cpp. DO NOT EDIT.
// source: src/quick-lint-js/logging/trace-types.h

#include <cstddef>
#include <quick-lint-js/logging/trace-reader.h>
#include <quick-lint-js/util/binary-reader.h>

// clang-format off

namespace quick_lint_js {
namespace {
Trace_VSCode_Document_Position parse_Trace_VSCode_Document_Position(Checked_Binary_Reader& r, [[maybe_unused]] Trace_Reader* self) {
  return Trace_VSCode_Document_Position{
      .line = r.u64_le(),
      .character = r.u64_le(),
  };
}

Trace_VSCode_Document_Range parse_Trace_VSCode_Document_Range(Checked_Binary_Reader& r, [[maybe_unused]] Trace_Reader* self) {
  return Trace_VSCode_Document_Range{
      .start = parse_Trace_VSCode_Document_Position(r, self),
      .end = parse_Trace_VSCode_Document_Position(r, self),
  };
}

Trace_VSCode_Document_Change<std::u16string_view> parse_Trace_VSCode_Document_Change(Checked_Binary_Reader& r, [[maybe_unused]] Trace_Reader* self) {
  return Trace_VSCode_Document_Change<std::u16string_view>{
      .range = parse_Trace_VSCode_Document_Range(r, self),
      .range_offset = r.u64_le(),
      .range_length = r.u64_le(),
      .text = self->parse_utf16le_string(r),
  };
}

Trace_Vector_Max_Size_Histogram_Entry parse_Trace_Vector_Max_Size_Histogram_Entry(Checked_Binary_Reader& r, [[maybe_unused]] Trace_Reader* self) {
  return Trace_Vector_Max_Size_Histogram_Entry{
      .max_size = r.u64_le(),
      .count = r.u64_le(),
  };
}

Trace_Vector_Max_Size_Histogram_By_Owner_Entry parse_Trace_Vector_Max_Size_Histogram_By_Owner_Entry(Checked_Binary_Reader& r, [[maybe_unused]] Trace_Reader* self) {
  return Trace_Vector_Max_Size_Histogram_By_Owner_Entry{
      .owner = self->parse_utf8_zstring(r),
      .max_size_entries = self->parse_array<Trace_Vector_Max_Size_Histogram_Entry>(r, [&]() { return parse_Trace_Vector_Max_Size_Histogram_Entry(r, self); }),
  };
}

Trace_LSP_Document_Type parse_Trace_LSP_Document_Type(Checked_Binary_Reader& r, Trace_Reader* self) {
  switch (r.u8()) {
  default:
    self->on_error(Parsed_Trace_Event_Type::error_unsupported_lsp_document_type);
    [[fallthrough]];
  case 0:
    return Trace_LSP_Document_Type::unknown;
  case 1:
    return Trace_LSP_Document_Type::config;
  case 2:
    return Trace_LSP_Document_Type::lintable;
  }
}

Trace_LSP_Document_State parse_Trace_LSP_Document_State(Checked_Binary_Reader& r, [[maybe_unused]] Trace_Reader* self) {
  return Trace_LSP_Document_State{
      .type = parse_Trace_LSP_Document_Type(r, self),
      .uri = self->parse_utf8_string(r),
      .text = self->parse_utf8_string(r),
      .language_id = self->parse_utf8_string(r),
  };
}

}

void Trace_Reader::parse_event(Checked_Binary_Reader& r) {
  Trace_Reader* self = this;
  Trace_Event_Header header = {
      .timestamp = r.u64_le(),
  };
  std::uint8_t event_id = r.u8();
  switch (event_id) {
  case 0x01:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::init_event,
        .header = header,
        .init_event =
            Trace_Event_Init{
              .version = self->parse_utf8_zstring(r),
            },
    });
    break;
  case 0x02:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::vscode_document_opened_event,
        .header = header,
        .vscode_document_opened_event =
            Trace_Event_VSCode_Document_Opened<std::u16string_view>{
              .document_id = r.u64_le(),
              .uri = self->parse_utf16le_string(r),
              .language_id = self->parse_utf16le_string(r),
              .content = self->parse_utf16le_string(r),
            },
    });
    break;
  case 0x03:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::vscode_document_closed_event,
        .header = header,
        .vscode_document_closed_event =
            Trace_Event_VSCode_Document_Closed<std::u16string_view>{
              .document_id = r.u64_le(),
              .uri = self->parse_utf16le_string(r),
              .language_id = self->parse_utf16le_string(r),
            },
    });
    break;
  case 0x04:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::vscode_document_changed_event,
        .header = header,
        .vscode_document_changed_event =
            Trace_Event_VSCode_Document_Changed<std::u16string_view>{
              .document_id = r.u64_le(),
              .changes = self->parse_array<Trace_VSCode_Document_Change<std::u16string_view>>(r, [&]() { return parse_Trace_VSCode_Document_Change(r, self); }),
            },
    });
    break;
  case 0x05:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::vscode_document_sync_event,
        .header = header,
        .vscode_document_sync_event =
            Trace_Event_VSCode_Document_Sync<std::u16string_view>{
              .document_id = r.u64_le(),
              .uri = self->parse_utf16le_string(r),
              .language_id = self->parse_utf16le_string(r),
              .content = self->parse_utf16le_string(r),
            },
    });
    break;
  case 0x06:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::lsp_client_to_server_message_event,
        .header = header,
        .lsp_client_to_server_message_event =
            Trace_Event_LSP_Client_To_Server_Message{
              .body = self->parse_utf8_string(r),
            },
    });
    break;
  case 0x07:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::vector_max_size_histogram_by_owner_event,
        .header = header,
        .vector_max_size_histogram_by_owner_event =
            Trace_Event_Vector_Max_Size_Histogram_By_Owner{
              .entries = self->parse_array<Trace_Vector_Max_Size_Histogram_By_Owner_Entry>(r, [&]() { return parse_Trace_Vector_Max_Size_Histogram_By_Owner_Entry(r, self); }),
            },
    });
    break;
  case 0x08:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::process_id_event,
        .header = header,
        .process_id_event =
            Trace_Event_Process_ID{
              .process_id = r.u64_le(),
            },
    });
    break;
  case 0x09:
    this->parsed_events_.push_back(Parsed_Trace_Event{
        .type = Parsed_Trace_Event_Type::lsp_documents_event,
        .header = header,
        .lsp_documents_event =
            Trace_Event_LSP_Documents{
              .documents = self->parse_array<Trace_LSP_Document_State>(r, [&]() { return parse_Trace_LSP_Document_State(r, self); }),
            },
    });
    break;

  default:
    // TODO(strager): Report an error.
    return;
  }
}
}

// quick-lint-js finds bugs in JavaScript programs.
// Copyright (C) 2020  Matthew "strager" Glazar
//
// This file is part of quick-lint-js.
//
// quick-lint-js is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// quick-lint-js is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with quick-lint-js.  If not, see <https://www.gnu.org/licenses/>.
