// Code generated by tools/compile-translations.cpp. DO NOT EDIT.
// source: po/*.po

// Copyright (C) 2020  Matthew "strager" Glazar
// See end of file for extended copyright information.

#pragma once

#include <quick-lint-js/i18n/translation.h>
#include <quick-lint-js/port/char8.h>

namespace quick_lint_js {
// clang-format off
inline constexpr const char *test_locale_names[] = {
    "de",
    "en_US@snarky",
    "fr_FR",
    "pt_BR",
    "sv_SE",
};
// clang-format on

struct Translated_String {
  Translatable_Message translatable;
  const Char8 *expected_untranslated;
  const Char8 *expected_per_locale[5];
};

// clang-format off
inline const Translated_String test_translation_table[608] = {
    {
        "\"global-groups\" entries must be strings"_translatable,
        u8"\"global-groups\" entries must be strings",
        {
            u8"Eintr\u00e4ge in \"global-groups\" m\u00fcssen Strings sein",
            u8"\"global-groups\" contains strings, not whatever you just said",
            u8"les entr\u00e9es de type \"global-groups\" doivent \u00eatre des cha\u00eenes de caract\u00e8res",
            u8"entradas em \"global-groups\" precisam ser strings",
            u8"\"global-groups\" entries must be strings",
        },
    },
    {
        "\"global-groups\" must be a boolean or an array"_translatable,
        u8"\"global-groups\" must be a boolean or an array",
        {
            u8"\"global-groups\" muss entweder ein Boolean oder ein Array sein",
            u8"\"global-groups\" must be a boolean or an array, not whatever you just said",
            u8"\"global-groups\" doit \u00eatre un bool\u00e9en ou un tableau",
            u8"\"global-groups\" precisa ser uma boolean ou uma array",
            u8"\"global-groups\" must be a boolean or an array",
        },
    },
    {
        "\"globals\" descriptor \"shadowable\" property must be a boolean"_translatable,
        u8"\"globals\" descriptor \"shadowable\" property must be a boolean",
        {
            u8"Die \"shadowable\"-Eigenschaft des \"globals\"-Deskriptor muss ein Boolean sein",
            u8"\"globals\" descriptor \"shadowable\" property must be a boolean, not whatever you just said",
            u8"pour le descripteur \"globals\" la propri\u00e9t\u00e9 \"shadowable\" doit \u00eare un bool\u00e9en",
            u8"entrada \"shadowable\" em \"globals\" precisa ser uma boolean",
            u8"\"globals\" descriptor \"shadowable\" property must be a boolean",
        },
    },
    {
        "\"globals\" descriptor \"writable\" property must be a boolean"_translatable,
        u8"\"globals\" descriptor \"writable\" property must be a boolean",
        {
            u8"Die \"writable\"-Eigenschaft des \"globals\"-Deskriptor muss ein Boolean sein",
            u8"\"globals\" descriptor \"writable\" property must be a boolean, not whatever you just said",
            u8"pour le descripteur \"globals\" la propri\u00e9t\u00e9 \"writable\" doit \u00eatre un bool\u00e9en",
            u8"entrada \"writable\" em \"globals\" precisa ser uma boolean",
            u8"\"globals\" descriptor \"writable\" property must be a boolean",
        },
    },
    {
        "\"globals\" descriptor must be a boolean or an object"_translatable,
        u8"\"globals\" descriptor must be a boolean or an object",
        {
            u8"Der \"globals\"-Deskriptor muss entweder ein Boolean oder ein Array sein",
            u8"\"globals\" descriptor must be a boolean or an object, not whatever you just said",
            u8"le descripteur \"globals\" doit \u00eatre un bool\u00e9en ou un objet",
            u8"entrada em \"globals\" precisa ser uma boolean ou um objeto",
            u8"\"globals\" descriptor must be a boolean or an object",
        },
    },
    {
        "\"globals\" must be an object"_translatable,
        u8"\"globals\" must be an object",
        {
            u8"\"globles\" muss ein Objekt sein",
            u8"\"globals\" must be an object, not whatever you just said",
            u8"\"globals\" doit \u00eatre un objet",
            u8"\"globals\" precisa ser um objeto",
            u8"\"globals\" must be an object",
        },
    },
    {
        "\"jsx-mode\" must be a string; try \"none\" or \"react\""_translatable,
        u8"\"jsx-mode\" must be a string; try \"none\" or \"react\"",
        {
            u8"\"jsx-mode\" must be a string; try \"none\" or \"react\"",
            u8"\"jsx-mode\" must be a string; try \"none\" or \"react\"",
            u8"\"jsx-mode\" must be a string; try \"none\" or \"react\"",
            u8"\"jsx-mode\" must be a string; try \"none\" or \"react\"",
            u8"\"jsx-mode\" must be a string; try \"none\" or \"react\"",
        },
    },
    {
        "'!' (definite assignment assertion) cannot be used with an initial value"_translatable,
        u8"'!' (definite assignment assertion) cannot be used with an initial value",
        {
            u8"'!' (definite assignment assertion) cannot be used with an initial value",
            u8"'!' (definite assignment assertion) cannot be used with an initial value",
            u8"'!' (definite assignment assertion) cannot be used with an initial value",
            u8"'!' (definite assignment assertion) cannot be used with an initial value",
            u8"'!' (definite assignment assertion) cannot be used with an initial value",
        },
    },
    {
        "'!' (definite assignment assertion) is not allowed on 'declare' variables"_translatable,
        u8"'!' (definite assignment assertion) is not allowed on 'declare' variables",
        {
            u8"'!' (definite assignment assertion) is not allowed on 'declare' variables",
            u8"'!' (definite assignment assertion) is not allowed on 'declare' variables",
            u8"'!' (definite assignment assertion) is not allowed on 'declare' variables",
            u8"'!' (definite assignment assertion) is not allowed on 'declare' variables",
            u8"'!' (definite assignment assertion) is not allowed on 'declare' variables",
        },
    },
    {
        "'!' here treated as the TypeScript non-null assertion operator"_translatable,
        u8"'!' here treated as the TypeScript non-null assertion operator",
        {
            u8"'!' here treated as the TypeScript non-null assertion operator",
            u8"'!' here treated as the TypeScript non-null assertion operator",
            u8"'!' here treated as the TypeScript non-null assertion operator",
            u8"'!' here treated as the TypeScript non-null assertion operator",
            u8"'!' here treated as the TypeScript non-null assertion operator",
        },
    },
    {
        "'&' here"_translatable,
        u8"'&' here",
        {
            u8"'&' here",
            u8"'&' here",
            u8"'&' here",
            u8"'&' here",
            u8"'&' here",
        },
    },
    {
        "'**' operator cannot be used after unary '{1}' without parentheses"_translatable,
        u8"'**' operator cannot be used after unary '{1}' without parentheses",
        {
            u8"Ohne Klammern kann der Operator '**' nicht nach un\u00e4rem '{1}' verwendet werden",
            u8"'**' and '{1}' don't mix",
            u8"'**' operator cannot be used after unary '{1}' without parentheses",
            u8"operador '**' n\u00e3o pode ser usado ap\u00f3s un\u00e1rio '{1}' sem par\u00eanteses",
            u8"'**' operator cannot be used after unary '{1}' without parentheses",
        },
    },
    {
        "',' should be ';' instead"_translatable,
        u8"',' should be ';' instead",
        {
            u8"',' should be ';' instead",
            u8"',' should be ';' instead",
            u8"',' should be ';' instead",
            u8"',' should be ';' instead",
            u8"',' should be ';' instead",
        },
    },
    {
        "'.' is not allowed after generic arguments; write [\"{1}\"] instead"_translatable,
        u8"'.' is not allowed after generic arguments; write [\"{1}\"] instead",
        {
            u8"'.' is not allowed after generic arguments; write [\"{1}\"] instead",
            u8"'.' is not allowed after generic arguments; write [\"{1}\"] instead",
            u8"'.' is not allowed after generic arguments; write [\"{1}\"] instead",
            u8"'.' n\u00e3o \u00e9 permitido ap\u00f3s argumentos gen\u00e9ricos; use [\"{1}\"]",
            u8"'.' is not allowed after generic arguments; write [\"{1}\"] instead",
        },
    },
    {
        "'.' operator needs a key name; use + to concatenate strings; use [] to access with a dynamic key"_translatable,
        u8"'.' operator needs a key name; use + to concatenate strings; use [] to access with a dynamic key",
        {
            u8"Der '.'-Operator erfordert einen Schl\u00fcsselnamen; + verwenden, um Strings zu verketten; [] verwenden, um auf dynamische Schl\u00fcssel zuzugreifen",
            u8"this isn't PHP",
            u8"l'op\u00e9rateur '.' n\u00e9cessite un nom cl\u00e9 ; utiliser + pour concat\u00e9ner des cha\u00eenes de caract\u00e8res ; utiliser [] pour un acc\u00e8s avec une cl\u00e9 dynamique",
            u8"operador '.' requer o nome da chave; use + para concatenar strings; use [] para acessar com uma chave din\u00e2mica",
            u8"'.' operation beh\u00f6ver nyckelords namn; anv\u00e4nd + f\u00f6r att konkatenera str\u00e4ng; anv\u00e4nd [] f\u00f6r att komma \u00e5t med dynamisk nyckel",
        },
    },
    {
        "'...' belongs before the tuple element name, not before the type"_translatable,
        u8"'...' belongs before the tuple element name, not before the type",
        {
            u8"'...' belongs before the tuple element name, not before the type",
            u8"'...' belongs before the tuple element name, not before the type",
            u8"'...' belongs before the tuple element name, not before the type",
            u8"'...' belongs before the tuple element name, not before the type",
            u8"'...' belongs before the tuple element name, not before the type",
        },
    },
    {
        "'...' belongs only before the tuple element name, not also before the type"_translatable,
        u8"'...' belongs only before the tuple element name, not also before the type",
        {
            u8"'...' belongs only before the tuple element name, not also before the type",
            u8"'...' belongs only before the tuple element name, not also before the type",
            u8"'...' belongs only before the tuple element name, not also before the type",
            u8"'...' belongs only before the tuple element name, not also before the type",
            u8"'...' belongs only before the tuple element name, not also before the type",
        },
    },
    {
        "'...' goes here"_translatable,
        u8"'...' goes here",
        {
            u8"'...' goes here",
            u8"'...' goes here",
            u8"'...' goes here",
            u8"'...' goes here",
            u8"'...' goes here",
        },
    },
    {
        "':' should be 'extends' instead"_translatable,
        u8"':' should be 'extends' instead",
        {
            u8"':' should be 'extends' instead",
            u8"':' should be 'extends' instead",
            u8"':' should be 'extends' instead",
            u8"':' should be 'extends' instead",
            u8"':' should be 'extends' instead",
        },
    },
    {
        "'=' changes variables; to compare, use '===' instead"_translatable,
        u8"'=' changes variables; to compare, use '===' instead",
        {
            u8"'=' ver\u00e4ndert Variable. F\u00fcr Vergleich '===' anstattdessen verwenden",
            u8"this isn't math class!",
            u8"'=' changes variables; to compare, use '===' instead",
            u8"'=' altera vari\u00e1veis; para comparar, use '==='",
            u8"'=' changes variables; to compare, use '===' instead",
        },
    },
    {
        "'>' is not allowed directly in JSX text; write {{'>'} or &gt; instead"_translatable,
        u8"'>' is not allowed directly in JSX text; write {{'>'} or &gt; instead",
        {
            u8"'>' darf nicht direkt in JSX-Text verwendet werden. Anstattdessen {{'>} oder &gt; schreiben.",
            u8"Facebook says '>' is not allowed; write {{'>'} or &gt; instead",
            u8"'>' is not allowed directly in JSX text; write {{'>'} or &gt; instead",
            u8"'>' n\u00e3o \u00e9 permitido diretamente em um texto JSX; use {{'>'} ou &gt;",
            u8"'>' is not allowed directly in JSX text; write {{'>'} or &gt; instead",
        },
    },
    {
        "'?' belongs after the tuple element name, not after the type"_translatable,
        u8"'?' belongs after the tuple element name, not after the type",
        {
            u8"'?' belongs after the tuple element name, not after the type",
            u8"'?' belongs after the tuple element name, not after the type",
            u8"'?' belongs after the tuple element name, not after the type",
            u8"'?' belongs after the tuple element name, not after the type",
            u8"'?' belongs after the tuple element name, not after the type",
        },
    },
    {
        "'?' belongs only after the tuple element name, not also after the type"_translatable,
        u8"'?' belongs only after the tuple element name, not also after the type",
        {
            u8"'?' belongs only after the tuple element name, not also after the type",
            u8"'?' belongs only after the tuple element name, not also after the type",
            u8"'?' belongs only after the tuple element name, not also after the type",
            u8"'?' belongs only after the tuple element name, not also after the type",
            u8"'?' belongs only after the tuple element name, not also after the type",
        },
    },
    {
        "'?' creates a conditional expression"_translatable,
        u8"'?' creates a conditional expression",
        {
            u8"'?' erzeugt einen Ausdruck mit tern\u00e4rem Operator",
            u8"do you know what a conditional expression even is ? liar \U0001f925 : Kagi it \U0001f50d",
            u8"'?' cr\u00e9\u00e9 une expression conditionnelle",
            u8"'?' cria uma express\u00e3o condicional",
            u8"'?' skapar vilkorsuttryck",
        },
    },
    {
        "'?' goes here"_translatable,
        u8"'?' goes here",
        {
            u8"'?' goes here",
            u8"'?' goes here",
            u8"'?' goes here",
            u8"'?' goes here",
            u8"'?' goes here",
        },
    },
    {
        "'^' is the XOR operator; to exponentiate, use '**' instead"_translatable,
        u8"'^' is the XOR operator; to exponentiate, use '**' instead",
        {
            u8"'^' is the XOR operator; to exponentiate, use '**' instead",
            u8"'^' is the XOR operator; to exponentiate, use '**' instead",
            u8"'^' is the XOR operator; to exponentiate, use '**' instead",
            u8"'^' is the XOR operator; to exponentiate, use '**' instead",
            u8"'^' is the XOR operator; to exponentiate, use '**' instead",
        },
    },
    {
        "'abstract' here"_translatable,
        u8"'abstract' here",
        {
            u8"'abstract' here",
            u8"'abstract' here",
            u8"'abstract' here",
            u8"'abstract' here",
            u8"'abstract' here",
        },
    },
    {
        "'accessor' is not allowed for TypeScript interface fields"_translatable,
        u8"'accessor' is not allowed for TypeScript interface fields",
        {
            u8"'accessor' is not allowed for TypeScript interface fields",
            u8"'accessor' is not allowed for TypeScript interface fields",
            u8"'accessor' is not allowed for TypeScript interface fields",
            u8"'accessor' is not allowed for TypeScript interface fields",
            u8"'accessor' is not allowed for TypeScript interface fields",
        },
    },
    {
        "'accessor' keyword is not allowed on getters or setters"_translatable,
        u8"'accessor' keyword is not allowed on getters or setters",
        {
            u8"'accessor' keyword is not allowed on getters or setters",
            u8"'accessor' keyword is not allowed on getters or setters",
            u8"'accessor' keyword is not allowed on getters or setters",
            u8"'accessor' keyword is not allowed on getters or setters",
            u8"'accessor' keyword is not allowed on getters or setters",
        },
    },
    {
        "'accessor' keyword is not allowed on methods"_translatable,
        u8"'accessor' keyword is not allowed on methods",
        {
            u8"'accessor' keyword is not allowed on methods",
            u8"'accessor' keyword is not allowed on methods",
            u8"'accessor' keyword is not allowed on methods",
            u8"'accessor' keyword is not allowed on methods",
            u8"'accessor' keyword is not allowed on methods",
        },
    },
    {
        "'as const' is only allowed on literals (array, object, string, boolean) and enum members"_translatable,
        u8"'as const' is only allowed on literals (array, object, string, boolean) and enum members",
        {
            u8"'as const' is only allowed on literals (array, object, string, boolean) and enum members",
            u8"'as const' is only allowed on literals (array, object, string, boolean) and enum members",
            u8"'as const' is only allowed on literals (array, object, string, boolean) and enum members",
            u8"'as const' s\u00f3 \u00e9 permitido em valores literais (array, object, string, boolean) e membros de enums",
            u8"'as const' is only allowed on literals (array, object, string, boolean) and enum members",
        },
    },
    {
        "'as const' located here"_translatable,
        u8"'as const' located here",
        {
            u8"'as const' located here",
            u8"'as const' located here",
            u8"'as const' located here",
            u8"'as const' localizado aqui",
            u8"'as const' located here",
        },
    },
    {
        "'async export' is not allowed; write 'export async' instead"_translatable,
        u8"'async export' is not allowed; write 'export async' instead",
        {
            u8"'async export' is not allowed; write 'export async' instead",
            u8"'async export' is not allowed; write 'export async' instead",
            u8"'async export' is not allowed; write 'export async' instead",
            u8"'async export' is not allowed; write 'export async' instead",
            u8"'async export' is not allowed; write 'export async' instead",
        },
    },
    {
        "'async static' is not allowed; write 'static async' instead"_translatable,
        u8"'async static' is not allowed; write 'static async' instead",
        {
            u8"'async static' ist ung\u00fcltig. 'static asysc' anstattdessen verwenden.",
            u8"are you dyslexic or something?",
            u8"'async static' n'est pas autoris\u00e9 ; utiliser plut\u00f4t 'static async'",
            u8"'async static' n\u00e3o \u00e9 permitido; use 'static async'",
            u8"'async static' is not allowed; write 'static async' instead",
        },
    },
    {
        "'async' keyword is not allowed on getters or setters"_translatable,
        u8"'async' keyword is not allowed on getters or setters",
        {
            u8"'async' keyword is not allowed on getters or setters",
            u8"'async' keyword is not allowed on getters or setters",
            u8"'async' keyword is not allowed on getters or setters",
            u8"'async' keyword is not allowed on getters or setters",
            u8"'async' keyword is not allowed on getters or setters",
        },
    },
    {
        "'await' cannot be followed by an arrow function; use 'async' instead"_translatable,
        u8"'await' cannot be followed by an arrow function; use 'async' instead",
        {
            u8"'await' kann nicht von einer Arrow-Funktion gefolgt werden. 'async' anstattdessen verwenden.",
            u8"psst. 'async'.",
            u8"'await' ne peut \u00eatre suivi d'une fonction fl\u00e9ch\u00e9e ; utiliser plut\u00f4t 'async'",
            u8"'await' n\u00e3o pode ser procedido por uma arrow function; use 'async'",
            u8"'await' cannot be followed by an arrow function; use 'async' instead",
        },
    },
    {
        "'await' is only allowed in async functions"_translatable,
        u8"'await' is only allowed in async functions",
        {
            u8"'await' darf nur in mit 'asysc' markierten Funktionen verwendet werden",
            u8"this is sync country. get yer await outta here.",
            u8"'await' n'est autoris\u00e9 que dans des fonctions async",
            u8"'await' s\u00f3 \u00e9 permitido em fun\u00e7\u00f5es async",
            u8"'await' \u00e4r enbart till\u00e5tet i en 'async' funktion",
        },
    },
    {
        "'declare class' cannot contain static block"_translatable,
        u8"'declare class' cannot contain static block",
        {
            u8"'declare class' cannot contain static block",
            u8"'declare class' cannot contain static block",
            u8"'declare class' cannot contain static block",
            u8"'declare class' cannot contain static block",
            u8"'declare class' cannot contain static block",
        },
    },
    {
        "'declare class' fields cannot be initalized"_translatable,
        u8"'declare class' fields cannot be initalized",
        {
            u8"'declare class' fields cannot be initalized",
            u8"'declare class' fields cannot be initalized",
            u8"'declare class' fields cannot be initalized",
            u8"'declare class' fields cannot be initalized",
            u8"'declare class' fields cannot be initalized",
        },
    },
    {
        "'declare class' methods cannot be marked 'async'"_translatable,
        u8"'declare class' methods cannot be marked 'async'",
        {
            u8"'declare class' methods cannot be marked 'async'",
            u8"'declare class' methods cannot be marked 'async'",
            u8"'declare class' methods cannot be marked 'async'",
            u8"'declare class' methods cannot be marked 'async'",
            u8"'declare class' methods cannot be marked 'async'",
        },
    },
    {
        "'declare class' methods cannot be marked as a generator"_translatable,
        u8"'declare class' methods cannot be marked as a generator",
        {
            u8"'declare class' methods cannot be marked as a generator",
            u8"'declare class' methods cannot be marked as a generator",
            u8"'declare class' methods cannot be marked as a generator",
            u8"'declare class' methods cannot be marked as a generator",
            u8"'declare class' methods cannot be marked as a generator",
        },
    },
    {
        "'declare class' methods cannot contain a body"_translatable,
        u8"'declare class' methods cannot contain a body",
        {
            u8"'declare class' methods cannot contain a body",
            u8"'declare class' methods cannot contain a body",
            u8"'declare class' methods cannot contain a body",
            u8"'declare class' methods cannot contain a body",
            u8"'declare class' methods cannot contain a body",
        },
    },
    {
        "'declare function' cannot be marked 'async'"_translatable,
        u8"'declare function' cannot be marked 'async'",
        {
            u8"'declare function' cannot be marked 'async'",
            u8"'declare function' cannot be marked 'async'",
            u8"'declare function' cannot be marked 'async'",
            u8"'declare function' cannot be marked 'async'",
            u8"'declare function' cannot be marked 'async'",
        },
    },
    {
        "'declare function' cannot be marked as a generator"_translatable,
        u8"'declare function' cannot be marked as a generator",
        {
            u8"'declare function' cannot be marked as a generator",
            u8"'declare function' cannot be marked as a generator",
            u8"'declare function' cannot be marked as a generator",
            u8"'declare function' cannot be marked as a generator",
            u8"'declare function' cannot be marked as a generator",
        },
    },
    {
        "'declare function' cannot have a body"_translatable,
        u8"'declare function' cannot have a body",
        {
            u8"'declare function' cannot have a body",
            u8"'declare function' cannot have a body",
            u8"'declare function' cannot have a body",
            u8"'declare function' cannot have a body",
            u8"'declare function' cannot have a body",
        },
    },
    {
        "'declare function' here"_translatable,
        u8"'declare function' here",
        {
            u8"'declare function' here",
            u8"'declare function' here",
            u8"'declare function' here",
            u8"'declare function' here",
            u8"'declare function' here",
        },
    },
    {
        "'declare namespace' cannot contain statements, only declarations"_translatable,
        u8"'declare namespace' cannot contain statements, only declarations",
        {
            u8"'declare namespace' cannot contain statements, only declarations",
            u8"'declare namespace' cannot contain statements, only declarations",
            u8"'declare namespace' cannot contain statements, only declarations",
            u8"'declare namespace' cannot contain statements, only declarations",
            u8"'declare namespace' cannot contain statements, only declarations",
        },
    },
    {
        "'declare namespace' starts here"_translatable,
        u8"'declare namespace' starts here",
        {
            u8"'declare namespace' starts here",
            u8"'declare namespace' starts here",
            u8"'declare namespace' starts here",
            u8"'declare namespace' starts here",
            u8"'declare namespace' starts here",
        },
    },
    {
        "'declare {1}' cannot have initializer"_translatable,
        u8"'declare {1}' cannot have initializer",
        {
            u8"'declare {1}' cannot have initializer",
            u8"'declare {1}' cannot have initializer",
            u8"'declare {1}' cannot have initializer",
            u8"'declare {1}' cannot have initializer",
            u8"'declare {1}' cannot have initializer",
        },
    },
    {
        "'declare {1}' started here"_translatable,
        u8"'declare {1}' started here",
        {
            u8"'declare {1}' started here",
            u8"'declare {1}' started here",
            u8"'declare {1}' started here",
            u8"'declare {1}' started here",
            u8"'declare {1}' started here",
        },
    },
    {
        "'declare' here"_translatable,
        u8"'declare' here",
        {
            u8"'declare' here",
            u8"'declare' here",
            u8"'declare' here",
            u8"'declare' here",
            u8"'declare' here",
        },
    },
    {
        "'declare' is not allowed for TypeScript interface fields"_translatable,
        u8"'declare' is not allowed for TypeScript interface fields",
        {
            u8"'declare' is not allowed for TypeScript interface fields",
            u8"'declare' is not allowed for TypeScript interface fields",
            u8"'declare' is not allowed for TypeScript interface fields",
            u8"'declare' is not allowed for TypeScript interface fields",
            u8"'declare' is not allowed for TypeScript interface fields",
        },
    },
    {
        "'declare' or 'export' is required for {1} in .d.ts files"_translatable,
        u8"'declare' or 'export' is required for {1} in .d.ts files",
        {
            u8"'declare' or 'export' is required for {1} in .d.ts files",
            u8"'declare' or 'export' is required for {1} in .d.ts files",
            u8"'declare' or 'export' is required for {1} in .d.ts files",
            u8"'declare' or 'export' is required for {1} in .d.ts files",
            u8"'declare' or 'export' is required for {1} in .d.ts files",
        },
    },
    {
        "'declare' should not be written inside a 'declare namespace'"_translatable,
        u8"'declare' should not be written inside a 'declare namespace'",
        {
            u8"'declare' should not be written inside a 'declare namespace'",
            u8"'declare' should not be written inside a 'declare namespace'",
            u8"'declare' should not be written inside a 'declare namespace'",
            u8"'declare' should not be written inside a 'declare namespace'",
            u8"'declare' should not be written inside a 'declare namespace'",
        },
    },
    {
        "'declare' specified here"_translatable,
        u8"'declare' specified here",
        {
            u8"'declare' specified here",
            u8"'declare' specified here",
            u8"'declare' specified here",
            u8"'declare' specified here",
            u8"'declare' specified here",
        },
    },
    {
        "'do-while' loop"_translatable,
        u8"'do-while' loop",
        {
            u8"do-while-Schleife",
            u8"do-whiley do",
            u8"'do-while' loop",
            u8"loop 'do-while'",
            u8"'do-while' loop",
        },
    },
    {
        "'else' has no corresponding 'if'"_translatable,
        u8"'else' has no corresponding 'if'",
        {
            u8"'else' ohne zugeh\u00f6riges 'if'",
            u8"you're violating the laws of causality",
            u8"'else' n'a pas de 'if' correspondant",
            u8"'else' n\u00e3o tem um 'if' correspondente",
            u8"'else' har ingen anh\u00f6rig 'if'",
        },
    },
    {
        "'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead"_translatable,
        u8"'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead",
        {
            u8"'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead",
            u8"'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead",
            u8"'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead",
            u8"'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead",
            u8"'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead",
        },
    },
    {
        "'export as namespace' is not allowed in a namespace or module"_translatable,
        u8"'export as namespace' is not allowed in a namespace or module",
        {
            u8"'export as namespace' is not allowed in a namespace or module",
            u8"'export as namespace' is not allowed in a namespace or module",
            u8"'export as namespace' is not allowed in a namespace or module",
            u8"'export as namespace' is not allowed in a namespace or module",
            u8"'export as namespace' is not allowed in a namespace or module",
        },
    },
    {
        "'export as namespace' is only allowed in TypeScript .d.ts files"_translatable,
        u8"'export as namespace' is only allowed in TypeScript .d.ts files",
        {
            u8"'export as namespace' is only allowed in TypeScript .d.ts files",
            u8"'export as namespace' is only allowed in TypeScript .d.ts files",
            u8"'export as namespace' is only allowed in TypeScript .d.ts files",
            u8"'export as namespace' is only allowed in TypeScript .d.ts files",
            u8"'export as namespace' is only allowed in TypeScript .d.ts files",
        },
    },
    {
        "'export' keyword here"_translatable,
        u8"'export' keyword here",
        {
            u8"'export' keyword here",
            u8"'export' keyword here",
            u8"'export' keyword here",
            u8"'export' keyword here",
            u8"'export' keyword here",
        },
    },
    {
        "'export' must be on either all function signatures or none of them"_translatable,
        u8"'export' must be on either all function signatures or none of them",
        {
            u8"'export' must be on either all function signatures or none of them",
            u8"'export' must be on either all function signatures or none of them",
            u8"'export' must be on either all function signatures or none of them",
            u8"'export' must be on either all function signatures or none of them",
            u8"'export' must be on either all function signatures or none of them",
        },
    },
    {
        "'extends' must be before 'implements'"_translatable,
        u8"'extends' must be before 'implements'",
        {
            u8"'extends' must be before 'implements'",
            u8"'extends' must be before 'implements'",
            u8"'extends' must be before 'implements'",
            u8"'extends' precisa ficar antes do 'implements'",
            u8"'extends' must be before 'implements'",
        },
    },
    {
        "'for' loop"_translatable,
        u8"'for' loop",
        {
            u8"for-Schleife",
            u8"'for' loop \U0001f503",
            u8"'for' loop",
            u8"loop 'for'",
            u8"'for' loop",
        },
    },
    {
        "'function async' is not allowed; write 'async function' instead"_translatable,
        u8"'function async' is not allowed; write 'async function' instead",
        {
            u8"'function async' is not allowed; write 'async function' instead",
            u8"'function async' is not allowed; write 'async function' instead",
            u8"'function async' is not allowed; write 'async function' instead",
            u8"'function async' is not allowed; write 'async function' instead",
            u8"'function async' is not allowed; write 'async function' instead",
        },
    },
    {
        "'function' is here"_translatable,
        u8"'function' is here",
        {
            u8"'function' is here",
            u8"'function' is here",
            u8"'function' is here",
            u8"'function' est\u00e1 aqui",
            u8"'function' is here",
        },
    },
    {
        "'if' statement"_translatable,
        u8"'if' statement",
        {
            u8"if-Anweisung",
            u8"when (not if) statement",
            u8"'if' statement",
            u8"instru\u00e7\u00e3o 'if'",
            u8"'if' statement",
        },
    },
    {
        "'in' disallowed in C-style for loop initializer"_translatable,
        u8"'in' disallowed in C-style for loop initializer",
        {
            u8"Ung\u00fcltiges 'in' innerhalb Initialisierung der C-\u00e4hnlichen for-Schleife",
            u8"is this a for-in loop or what?",
            u8"'in' d\u00e9sactiv\u00e9 dans l'initialisation des boucles for de style C",
            u8"'in' n\u00e3o \u00e9 permitido em um inicializador de um for",
            u8"'in' \u00e4r otill\u00e5tet i C-stil for loop initierare",
        },
    },
    {
        "'infer' is only allowed between 'extends' and '?' in conditional types"_translatable,
        u8"'infer' is only allowed between 'extends' and '?' in conditional types",
        {
            u8"'infer' is only allowed between 'extends' and '?' in conditional types",
            u8"'infer' is only allowed between 'extends' and '?' in conditional types",
            u8"'infer' is only allowed between 'extends' and '?' in conditional types",
            u8"'infer' is only allowed between 'extends' and '?' in conditional types",
            u8"'infer' is only allowed between 'extends' and '?' in conditional types",
        },
    },
    {
        "'out in' is not allowed; write 'in out' instead"_translatable,
        u8"'out in' is not allowed; write 'in out' instead",
        {
            u8"'out in' is not allowed; write 'in out' instead",
            u8"'out in' is not allowed; write 'in out' instead",
            u8"'out in' is not allowed; write 'in out' instead",
            u8"'out in' is not allowed; write 'in out' instead",
            u8"'out in' is not allowed; write 'in out' instead",
        },
    },
    {
        "'private' is not allowed in JavaScript"_translatable,
        u8"'private' is not allowed in JavaScript",
        {
            u8"'private' is not allowed in JavaScript",
            u8"'private' is not allowed in JavaScript",
            u8"'private' is not allowed in JavaScript",
            u8"'private' n\u00e3o \u00e9 permitido em JavaScript",
            u8"'private' is not allowed in JavaScript",
        },
    },
    {
        "'protected' is not allowed in JavaScript"_translatable,
        u8"'protected' is not allowed in JavaScript",
        {
            u8"'protected' is not allowed in JavaScript",
            u8"'protected' is not allowed in JavaScript",
            u8"'protected' is not allowed in JavaScript",
            u8"'protected' n\u00e3o \u00e9 permitido em JavaScript",
            u8"'protected' is not allowed in JavaScript",
        },
    },
    {
        "'public' is not allowed in JavaScript"_translatable,
        u8"'public' is not allowed in JavaScript",
        {
            u8"'public' is not allowed in JavaScript",
            u8"'public' is not allowed in JavaScript",
            u8"'public' is not allowed in JavaScript",
            u8"'public' n\u00e3o \u00e9 permitido em JavaScript",
            u8"'public' is not allowed in JavaScript",
        },
    },
    {
        "'readonly static' is not allowed; write 'static readonly' instead"_translatable,
        u8"'readonly static' is not allowed; write 'static readonly' instead",
        {
            u8"'readonly static' is not allowed; write 'static readonly' instead",
            u8"'readonly static' is not allowed; write 'static readonly' instead",
            u8"'readonly static' is not allowed; write 'static readonly' instead",
            u8"'readonly static' n\u00e3o \u00e9 permitido; use 'static readonly'",
            u8"'readonly static' is not allowed; write 'static readonly' instead",
        },
    },
    {
        "'readonly' only works with array types and tuple types"_translatable,
        u8"'readonly' only works with array types and tuple types",
        {
            u8"'readonly' only works with array types and tuple types",
            u8"'readonly' only works with array types and tuple types",
            u8"'readonly' only works with array types and tuple types",
            u8"'readonly' s\u00f3 funciona com arrays e tuplas",
            u8"'readonly' only works with array types and tuple types",
        },
    },
    {
        "'this' must be the first parameter"_translatable,
        u8"'this' must be the first parameter",
        {
            u8"'this' must be the first parameter",
            u8"'this' must be the first parameter",
            u8"'this' must be the first parameter",
            u8"'this' precisa ser o primeiro par\u00e2metro",
            u8"'this' must be the first parameter",
        },
    },
    {
        "'this' parameter not allowed when destructuring"_translatable,
        u8"'this' parameter not allowed when destructuring",
        {
            u8"'this' parameter not allowed when destructuring",
            u8"'this' parameter not allowed when destructuring",
            u8"'this' parameter not allowed when destructuring",
            u8"par\u00e2metro 'this' n\u00e3o \u00e9 permitido ao desestruturar",
            u8"'this' parameter not allowed when destructuring",
        },
    },
    {
        "'this' parameters are not allowed in JavaScript"_translatable,
        u8"'this' parameters are not allowed in JavaScript",
        {
            u8"'this' parameters are not allowed in JavaScript",
            u8"'this' parameters are not allowed in JavaScript",
            u8"'this' parameters are not allowed in JavaScript",
            u8"par\u00e2metro 'this' n\u00e3o \u00e9 permitido em JavaScript",
            u8"'this' parameters are not allowed in JavaScript",
        },
    },
    {
        "'this' parameters are not allowed in arrow functions"_translatable,
        u8"'this' parameters are not allowed in arrow functions",
        {
            u8"'this' parameters are not allowed in arrow functions",
            u8"'this' parameters are not allowed in arrow functions",
            u8"'this' parameters are not allowed in arrow functions",
            u8"par\u00e2metro 'this' n\u00e3o \u00e9 permitido em arrow functions",
            u8"'this' parameters are not allowed in arrow functions",
        },
    },
    {
        "'type' cannot be used twice in export"_translatable,
        u8"'type' cannot be used twice in export",
        {
            u8"'type' cannot be used twice in export",
            u8"'type' cannot be used twice in export",
            u8"'type' cannot be used twice in export",
            u8"'type' n\u00e3o pode ser usado duas vezes no export",
            u8"'type' cannot be used twice in export",
        },
    },
    {
        "'type' cannot be used twice in import"_translatable,
        u8"'type' cannot be used twice in import",
        {
            u8"'type' cannot be used twice in import",
            u8"'type' cannot be used twice in import",
            u8"'type' cannot be used twice in import",
            u8"'type' n\u00e3o pode ser usado duas vezes na importa\u00e7\u00e3o",
            u8"'type' cannot be used twice in import",
        },
    },
    {
        "'typeof' type"_translatable,
        u8"'typeof' type",
        {
            u8"'typeof' type",
            u8"'typeof' type",
            u8"'typeof' type",
            u8"'typeof' type",
            u8"'typeof' type",
        },
    },
    {
        "'while' loop"_translatable,
        u8"'while' loop",
        {
            u8"while-Schleife",
            u8"whenever loop",
            u8"'while' loop",
            u8"loop 'while'",
            u8"'while' loop",
        },
    },
    {
        "'with' statement"_translatable,
        u8"'with' statement",
        {
            u8"with-Anweisung",
            u8"what-the-heck-is-wrong-with statement",
            u8"'with' statement",
            u8"instru\u00e7\u00e3o 'with'",
            u8"'with' statement",
        },
    },
    {
        "'{0} []' is always '{1}'"_translatable,
        u8"'{0} []' is always '{1}'",
        {
            u8"'{0} []' is always '{1}'",
            u8"'{0} []' is always '{1}'",
            u8"'{0} []' is always '{1}'",
            u8"'{0} []' \u00e9 sempre '{1}'",
            u8"'{0} []' is always '{1}'",
        },
    },
    {
        "'{0}' access specifier must precede '{1}'"_translatable,
        u8"'{0}' access specifier must precede '{1}'",
        {
            u8"'{0}' access specifier must precede '{1}'",
            u8"'{0}' access specifier must precede '{1}'",
            u8"'{0}' access specifier must precede '{1}'",
            u8"'{0}' access specifier must precede '{1}'",
            u8"'{0}' access specifier must precede '{1}'",
        },
    },
    {
        "'{0}' already written here"_translatable,
        u8"'{0}' already written here",
        {
            u8"'{0}' already written here",
            u8"'{0}' already written here",
            u8"'{0}' already written here",
            u8"'{0}' already written here",
            u8"'{0}' already written here",
        },
    },
    {
        "'{0}' found here"_translatable,
        u8"'{0}' found here",
        {
            u8"'{0}' ist hier",
            u8"here's the '{0}'",
            u8"'{0}' found here",
            u8"'{0}' encontrado aqui",
            u8"'{0}' found here",
        },
    },
    {
        "'{0}' here"_translatable,
        u8"'{0}' here",
        {
            u8"'{0}' here",
            u8"'{0}' here",
            u8"'{0}' here",
            u8"'{0}' here",
            u8"'{0}' here",
        },
    },
    {
        "'{0}' is missing on overloaded method"_translatable,
        u8"'{0}' is missing on overloaded method",
        {
            u8"'{0}' is missing on overloaded method",
            u8"'{0}' is missing on overloaded method",
            u8"'{0}' is missing on overloaded method",
            u8"'{0}' is missing on overloaded method",
            u8"'{0}' is missing on overloaded method",
        },
    },
    {
        "'{0}' is not allowed for strings; use {1} instead"_translatable,
        u8"'{0}' is not allowed for strings; use {1} instead",
        {
            u8"'{0}' ist f\u00fcr Strings nicht erlaubt. '{1}' anstattdessen verwenden.",
            u8"smart quotes \U0001f9e0 require the SmartyPantsJS DLC",
            u8"'{0}' is not allowed for strings; use {1} instead",
            u8"'{0}' n\u00e3o \u00e9 permitido para strings; use {1}",
            u8"'{0}' is not allowed for strings; use {1} instead",
        },
    },
    {
        "'{0}' is not allowed in TypeScript overload signatures"_translatable,
        u8"'{0}' is not allowed in TypeScript overload signatures",
        {
            u8"'{0}' is not allowed in TypeScript overload signatures",
            u8"'{0}' is not allowed in TypeScript overload signatures",
            u8"'{0}' is not allowed in TypeScript overload signatures",
            u8"'{0}' is not allowed in TypeScript overload signatures",
            u8"'{0}' is not allowed in TypeScript overload signatures",
        },
    },
    {
        "'{0}' is not allowed on methods"_translatable,
        u8"'{0}' is not allowed on methods",
        {
            u8"'{0}' is not allowed on methods",
            u8"'{0}' is not allowed on methods",
            u8"'{0}' is not allowed on methods",
            u8"'{0}' n\u00e3o \u00e9 permitido em m\u00e9todos",
            u8"'{0}' is not allowed on methods",
        },
    },
    {
        "'{0}' is not allowed with '{1}'"_translatable,
        u8"'{0}' is not allowed with '{1}'",
        {
            u8"'{0}' is not allowed with '{1}'",
            u8"'{0}' is not allowed with '{1}'",
            u8"'{0}' is not allowed with '{1}'",
            u8"'{0}' is not allowed with '{1}'",
            u8"'{0}' is not allowed with '{1}'",
        },
    },
    {
        "'{0}' must precede '{1}'"_translatable,
        u8"'{0}' must precede '{1}'",
        {
            u8"'{0}' must precede '{1}'",
            u8"'{0}' must precede '{1}'",
            u8"'{0}' must precede '{1}'",
            u8"'{0}' must precede '{1}'",
            u8"'{0}' must precede '{1}'",
        },
    },
    {
        "'{0}' operator cannot be used before '**' without parentheses"_translatable,
        u8"'{0}' operator cannot be used before '**' without parentheses",
        {
            u8"Der Operator '{0}' kann nicht vor '**' ohne Klammern benutzt werden",
            u8"'{0}' and '**' don't mix",
            u8"'{0}' operator cannot be used before '**' without parentheses",
            u8"operador '{0}' n\u00e3o pode ser usado antes de '**' sem par\u00eanteses",
            u8"'{0}' operator cannot be used before '**' without parentheses",
        },
    },
    {
        "'{0}' variance specifier cannot be listed twice"_translatable,
        u8"'{0}' variance specifier cannot be listed twice",
        {
            u8"'{0}' variance specifier cannot be listed twice",
            u8"'{0}' variance specifier cannot be listed twice",
            u8"'{0}' variance specifier cannot be listed twice",
            u8"'{0}' variance specifier cannot be listed twice",
            u8"'{0}' variance specifier cannot be listed twice",
        },
    },
    {
        "'{1}' is missing on overload signature"_translatable,
        u8"'{1}' is missing on overload signature",
        {
            u8"'{1}' is missing on overload signature",
            u8"'{1}' is missing on overload signature",
            u8"'{1}' is missing on overload signature",
            u8"'{1}' is missing on overload signature",
            u8"'{1}' is missing on overload signature",
        },
    },
    {
        "'{1}' statement starts here"_translatable,
        u8"'{1}' statement starts here",
        {
            u8"'{1}' statement starts here",
            u8"'{1}' statement starts here",
            u8"'{1}' statement starts here",
            u8"'{1}' statement starts here",
            u8"'{1}' statement starts here",
        },
    },
    {
        "'}' is not allowed directly in JSX text; write {{'}'} instead"_translatable,
        u8"'}' is not allowed directly in JSX text; write {{'}'} instead",
        {
            u8"'}' darf nicht direkt in JSX-Text verwendet werden. Anstattdessen {{'}'} schreiben",
            u8"Facebook says '}' is not allowed; write {{'}'} instead",
            u8"'}' is not allowed directly in JSX text; write {{'}'} instead",
            u8"'}' n\u00e3o \u00e9 permitido diretamente em um texto JSX; use {{'}'}",
            u8"'}' is not allowed directly in JSX text; write {{'}'} instead",
        },
    },
    {
        ".d.ts files cannot contain statements, only declarations"_translatable,
        u8".d.ts files cannot contain statements, only declarations",
        {
            u8".d.ts files cannot contain statements, only declarations",
            u8".d.ts files cannot contain statements, only declarations",
            u8".d.ts files cannot contain statements, only declarations",
            u8".d.ts files cannot contain statements, only declarations",
            u8".d.ts files cannot contain statements, only declarations",
        },
    },
    {
        "BigInt literal contains decimal point"_translatable,
        u8"BigInt literal contains decimal point",
        {
            u8"BigInt-Literal mit Dezimalpunkt",
            u8"it's Big*Int*, not Big*Decimal*",
            u8"le lit\u00e9ral BigInt contient un s\u00e9parateur de d\u00e9cimales",
            u8"valor BigInt cont\u00e9m casa decimal",
            u8"BigInt heltallitter\u00e4r inneh\u00e5ller decimaler",
        },
    },
    {
        "BigInt literal contains exponent"_translatable,
        u8"BigInt literal contains exponent",
        {
            u8"BigInt-Literal mit Exponenten",
            u8"BigExponInt is an ES2069 feature",
            u8"le lit\u00e9ral BigInt contient un exposant",
            u8"valor BigInt cont\u00e9m expoente",
            u8"BigInt heltallitter\u00e4r inneh\u00e5ller exponent",
        },
    },
    {
        "C-style for loop is missing its third component"_translatable,
        u8"C-style for loop is missing its third component",
        {
            u8"C-\u00e4hnliche for-Schleife fehlt drittes Argument",
            u8"you forgot ;i++",
            u8"troisi\u00e8me argument manquant pour la boucle de style C",
            u8"falta o terceiro componente do for",
            u8"C-stil 'for' loop saknar tredje komponentent",
        },
    },
    {
        "C-style for loops have only three semicolon-separated components"_translatable,
        u8"C-style for loops have only three semicolon-separated components",
        {
            u8"C-\u00e4hnliche for-Schleifen haben nur drei durch Semikolon getrennte Komponenten",
            u8"you went overboard with the semicolons",
            u8"les boucles for de style C ne poss\u00e8dent que trois composantes s\u00e9par\u00e9es par des points-virgules",
            u8"loops 'for' no estilo C s\u00f3 devem ter tr\u00eas componentes separados por ponto e v\u00edrgula",
            u8"C-stil for loops har enbart tre semikolon separerande komponenter",
        },
    },
    {
        "JSON syntax error"_translatable,
        u8"JSON syntax error",
        {
            u8"Syntaxfehler in JSON",
            u8"yeah, JSON sucks; try quick-lint-json",
            u8"erreur de syntaxe JSON",
            u8"erro de sintaxe de JSON",
            u8"JSON syntax error",
        },
    },
    {
        "JSX prop is missing an expression"_translatable,
        u8"JSX prop is missing an expression",
        {
            u8"JSX prop is missing an expression",
            u8"JSX prop is missing an expression",
            u8"JSX prop is missing an expression",
            u8"JSX prop is missing an expression",
            u8"JSX prop is missing an expression",
        },
    },
    {
        "Keywords in TypeScript does not allow escape characters"_translatable,
        u8"Keywords in TypeScript does not allow escape characters",
        {
            u8"Keywords in TypeScript does not allow escape characters",
            u8"Keywords in TypeScript does not allow escape characters",
            u8"Keywords in TypeScript does not allow escape characters",
            u8"Keywords in TypeScript does not allow escape characters",
            u8"Keywords in TypeScript does not allow escape characters",
        },
    },
    {
        "React/JSX is not allowed in TypeScript code"_translatable,
        u8"React/JSX is not allowed in TypeScript code",
        {
            u8"React/JSX is not allowed in TypeScript code",
            u8"React/JSX is not allowed in TypeScript code",
            u8"React/JSX is not allowed in TypeScript code",
            u8"React/JSX n\u00e3o \u00e9 permitido em c\u00f3digo TypeScript",
            u8"React/JSX is not allowed in TypeScript code",
        },
    },
    {
        "React/JSX is not allowed in vanilla JavaScript code"_translatable,
        u8"React/JSX is not allowed in vanilla JavaScript code",
        {
            u8"React/JSX is not allowed in vanilla JavaScript code",
            u8"React/JSX is not allowed in vanilla JavaScript code",
            u8"React/JSX is not allowed in vanilla JavaScript code",
            u8"React/JSX n\u00e3o \u00e9 permitido em c\u00f3digo JavaScript vanilla",
            u8"React/JSX is not allowed in vanilla JavaScript code",
        },
    },
    {
        "RegExp literal flags cannot contain Unicode escapes"_translatable,
        u8"RegExp literal flags cannot contain Unicode escapes",
        {
            u8"RegExp-Literale d\u00fcrfen keine Unicode Escapes enthalten",
            u8"keep your RegExp flags simple, please",
            u8"un litt\u00e9ral RegExp ne peut contenir des \u00e9chappements Unicode",
            u8"flags do RegExp n\u00e3o podem conter sequ\u00eancias de escape Unicode",
            u8"RegExp literal flags cannot contain Unicode escapes",
        },
    },
    {
        "TypeScript 'as' type assertions are not allowed in JavaScript"_translatable,
        u8"TypeScript 'as' type assertions are not allowed in JavaScript",
        {
            u8"TypeScript 'as' type assertions are not allowed in JavaScript",
            u8"TypeScript 'as' type assertions are not allowed in JavaScript",
            u8"TypeScript 'as' type assertions are not allowed in JavaScript",
            u8"asser\u00e7\u00f5es de tipo de TypeScript com 'as' n\u00e3o s\u00e3o permitidas em JavaScript",
            u8"TypeScript 'as' type assertions are not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'declare abstract class' is not allowed in JavaScript"_translatable,
        u8"TypeScript 'declare abstract class' is not allowed in JavaScript",
        {
            u8"TypeScript 'declare abstract class' is not allowed in JavaScript",
            u8"TypeScript 'declare abstract class' is not allowed in JavaScript",
            u8"TypeScript 'declare abstract class' is not allowed in JavaScript",
            u8"TypeScript 'declare abstract class' is not allowed in JavaScript",
            u8"TypeScript 'declare abstract class' is not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'declare class' is not allowed in JavaScript"_translatable,
        u8"TypeScript 'declare class' is not allowed in JavaScript",
        {
            u8"TypeScript 'declare class' is not allowed in JavaScript",
            u8"TypeScript 'declare class' is not allowed in JavaScript",
            u8"TypeScript 'declare class' is not allowed in JavaScript",
            u8"TypeScript 'declare class' is not allowed in JavaScript",
            u8"TypeScript 'declare class' is not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'declare function' is not allowed in JavaScript"_translatable,
        u8"TypeScript 'declare function' is not allowed in JavaScript",
        {
            u8"TypeScript 'declare function' is not allowed in JavaScript",
            u8"TypeScript 'declare function' is not allowed in JavaScript",
            u8"TypeScript 'declare function' is not allowed in JavaScript",
            u8"TypeScript 'declare function' is not allowed in JavaScript",
            u8"TypeScript 'declare function' is not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'declare global' is not allowed in JavaScript"_translatable,
        u8"TypeScript 'declare global' is not allowed in JavaScript",
        {
            u8"TypeScript 'declare global' is not allowed in JavaScript",
            u8"TypeScript 'declare global' is not allowed in JavaScript",
            u8"TypeScript 'declare global' is not allowed in JavaScript",
            u8"TypeScript 'declare global' is not allowed in JavaScript",
            u8"TypeScript 'declare global' is not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'declare global' is not allowed in namespaces"_translatable,
        u8"TypeScript 'declare global' is not allowed in namespaces",
        {
            u8"TypeScript 'declare global' is not allowed in namespaces",
            u8"TypeScript 'declare global' is not allowed in namespaces",
            u8"TypeScript 'declare global' is not allowed in namespaces",
            u8"TypeScript 'declare global' is not allowed in namespaces",
            u8"TypeScript 'declare global' is not allowed in namespaces",
        },
    },
    {
        "TypeScript 'declare module' with string name is not allowed in namespaces"_translatable,
        u8"TypeScript 'declare module' with string name is not allowed in namespaces",
        {
            u8"TypeScript 'declare module' with string name is not allowed in namespaces",
            u8"TypeScript 'declare module' with string name is not allowed in namespaces",
            u8"TypeScript 'declare module' with string name is not allowed in namespaces",
            u8"TypeScript 'declare module' with string name is not allowed in namespaces",
            u8"TypeScript 'declare module' with string name is not allowed in namespaces",
        },
    },
    {
        "TypeScript 'declare {1}' is not allowed in JavaScript"_translatable,
        u8"TypeScript 'declare {1}' is not allowed in JavaScript",
        {
            u8"TypeScript 'declare {1}' is not allowed in JavaScript",
            u8"TypeScript 'declare {1}' is not allowed in JavaScript",
            u8"TypeScript 'declare {1}' is not allowed in JavaScript",
            u8"TypeScript 'declare {1}' is not allowed in JavaScript",
            u8"TypeScript 'declare {1}' is not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'declare' fields are now allowed in JavaScript"_translatable,
        u8"TypeScript 'declare' fields are now allowed in JavaScript",
        {
            u8"TypeScript 'declare' fields are now allowed in JavaScript",
            u8"TypeScript 'declare' fields are now allowed in JavaScript",
            u8"TypeScript 'declare' fields are now allowed in JavaScript",
            u8"TypeScript 'declare' fields are now allowed in JavaScript",
            u8"TypeScript 'declare' fields are now allowed in JavaScript",
        },
    },
    {
        "TypeScript 'implements' is not allowed in JavaScript"_translatable,
        u8"TypeScript 'implements' is not allowed in JavaScript",
        {
            u8"TypeScript 'implements' is not allowed in JavaScript",
            u8"TypeScript 'implements' is not allowed in JavaScript",
            u8"TypeScript 'implements' is not allowed in JavaScript",
            u8"'implements' n\u00e3o \u00e9 permitido em JavaScript",
            u8"TypeScript 'implements' is not allowed in JavaScript",
        },
    },
    {
        "TypeScript 'satisfies' operator is not allowed in JavaScript"_translatable,
        u8"TypeScript 'satisfies' operator is not allowed in JavaScript",
        {
            u8"TypeScript 'satisfies' operator is not allowed in JavaScript",
            u8"TypeScript 'satisfies' operator is not allowed in JavaScript",
            u8"TypeScript 'satisfies' operator is not allowed in JavaScript",
            u8"TypeScript 'satisfies' operator is not allowed in JavaScript",
            u8"TypeScript 'satisfies' operator is not allowed in JavaScript",
        },
    },
    {
        "TypeScript <Type> type assertions are not allowed in JSX mode"_translatable,
        u8"TypeScript <Type> type assertions are not allowed in JSX mode",
        {
            u8"TypeScript <Type> type assertions are not allowed in JSX mode",
            u8"TypeScript <Type> type assertions are not allowed in JSX mode",
            u8"TypeScript <Type> type assertions are not allowed in JSX mode",
            u8"asser\u00e7\u00f5es de tipo de TypeScript com <Type> n\u00e3o s\u00e3o permitidas em modo JSX",
            u8"TypeScript <Type> type assertions are not allowed in JSX mode",
        },
    },
    {
        "TypeScript assignment-asserted fields are not supported in JavaScript"_translatable,
        u8"TypeScript assignment-asserted fields are not supported in JavaScript",
        {
            u8"TypeScript assignment-asserted fields are not supported in JavaScript",
            u8"TypeScript assignment-asserted fields are not supported in JavaScript",
            u8"TypeScript assignment-asserted fields are not supported in JavaScript",
            u8"campos com asser\u00e7\u00e3o de atribui\u00e7\u00e3o do TypeScript n\u00e3o s\u00e3o suportados em JavaScript",
            u8"TypeScript assignment-asserted fields are not supported in JavaScript",
        },
    },
    {
        "TypeScript generics are not allowed in JavaScript code"_translatable,
        u8"TypeScript generics are not allowed in JavaScript code",
        {
            u8"TypeScript generics are not allowed in JavaScript code",
            u8"TypeScript generics are not allowed in JavaScript code",
            u8"TypeScript generics are not allowed in JavaScript code",
            u8"generics do TypeScript n\u00e3o s\u00e3o permitidos em c\u00f3digo JavaScript",
            u8"TypeScript generics are not allowed in JavaScript code",
        },
    },
    {
        "TypeScript global declaration block must use 'declare'"_translatable,
        u8"TypeScript global declaration block must use 'declare'",
        {
            u8"TypeScript global declaration block must use 'declare'",
            u8"TypeScript global declaration block must use 'declare'",
            u8"TypeScript global declaration block must use 'declare'",
            u8"TypeScript global declaration block must use 'declare'",
            u8"TypeScript global declaration block must use 'declare'",
        },
    },
    {
        "TypeScript import aliases are not allowed in JavaScript"_translatable,
        u8"TypeScript import aliases are not allowed in JavaScript",
        {
            u8"TypeScript import aliases are not allowed in JavaScript",
            u8"TypeScript import aliases are not allowed in JavaScript",
            u8"TypeScript import aliases are not allowed in JavaScript",
            u8"apelidos de importa\u00e7\u00e3o do TypeScript n\u00e3o s\u00e3o permitidos em JavaScript",
            u8"TypeScript import aliases are not allowed in JavaScript",
        },
    },
    {
        "TypeScript interface fields cannot be initalized"_translatable,
        u8"TypeScript interface fields cannot be initalized",
        {
            u8"TypeScript interface fields cannot be initalized",
            u8"why are you trying to initialize this field? it's an interface!",
            u8"TypeScript interface fields cannot be initalized",
            u8"campos de interfaces do TypeScript n\u00e3o podem ser inicializados",
            u8"TypeScript interface fields cannot be initalized",
        },
    },
    {
        "TypeScript interface methods cannot be marked 'async'"_translatable,
        u8"TypeScript interface methods cannot be marked 'async'",
        {
            u8"TypeScript interface methods cannot be marked 'async'",
            u8"interfaces are allergic to async methods",
            u8"TypeScript interface methods cannot be marked 'async'",
            u8"m\u00e9todos de interfaces do TypeScript n\u00e3o podem ser marcados como 'async'",
            u8"TypeScript interface methods cannot be marked 'async'",
        },
    },
    {
        "TypeScript interface methods cannot be marked as a generator"_translatable,
        u8"TypeScript interface methods cannot be marked as a generator",
        {
            u8"TypeScript interface methods cannot be marked as a generator",
            u8"interfaces are allergic to generator methods",
            u8"TypeScript interface methods cannot be marked as a generator",
            u8"m\u00e9todos de interfaces do TypeScript n\u00e3o podem ser marcados como generators",
            u8"TypeScript interface methods cannot be marked as a generator",
        },
    },
    {
        "TypeScript interface methods cannot contain a body"_translatable,
        u8"TypeScript interface methods cannot contain a body",
        {
            u8"TypeScript interface methods cannot contain a body",
            u8"you probably want a class, not an interface",
            u8"TypeScript interface methods cannot contain a body",
            u8"m\u00e9todos de interface do TypeScript n\u00e3o podem ter conte\u00fado",
            u8"TypeScript interface methods cannot contain a body",
        },
    },
    {
        "TypeScript interface properties are always public and cannot be marked protected"_translatable,
        u8"TypeScript interface properties are always public and cannot be marked protected",
        {
            u8"TypeScript interface properties are always public and cannot be marked protected",
            u8"TypeScript interface properties are always public and cannot be marked protected",
            u8"TypeScript interface properties are always public and cannot be marked protected",
            u8"propriedades de interfaces de TypeScript s\u00e3o sempre p\u00fablicas e n\u00e3o podem ser marcadas como protected",
            u8"TypeScript interface properties are always public and cannot be marked protected",
        },
    },
    {
        "TypeScript interface properties cannot be 'static'"_translatable,
        u8"TypeScript interface properties cannot be 'static'",
        {
            u8"TypeScript interface properties cannot be 'static'",
            u8"static makes no sense in interfaces",
            u8"TypeScript interface properties cannot be 'static'",
            u8"propriedades de interfaces do TypeScript n\u00e3o podem ser 'static'",
            u8"TypeScript interface properties cannot be 'static'",
        },
    },
    {
        "TypeScript namespace aliases are not allowed in JavaScript"_translatable,
        u8"TypeScript namespace aliases are not allowed in JavaScript",
        {
            u8"TypeScript namespace aliases are not allowed in JavaScript",
            u8"TypeScript namespace aliases are not allowed in JavaScript",
            u8"TypeScript namespace aliases are not allowed in JavaScript",
            u8"TypeScript namespace aliases are not allowed in JavaScript",
            u8"TypeScript namespace aliases are not allowed in JavaScript",
        },
    },
    {
        "TypeScript namespaces are not allowed in JavaScript"_translatable,
        u8"TypeScript namespaces are not allowed in JavaScript",
        {
            u8"TypeScript namespaces are not allowed in JavaScript",
            u8"TypeScript namespaces are not allowed in JavaScript",
            u8"TypeScript namespaces are not allowed in JavaScript",
            u8"namespaces do TypeScript n\u00e3o s\u00e3o permitidos em JavaScript",
            u8"TypeScript namespaces are not allowed in JavaScript",
        },
    },
    {
        "TypeScript non-null assertion is not allowed on parameters"_translatable,
        u8"TypeScript non-null assertion is not allowed on parameters",
        {
            u8"TypeScript non-null assertion is not allowed on parameters",
            u8"TypeScript non-null assertion is not allowed on parameters",
            u8"TypeScript non-null assertion is not allowed on parameters",
            u8"asser\u00e7\u00f5es de valores n\u00e3o-nulos do TypeScript n\u00e3o s\u00e3o permitidos em par\u00e2metros",
            u8"TypeScript non-null assertion is not allowed on parameters",
        },
    },
    {
        "TypeScript non-null assertions are not allowed in JavaScript"_translatable,
        u8"TypeScript non-null assertions are not allowed in JavaScript",
        {
            u8"TypeScript non-null assertions are not allowed in JavaScript",
            u8"TypeScript non-null assertions are not allowed in JavaScript",
            u8"TypeScript non-null assertions are not allowed in JavaScript",
            u8"asser\u00e7\u00f5es de valores n\u00e3o-nulos do TypeScript n\u00e3o s\u00e3o permitidos em JavaScript",
            u8"TypeScript non-null assertions are not allowed in JavaScript",
        },
    },
    {
        "TypeScript optional parameter requires parentheses"_translatable,
        u8"TypeScript optional parameter requires parentheses",
        {
            u8"TypeScript optional parameter requires parentheses",
            u8"TypeScript optional parameter requires parentheses",
            u8"TypeScript optional parameter requires parentheses",
            u8"par\u00e2metros opcionais do TypeScript requerem par\u00eanteses",
            u8"TypeScript optional parameter requires parentheses",
        },
    },
    {
        "TypeScript optional parameter with type annotation requires parentheses"_translatable,
        u8"TypeScript optional parameter with type annotation requires parentheses",
        {
            u8"TypeScript optional parameter with type annotation requires parentheses",
            u8"TypeScript optional parameter with type annotation requires parentheses",
            u8"TypeScript optional parameter with type annotation requires parentheses",
            u8"par\u00e2metros opcionais do TypeScript com anota\u00e7\u00e3o de tipo requerem par\u00eanteses",
            u8"TypeScript optional parameter with type annotation requires parentheses",
        },
    },
    {
        "TypeScript optional parameters are not allowed in JavaScript"_translatable,
        u8"TypeScript optional parameters are not allowed in JavaScript",
        {
            u8"TypeScript optional parameters are not allowed in JavaScript",
            u8"TypeScript optional parameters are not allowed in JavaScript",
            u8"TypeScript optional parameters are not allowed in JavaScript",
            u8"par\u00e2metros opcionais do TypeScript n\u00e3o s\u00e3o permitidos em JavaScript",
            u8"TypeScript optional parameters are not allowed in JavaScript",
        },
    },
    {
        "TypeScript optional properties are not allowed in JavaScript code"_translatable,
        u8"TypeScript optional properties are not allowed in JavaScript code",
        {
            u8"TypeScript optional properties are not allowed in JavaScript code",
            u8"TypeScript optional properties are not allowed in JavaScript code",
            u8"TypeScript optional properties are not allowed in JavaScript code",
            u8"propriedades opcionais do TypeScript n\u00e3o s\u00e3o permitidas em c\u00f3digo JavaScript",
            u8"TypeScript optional properties are not allowed in JavaScript code",
        },
    },
    {
        "TypeScript overload signature can only have one semicolon"_translatable,
        u8"TypeScript overload signature can only have one semicolon",
        {
            u8"TypeScript overload signature can only have one semicolon",
            u8"TypeScript overload signature can only have one semicolon",
            u8"TypeScript overload signature can only have one semicolon",
            u8"TypeScript overload signature can only have one semicolon",
            u8"TypeScript overload signature can only have one semicolon",
        },
    },
    {
        "TypeScript parameter decorators are not allowed in JavaScript"_translatable,
        u8"TypeScript parameter decorators are not allowed in JavaScript",
        {
            u8"TypeScript parameter decorators are not allowed in JavaScript",
            u8"TypeScript parameter decorators are not allowed in JavaScript",
            u8"TypeScript parameter decorators are not allowed in JavaScript",
            u8"TypeScript parameter decorators are not allowed in JavaScript",
            u8"TypeScript parameter decorators are not allowed in JavaScript",
        },
    },
    {
        "TypeScript parameter properties are not allowed in JavaScript"_translatable,
        u8"TypeScript parameter properties are not allowed in JavaScript",
        {
            u8"TypeScript parameter properties are not allowed in JavaScript",
            u8"TypeScript parameter properties are not allowed in JavaScript",
            u8"TypeScript parameter properties are not allowed in JavaScript",
            u8"TypeScript parameter properties are not allowed in JavaScript",
            u8"TypeScript parameter properties are not allowed in JavaScript",
        },
    },
    {
        "TypeScript requires whitespace between '>' and '=' here"_translatable,
        u8"TypeScript requires whitespace between '>' and '=' here",
        {
            u8"TypeScript requires whitespace between '>' and '=' here",
            u8"TypeScript requires whitespace between '>' and '=' here",
            u8"TypeScript requires whitespace between '>' and '=' here",
            u8"TypeScript requires whitespace between '>' and '=' here",
            u8"TypeScript requires whitespace between '>' and '=' here",
        },
    },
    {
        "TypeScript type annotation requires parentheses"_translatable,
        u8"TypeScript type annotation requires parentheses",
        {
            u8"TypeScript type annotation requires parentheses",
            u8"TypeScript type annotation requires parentheses",
            u8"TypeScript type annotation requires parentheses",
            u8"anota\u00e7\u00f5es de tipagem de TypeScript requerem par\u00eanteses",
            u8"TypeScript type annotation requires parentheses",
        },
    },
    {
        "TypeScript type annotations are not allowed in JavaScript code"_translatable,
        u8"TypeScript type annotations are not allowed in JavaScript code",
        {
            u8"TypeScript type annotations are not allowed in JavaScript code",
            u8"TypeScript type annotations are not allowed in JavaScript code",
            u8"TypeScript type annotations are not allowed in JavaScript code",
            u8"anota\u00e7\u00f5es de tipo do TypeScript n\u00e3o s\u00e3o permitidas em c\u00f3digo JavaScript",
            u8"TypeScript type annotations are not allowed in JavaScript code",
        },
    },
    {
        "TypeScript type exports are not allowed in JavaScript"_translatable,
        u8"TypeScript type exports are not allowed in JavaScript",
        {
            u8"TypeScript type exports are not allowed in JavaScript",
            u8"TypeScript type exports are not allowed in JavaScript",
            u8"TypeScript type exports are not allowed in JavaScript",
            u8"exporta\u00e7\u00f5es de tipo do TypeScript n\u00e3o s\u00e3o permitidos em JavaScript",
            u8"TypeScript type exports are not allowed in JavaScript",
        },
    },
    {
        "TypeScript type imports are not allowed in JavaScript"_translatable,
        u8"TypeScript type imports are not allowed in JavaScript",
        {
            u8"TypeScript type imports are not allowed in JavaScript",
            u8"TypeScript type imports are not allowed in JavaScript",
            u8"TypeScript type imports are not allowed in JavaScript",
            u8"importa\u00e7\u00f5es de tipo do TypeScript n\u00e3o s\u00e3o permitidas em JavaScript",
            u8"TypeScript type imports are not allowed in JavaScript",
        },
    },
    {
        "TypeScript type imports cannot import both default and named exports"_translatable,
        u8"TypeScript type imports cannot import both default and named exports",
        {
            u8"TypeScript type imports cannot import both default and named exports",
            u8"TypeScript type imports cannot import both default and named exports",
            u8"TypeScript type imports cannot import both default and named exports",
            u8"importa\u00e7\u00f5es de tipos do TypeScript n\u00e3o podem importar exporta\u00e7\u00f5es default e nomeadas simultaneamente",
            u8"TypeScript type imports cannot import both default and named exports",
        },
    },
    {
        "TypeScript types are not allowed in JavaScript"_translatable,
        u8"TypeScript types are not allowed in JavaScript",
        {
            u8"TypeScript types are not allowed in JavaScript",
            u8"TypeScript types are not allowed in JavaScript",
            u8"TypeScript types are not allowed in JavaScript",
            u8"tipos de TypeScript n\u00e3o s\u00e3o permitidos em JavaScript",
            u8"TypeScript types are not allowed in JavaScript",
        },
    },
    {
        "TypeScript's 'enum' feature is not allowed in JavaScript"_translatable,
        u8"TypeScript's 'enum' feature is not allowed in JavaScript",
        {
            u8"TypeScript's 'enum' feature is not allowed in JavaScript",
            u8"TypeScript's 'enum' feature is not allowed in JavaScript",
            u8"TypeScript's 'enum' feature is not allowed in JavaScript",
            u8"'enum' do TypeScript n\u00e3o \u00e9 permitido em JavaScript",
            u8"TypeScript's 'enum' feature is not allowed in JavaScript",
        },
    },
    {
        "TypeScript's 'interface' feature is not allowed in JavaScript code"_translatable,
        u8"TypeScript's 'interface' feature is not allowed in JavaScript code",
        {
            u8"TypeScript's 'interface' feature is not allowed in JavaScript code",
            u8"this isn't TypeScript",
            u8"TypeScript's 'interface' feature is not allowed in JavaScript code",
            u8"'interface' do TypeScript n\u00e3o \u00e9 permitido em c\u00f3digo JavaScript",
            u8"TypeScript's 'interface' feature is not allowed in JavaScript code",
        },
    },
    {
        "TypeScript's 'readonly' feature is not allowed in JavaScript code"_translatable,
        u8"TypeScript's 'readonly' feature is not allowed in JavaScript code",
        {
            u8"TypeScript's 'readonly' feature is not allowed in JavaScript code",
            u8"TypeScript's 'readonly' feature is not allowed in JavaScript code",
            u8"TypeScript's 'readonly' feature is not allowed in JavaScript code",
            u8"'readonly' do TypeScript n\u00e3o \u00e9 permitido em c\u00f3digo JavaScript",
            u8"TypeScript's 'readonly' feature is not allowed in JavaScript code",
        },
    },
    {
        "a 'do-while' loop"_translatable,
        u8"a 'do-while' loop",
        {
            u8"eine do-While-Schleife",
            u8"a do-whiley do",
            u8"a 'do-while' loop",
            u8"um loop 'do-while'",
            u8"a 'do-while' loop",
        },
    },
    {
        "a 'for' loop"_translatable,
        u8"a 'for' loop",
        {
            u8"eine for-Schleife",
            u8"a 'for' loop \U0001f503",
            u8"a 'for' loop",
            u8"um loop 'for'",
            u8"a 'for' loop",
        },
    },
    {
        "a 'typeof' type"_translatable,
        u8"a 'typeof' type",
        {
            u8"a 'typeof' type",
            u8"a 'typeof' type",
            u8"a 'typeof' type",
            u8"a 'typeof' type",
            u8"a 'typeof' type",
        },
    },
    {
        "a 'while' loop"_translatable,
        u8"a 'while' loop",
        {
            u8"eine while-Schleife",
            u8"a whenever loop",
            u8"a 'while' loop",
            u8"um loop 'while'",
            u8"a 'while' loop",
        },
    },
    {
        "a 'with' statement"_translatable,
        u8"a 'with' statement",
        {
            u8"eine with-Anweisung",
            u8"a what-the-heck-is-wrong-with statement",
            u8"a 'with' statement",
            u8"uma instru\u00e7\u00e3o 'with'",
            u8"a 'with' statement",
        },
    },
    {
        "a catch variable"_translatable,
        u8"a catch variable",
        {
            u8"a catch variable",
            u8"a catch variable",
            u8"a catch variable",
            u8"a catch variable",
            u8"a catch variable",
        },
    },
    {
        "a class"_translatable,
        u8"a class",
        {
            u8"a class",
            u8"a class",
            u8"a class",
            u8"a class",
            u8"a class",
        },
    },
    {
        "a class statement is not allowed as the body of {1:singular}"_translatable,
        u8"a class statement is not allowed as the body of {1:singular}",
        {
            u8"Ein Klassen-Statement darf nicht der K\u00f6rper von {1:singular} sein",
            u8"you can't put a class here!",
            u8"une d\u00e9claration de classe n'est pas autoris\u00e9e dans le corps de {1:singular}",
            u8"uma declara\u00e7\u00e3o de classe n\u00e3o \u00e9 permitida como o conte\u00fado de {1:singular}",
            u8"klass sats \u00e4r inte till\u00e5tet som ett stycke av {1:singular}",
        },
    },
    {
        "a class's 'extends' clause"_translatable,
        u8"a class's 'extends' clause",
        {
            u8"a class's 'extends' clause",
            u8"a class's 'extends' clause",
            u8"a class's 'extends' clause",
            u8"a class's 'extends' clause",
            u8"a class's 'extends' clause",
        },
    },
    {
        "a class's 'implements' clause"_translatable,
        u8"a class's 'implements' clause",
        {
            u8"a class's 'implements' clause",
            u8"a class's 'implements' clause",
            u8"a class's 'implements' clause",
            u8"a class's 'implements' clause",
            u8"a class's 'implements' clause",
        },
    },
    {
        "a const variable"_translatable,
        u8"a const variable",
        {
            u8"a const variable",
            u8"a const variable",
            u8"a const variable",
            u8"a const variable",
            u8"a const variable",
        },
    },
    {
        "a decorator exists here before 'export'"_translatable,
        u8"a decorator exists here before 'export'",
        {
            u8"a decorator exists here before 'export'",
            u8"a decorator exists here before 'export'",
            u8"a decorator exists here before 'export'",
            u8"a decorator exists here before 'export'",
            u8"a decorator exists here before 'export'",
        },
    },
    {
        "a function"_translatable,
        u8"a function",
        {
            u8"a function",
            u8"a function",
            u8"a function",
            u8"a function",
            u8"a function",
        },
    },
    {
        "a function statement is not allowed as the body of {1:singular}"_translatable,
        u8"a function statement is not allowed as the body of {1:singular}",
        {
            u8"Ein Funktionsstatement ist ung\u00fcltig als K\u00f6rper von {1:singular}",
            u8"{1:singular} isn't the right place for a function",
            u8"une instruction de fonction ne peut faire partie du corps de {1:singular}",
            u8"uma fun\u00e7\u00e3o n\u00e3o \u00e9 permitida como conte\u00fado de {1:singular}",
            u8"en funktion sats \u00e4r inte till\u00e5tet som stycke till {1:singular}",
        },
    },
    {
        "a generic parameter"_translatable,
        u8"a generic parameter",
        {
            u8"a generic parameter",
            u8"a generic parameter",
            u8"a generic parameter",
            u8"a generic parameter",
            u8"a generic parameter",
        },
    },
    {
        "a labelled statement"_translatable,
        u8"a labelled statement",
        {
            u8"a labelled statement",
            u8"a labelled statement",
            u8"a labelled statement",
            u8"uma instru\u00e7\u00e3o com label",
            u8"a labelled statement",
        },
    },
    {
        "a let variable"_translatable,
        u8"a let variable",
        {
            u8"a let variable",
            u8"a let variable",
            u8"a let variable",
            u8"a let variable",
            u8"a let variable",
        },
    },
    {
        "a lexical declaration is not allowed as the body of {1:singular}"_translatable,
        u8"a lexical declaration is not allowed as the body of {1:singular}",
        {
            u8"Eine lexikalische Deklaration ist nicht als K\u00f6rper von {1:singular} erlaubt",
            u8"how do you propose we use this variable?",
            u8"une d\u00e9claration lexicale ne peut constituer le corps de {1:singular}",
            u8"uma declara\u00e7\u00e3o l\u00e9xica n\u00e3o \u00e9 permitida como o conte\u00fado de {1:singular}",
            u8"lexikaliskt deklaration \u00e4r inte till\u00e5tet inuti ett stycke av {1:singular}",
        },
    },
    {
        "a namespace"_translatable,
        u8"a namespace",
        {
            u8"a namespace",
            u8"a namespace",
            u8"a namespace",
            u8"a namespace",
            u8"a namespace",
        },
    },
    {
        "a parameter"_translatable,
        u8"a parameter",
        {
            u8"a parameter",
            u8"a parameter",
            u8"a parameter",
            u8"a parameter",
            u8"a parameter",
        },
    },
    {
        "a type"_translatable,
        u8"a type",
        {
            u8"a type",
            u8"a type",
            u8"a type",
            u8"a type",
            u8"a type",
        },
    },
    {
        "a type alias"_translatable,
        u8"a type alias",
        {
            u8"a type alias",
            u8"a type alias",
            u8"a type alias",
            u8"a type alias",
            u8"a type alias",
        },
    },
    {
        "a variable"_translatable,
        u8"a variable",
        {
            u8"a variable",
            u8"a variable",
            u8"a variable",
            u8"a variable",
            u8"a variable",
        },
    },
    {
        "a {{0} b }} c"_translatable,
        u8"a {{0} b }} c",
        {
            u8"a {{0} b }} c",
            u8"a {{0} b }} c",
            u8"a {{0} b }} c",
            u8"a {{0} b }} c",
            u8"a {{0} b }} c",
        },
    },
    {
        "abstract fields cannot have default values"_translatable,
        u8"abstract fields cannot have default values",
        {
            u8"abstract fields cannot have default values",
            u8"abstract fields cannot have default values",
            u8"abstract fields cannot have default values",
            u8"campos abstratos n\u00e3o podem ter valores padr\u00f5es",
            u8"abstract fields cannot have default values",
        },
    },
    {
        "abstract methods cannot be marked 'async'"_translatable,
        u8"abstract methods cannot be marked 'async'",
        {
            u8"abstract methods cannot be marked 'async'",
            u8"abstract methods cannot be marked 'async'",
            u8"abstract methods cannot be marked 'async'",
            u8"m\u00e9todos abstratos n\u00e3o podem ser marcados como 'async'",
            u8"abstract methods cannot be marked 'async'",
        },
    },
    {
        "abstract methods cannot be marked as a generator"_translatable,
        u8"abstract methods cannot be marked as a generator",
        {
            u8"abstract methods cannot be marked as a generator",
            u8"abstract methods cannot be marked as a generator",
            u8"abstract methods cannot be marked as a generator",
            u8"m\u00e9todos abstratos n\u00e3o podem ser marcados como generators",
            u8"abstract methods cannot be marked as a generator",
        },
    },
    {
        "abstract methods cannot contain a body"_translatable,
        u8"abstract methods cannot contain a body",
        {
            u8"abstract methods cannot contain a body",
            u8"abstract methods cannot contain a body",
            u8"abstract methods cannot contain a body",
            u8"m\u00e9todos abstratos n\u00e3o podem ter conte\u00fado",
            u8"abstract methods cannot contain a body",
        },
    },
    {
        "abstract properties are not allowed in interfaces"_translatable,
        u8"abstract properties are not allowed in interfaces",
        {
            u8"abstract properties are not allowed in interfaces",
            u8"abstract properties are not allowed in interfaces",
            u8"abstract properties are not allowed in interfaces",
            u8"propriedades abstratas n\u00e3o s\u00e3o permitidas em interfaces",
            u8"abstract properties are not allowed in interfaces",
        },
    },
    {
        "abstract properties are only allowed in abstract classes"_translatable,
        u8"abstract properties are only allowed in abstract classes",
        {
            u8"abstract properties are only allowed in abstract classes",
            u8"abstract properties are only allowed in abstract classes",
            u8"abstract properties are only allowed in abstract classes",
            u8"propriedades abstratas s\u00f3 s\u00e3o permitidas em classes abstratas",
            u8"abstract properties are only allowed in abstract classes",
        },
    },
    {
        "abstract properties cannot be static"_translatable,
        u8"abstract properties cannot be static",
        {
            u8"abstract properties cannot be static",
            u8"abstract properties cannot be static",
            u8"abstract properties cannot be static",
            u8"abstract properties cannot be static",
            u8"abstract properties cannot be static",
        },
    },
    {
        "accessors cannot be optional"_translatable,
        u8"accessors cannot be optional",
        {
            u8"accessors cannot be optional",
            u8"accessors cannot be optional",
            u8"accessors cannot be optional",
            u8"accessors cannot be optional",
            u8"accessors cannot be optional",
        },
    },
    {
        "an 'if' statement"_translatable,
        u8"an 'if' statement",
        {
            u8"eine if-Anweisung",
            u8"a when (not if) statement",
            u8"an 'if' statement",
            u8"uma instru\u00e7\u00e3o 'if'",
            u8"an 'if' statement",
        },
    },
    {
        "an enum"_translatable,
        u8"an enum",
        {
            u8"an enum",
            u8"an enum",
            u8"an enum",
            u8"an enum",
            u8"an enum",
        },
    },
    {
        "an import alias"_translatable,
        u8"an import alias",
        {
            u8"an import alias",
            u8"an import alias",
            u8"an import alias",
            u8"an import alias",
            u8"an import alias",
        },
    },
    {
        "an imported type"_translatable,
        u8"an imported type",
        {
            u8"an imported type",
            u8"an imported type",
            u8"an imported type",
            u8"an imported type",
            u8"an imported type",
        },
    },
    {
        "an imported variable"_translatable,
        u8"an imported variable",
        {
            u8"an imported variable",
            u8"an imported variable",
            u8"an imported variable",
            u8"an imported variable",
            u8"an imported variable",
        },
    },
    {
        "an index signature parameter"_translatable,
        u8"an index signature parameter",
        {
            u8"an index signature parameter",
            u8"an index signature parameter",
            u8"an index signature parameter",
            u8"an index signature parameter",
            u8"an index signature parameter",
        },
    },
    {
        "an interface"_translatable,
        u8"an interface",
        {
            u8"an interface",
            u8"an interface",
            u8"an interface",
            u8"an interface",
            u8"an interface",
        },
    },
    {
        "an interface's 'extends' clause"_translatable,
        u8"an interface's 'extends' clause",
        {
            u8"an interface's 'extends' clause",
            u8"an interface's 'extends' clause",
            u8"an interface's 'extends' clause",
            u8"an interface's 'extends' clause",
            u8"an interface's 'extends' clause",
        },
    },
    {
        "another invalid string, do not use outside benchmark"_translatable,
        u8"another invalid string, do not use outside benchmark",
        {
            u8"another invalid string, do not use outside benchmark",
            u8"another invalid string, do not use outside benchmark",
            u8"another invalid string, do not use outside benchmark",
            u8"outra string inv\u00e1lida, n\u00e3o use fora de benchmarks",
            u8"another invalid string, do not use outside benchmark",
        },
    },
    {
        "array started here"_translatable,
        u8"array started here",
        {
            u8"Array beginnt hier",
            u8"you opened Pandora's Box here",
            u8"tableau d\u00e9but\u00e9 ici",
            u8"array iniciou aqui",
            u8"lista startar h\u00e4r",
        },
    },
    {
        "arrow is here"_translatable,
        u8"arrow is here",
        {
            u8"Arrow ist hier",
            u8"move this up",
            u8"la fl\u00e8che est ici",
            u8"arrow est\u00e1 aqui",
            u8"pilen \u00e4r h\u00e4r",
        },
    },
    {
        "assertion signatures are only allowed as function return types"_translatable,
        u8"assertion signatures are only allowed as function return types",
        {
            u8"assertion signatures are only allowed as function return types",
            u8"assertion signatures are only allowed as function return types",
            u8"assertion signatures are only allowed as function return types",
            u8"assertion signatures are only allowed as function return types",
            u8"assertion signatures are only allowed as function return types",
        },
    },
    {
        "assigning to 'async' in a for-of loop requires parentheses"_translatable,
        u8"assigning to 'async' in a for-of loop requires parentheses",
        {
            u8"Zuweisung an 'async' in einer for-of-Schleife erfordert Verwendung von Klammern",
            u8"just stop using variables called 'async'. There. Problem solved",
            u8"une affectation de type 'async' dans une boucle for-of n\u00e9cessite l'usage de parenth\u00e8ses",
            u8"atribuir para 'async' em um loop for-of requer par\u00eanteses",
            u8"tilldelning av 'async' i for-of loop kr\u00e4ver paranteser",
        },
    },
    {
        "assignment assertion is not allowed on fields be marked 'declare'"_translatable,
        u8"assignment assertion is not allowed on fields be marked 'declare'",
        {
            u8"assignment assertion is not allowed on fields be marked 'declare'",
            u8"assignment assertion is not allowed on fields be marked 'declare'",
            u8"assignment assertion is not allowed on fields be marked 'declare'",
            u8"assignment assertion is not allowed on fields be marked 'declare'",
            u8"assignment assertion is not allowed on fields be marked 'declare'",
        },
    },
    {
        "assignment to const global variable"_translatable,
        u8"assignment to const global variable",
        {
            u8"Zuweisung an globale konstante Variable",
            u8"the global's CONSTant, you dweeb",
            u8"affectation \u00e0 une variable globale constante",
            u8"atribui\u00e7\u00e3o para vari\u00e1vel global constante",
            u8"tilldelar till global konstant variabel",
        },
    },
    {
        "assignment to const variable before its declaration"_translatable,
        u8"assignment to const variable before its declaration",
        {
            u8"Zuweisung an konstante Variable vor Deklaration",
            u8"why are you assignin' before you be makin'? \U0001f90f",
            u8"affectation \u00e0 une variable constante avant sa d\u00e9claration",
            u8"atribui\u00e7\u00e3o para vari\u00e1vel constante antes da declara\u00e7\u00e3o",
            u8"tilldelar konstant variable f\u00f6re dens deklaration",
        },
    },
    {
        "assignment to imported variable"_translatable,
        u8"assignment to imported variable",
        {
            u8"Zuweisung an importierte Variable",
            u8"you said 'import', not 'extort'",
            u8"assignment to imported variable",
            u8"atribui\u00e7\u00e3o para vari\u00e1vel importada",
            u8"assignment to imported variable",
        },
    },
    {
        "assignment to undeclared variable"_translatable,
        u8"assignment to undeclared variable",
        {
            u8"Zuweisung an nicht deklarierte Variable",
            u8"you're putting that where exactly?",
            u8"affectation \u00e0 une variable non d\u00e9clar\u00e9e",
            u8"atribui\u00e7\u00e3o para vari\u00e1vel n\u00e3o declarada",
            u8"tilldelar v\u00e4rde till variabel f\u00f6re deklaration",
        },
    },
    {
        "assignment-asserted field must have a type annotation"_translatable,
        u8"assignment-asserted field must have a type annotation",
        {
            u8"assignment-asserted field must have a type annotation",
            u8"assignment-asserted field must have a type annotation",
            u8"assignment-asserted field must have a type annotation",
            u8"campo com asser\u00e7\u00e3o de atribui\u00e7\u00e3o precisa ter uma anota\u00e7\u00e3o de tipo",
            u8"assignment-asserted field must have a type annotation",
        },
    },
    {
        "assignment-asserted fields are not allowed in 'declare class'"_translatable,
        u8"assignment-asserted fields are not allowed in 'declare class'",
        {
            u8"assignment-asserted fields are not allowed in 'declare class'",
            u8"assignment-asserted fields are not allowed in 'declare class'",
            u8"assignment-asserted fields are not allowed in 'declare class'",
            u8"assignment-asserted fields are not allowed in 'declare class'",
            u8"assignment-asserted fields are not allowed in 'declare class'",
        },
    },
    {
        "assignment-asserted fields are not supported in interfaces"_translatable,
        u8"assignment-asserted fields are not supported in interfaces",
        {
            u8"assignment-asserted fields are not supported in interfaces",
            u8"assignment-asserted fields are not supported in interfaces",
            u8"assignment-asserted fields are not supported in interfaces",
            u8"campos com asser\u00e7\u00e3o de atribui\u00e7\u00e3o n\u00e3o s\u00e3o suportados em interfaces",
            u8"assignment-asserted fields are not supported in interfaces",
        },
    },
    {
        "assignment-assertion fields cannot have default values"_translatable,
        u8"assignment-assertion fields cannot have default values",
        {
            u8"assignment-assertion fields cannot have default values",
            u8"assignment-assertion fields cannot have default values",
            u8"assignment-assertion fields cannot have default values",
            u8"campos com asser\u00e7\u00e3o de atribui\u00e7\u00e3o n\u00e3o podem ter valores padr\u00f5es",
            u8"assignment-assertion fields cannot have default values",
        },
    },
    {
        "attribute has wrong capitalization; write '{1}' instead"_translatable,
        u8"attribute has wrong capitalization; write '{1}' instead",
        {
            u8"Attribut mit falscher Gro\u00df- und Kleinschreibung; '{1}' anstattdessen schreiben",
            u8"did you leave CAPSLOCK on? it's '{1}'",
            u8"attribute has wrong capitalization; write '{1}' instead",
            u8"atributo est\u00e1 com a capitaliza\u00e7\u00e3o errada; use '{1}'",
            u8"attribute has wrong capitalization; write '{1}' instead",
        },
    },
    {
        "binary number literal has no digits"_translatable,
        u8"binary number literal has no digits",
        {
            u8"Bin\u00e4res Zahlenliteral ohne Ziffern",
            u8"binary number lost its genitals",
            u8"le litt\u00e9ral num\u00e9rique binaire n'a pas de chiffres",
            u8"n\u00famero bin\u00e1rio n\u00e3o tem d\u00edgitos",
            u8"bin\u00e4ra nummerlitteraler has inga siffror",
        },
    },
    {
        "break can only be used inside of a loop or switch"_translatable,
        u8"break can only be used inside of a loop or switch",
        {
            u8"'break' ist nur innerhalb von Schleifen und dem switch-Statement g\u00fcltig",
            u8"I'm going to break the loop, but I'm not in a loop",
            u8"break ne peut pas \u00eatre utilis\u00e9 \u00e0 l'int\u00e9rieur d'une boucle ou d'une instruction switch",
            u8"break s\u00f3 pode ser usado dentro de um loop ou switch",
            u8"break kan enbart vara inuti en loop eller switch",
        },
    },
    {
        "cannot 'export default' from inside a namespace"_translatable,
        u8"cannot 'export default' from inside a namespace",
        {
            u8"cannot 'export default' from inside a namespace",
            u8"cannot 'export default' from inside a namespace",
            u8"cannot 'export default' from inside a namespace",
            u8"cannot 'export default' from inside a namespace",
            u8"cannot 'export default' from inside a namespace",
        },
    },
    {
        "cannot access private identifier outside class"_translatable,
        u8"cannot access private identifier outside class",
        {
            u8"Zugriff auf privaten Bezeichner au\u00dferhalb der Klasse",
            u8"stop peeking at my privates!",
            u8"impossible d'acc\u00e9der \u00e0 un identifiant priv\u00e9 en dehors d'une classe",
            u8"n\u00e3o \u00e9 poss\u00edvel acessar identificador privado fora da classe",
            u8"cannot access private identifier outside class",
        },
    },
    {
        "cannot assign to loop variable in for of/in loop"_translatable,
        u8"cannot assign to loop variable in for of/in loop",
        {
            u8"Ung\u00fcltige Zuweisung an Iterationsvariable der for-in/of-Schleife",
            u8"what in tarnation is this assignment?",
            u8"impossible d'affecter la variable de boucle dans une boucle for of/in",
            u8"n\u00e3o \u00e9 poss\u00edvel atribuir para vari\u00e1vel do loop em um loop for of/in",
            u8"cannot assign to loop variable in for of/in loop",
        },
    },
    {
        "cannot assign to {1:singular}"_translatable,
        u8"cannot assign to {1:singular}",
        {
            u8"cannot assign to {1:singular}",
            u8"cannot assign to {1:singular}",
            u8"cannot assign to {1:singular}",
            u8"cannot assign to {1:singular}",
            u8"cannot assign to {1:singular}",
        },
    },
    {
        "cannot declare 'await' inside async function"_translatable,
        u8"cannot declare 'await' inside async function",
        {
            u8"Kann 'await' nicht innerhalb einer async-Funktion deklarieren",
            u8"you really think calling a variable 'await' in an async function is a good idea?",
            u8"impossible de d\u00e9clarer 'await' \u00e0 l'int\u00e9rieur d'une fonction async",
            u8"n\u00e3o \u00e9 poss\u00edvel declarar 'await' dentro de uma fun\u00e7\u00e3o async",
            u8"kan inte deklarera 'await' inuti async funktion",
        },
    },
    {
        "cannot declare 'yield' inside generator function"_translatable,
        u8"cannot declare 'yield' inside generator function",
        {
            u8"Kann 'yield' nicht innerhalb einer Generatorfunktion deklarieren",
            u8"'yield' is a terrible variable name'",
            u8"impossible de d\u00e9clarer 'yield' \u00e0 l'int\u00e9rieur d'une fonction g\u00e9n\u00e9ratrice",
            u8"n\u00e3o \u00e9 poss\u00edvel declarar 'yield' dentro de uma fun\u00e7\u00e3o generator",
            u8"kan inte deklarera 'yield' inuti en generatorfunktion",
        },
    },
    {
        "cannot declare and export variable with 'export default'"_translatable,
        u8"cannot declare and export variable with 'export default'",
        {
            u8"Kann keine Variable namens 'let' deklarieren und exportieren",
            u8"variables don't belong here",
            u8"impossible de d\u00e9clarer et d'exporter une variable avec 'export default'",
            u8"n\u00e3o \u00e9 poss\u00edvel declarar e exportar vari\u00e1vel com 'export default'",
            u8"kan inte deklarera och exportera variabel med 'export default'",
        },
    },
    {
        "cannot declare variable named keyword '{0}'"_translatable,
        u8"cannot declare variable named keyword '{0}'",
        {
            u8"Kann keine Variable namens 'let' exportieren",
            u8"'{0}' is a keyword, silly",
            u8"impossible de d\u00e9clarer une variable nomm\u00e9e comme le mot-cl\u00e9 '{0}'",
            u8"n\u00e3o \u00e9 poss\u00edvel declarar uma vari\u00e1vel com o nome '{0}'",
            u8"kan inte deklarera variabel med nyckelord '{0}'",
        },
    },
    {
        "cannot delete variables in TypeScript"_translatable,
        u8"cannot delete variables in TypeScript",
        {
            u8"cannot delete variables in TypeScript",
            u8"cannot delete variables in TypeScript",
            u8"cannot delete variables in TypeScript",
            u8"n\u00e3o \u00e9 poss\u00edvel deletar vari\u00e1veis em TypeScript",
            u8"cannot delete variables in TypeScript",
        },
    },
    {
        "cannot export variable named 'let'"_translatable,
        u8"cannot export variable named 'let'",
        {
            u8"Kann keine Variable namens 'let' exportieren",
            u8"you should be ashamed of 'var let'",
            u8"impossible d'exporter une variable nomm\u00e9e 'let'",
            u8"n\u00e3o \u00e9 poss\u00edvel exportar vari\u00e1vel chamada 'let'",
            u8"kan inte exportera variabel vid namn 'let'",
        },
    },
    {
        "cannot export variable named keyword '{0}'"_translatable,
        u8"cannot export variable named keyword '{0}'",
        {
            u8"Ung\u00fcltiger Export einer Variablen mit dem Namen des Schl\u00fcsselwortes '{0}'",
            u8"exporting '{0}'? really?",
            u8"impossible d'exporter une variable nomm\u00e9e comme le mot-cl\u00e9 '{0}'",
            u8"n\u00e3o \u00e9 poss\u00edvel exportar vari\u00e1vel com o nome '{0}'",
            u8"kan inte exportera variabel med nyckelord '{0}'",
        },
    },
    {
        "cannot import 'let'"_translatable,
        u8"cannot import 'let'",
        {
            u8"'let' kann nicht importiert werden",
            u8"it's not even your fault. blame TC39",
            u8"impossible d'importer 'let'",
            u8"n\u00e3o \u00e9 poss\u00edvel importar 'let'",
            u8"kan inte importera 'let'",
        },
    },
    {
        "cannot import a module from inside a 'declare namespace'"_translatable,
        u8"cannot import a module from inside a 'declare namespace'",
        {
            u8"cannot import a module from inside a 'declare namespace'",
            u8"cannot import a module from inside a 'declare namespace'",
            u8"cannot import a module from inside a 'declare namespace'",
            u8"cannot import a module from inside a 'declare namespace'",
            u8"cannot import a module from inside a 'declare namespace'",
        },
    },
    {
        "cannot import variable named keyword '{0}'"_translatable,
        u8"cannot import variable named keyword '{0}'",
        {
            u8"Kann keine Variable namens 'let' exportieren",
            u8"whoever wrote this module should feel back for exporting a keyword",
            u8"impossible d'importer une variable nomm\u00e9e comme un mot-cl\u00e9 '{0}'",
            u8"n\u00e3o \u00e9 poss\u00edvel importar vari\u00e1vel com o nome '{0}'",
            u8"kan inte importera variabel med namngivet nyckelord '{0}'",
        },
    },
    {
        "cannot reference private variables without object; use 'this.'"_translatable,
        u8"cannot reference private variables without object; use 'this.'",
        {
            u8"Private Felder des Objekts k\u00f6nnen nicht ohne 'this.' referenziert werden",
            u8"you're missing 'self.'; or 'this.'; I forget",
            u8"impossible de r\u00e9f\u00e9rencer des variables priv\u00e9es sans objet ; utiliser 'this.'",
            u8"n\u00e3o \u00e9 poss\u00edvel referenciar vari\u00e1veis privadas sem objeto; use 'this'.",
            u8"kan inte referera en privat variabel utan ett objekt; anv\u00e4nd 'this'",
        },
    },
    {
        "cannot update variable with '{0}' while declaring it"_translatable,
        u8"cannot update variable with '{0}' while declaring it",
        {
            u8"An Variable '{0}' kann nicht w\u00e4hrend der Deklaration zugewiesen werden",
            u8"'{0}' makes no sense; try '='?",
            u8"impossible d'actualiser la variable avec '{0}' pendant sa d\u00e9claration",
            u8"n\u00e3o \u00e9 poss\u00edvel atualizar vari\u00e1vel com '{0}' enquanto a declara",
            u8"kan inte uppdatera variabel med '{0} under deklaration'",
        },
    },
    {
        "cannot use '...' on 'this' parameter"_translatable,
        u8"cannot use '...' on 'this' parameter",
        {
            u8"cannot use '...' on 'this' parameter",
            u8"cannot use '...' on 'this' parameter",
            u8"cannot use '...' on 'this' parameter",
            u8"n\u00e3o \u00e9 poss\u00edvel usar '...' no par\u00e2metro 'this'",
            u8"cannot use '...' on 'this' parameter",
        },
    },
    {
        "cannot use 'declare' keyword with 'import'"_translatable,
        u8"cannot use 'declare' keyword with 'import'",
        {
            u8"cannot use 'declare' keyword with 'import'",
            u8"cannot use 'declare' keyword with 'import'",
            u8"cannot use 'declare' keyword with 'import'",
            u8"cannot use 'declare' keyword with 'import'",
            u8"cannot use 'declare' keyword with 'import'",
        },
    },
    {
        "cannot use multiple `export default` statements in one module"_translatable,
        u8"cannot use multiple `export default` statements in one module",
        {
            u8"cannot use multiple `export default` statements in one module",
            u8"cannot use multiple `export default` statements in one module",
            u8"cannot use multiple `export default` statements in one module",
            u8"cannot use multiple `export default` statements in one module",
            u8"cannot use multiple `export default` statements in one module",
        },
    },
    {
        "cannot use type directly in its own definition"_translatable,
        u8"cannot use type directly in its own definition",
        {
            u8"cannot use type directly in its own definition",
            u8"cannot use type directly in its own definition",
            u8"cannot use type directly in its own definition",
            u8"cannot use type directly in its own definition",
            u8"cannot use type directly in its own definition",
        },
    },
    {
        "catch variable"_translatable,
        u8"catch variable",
        {
            u8"catch variable",
            u8"catch variable",
            u8"catch variable",
            u8"catch variable",
            u8"catch variable",
        },
    },
    {
        "catch variable can only be typed as '*', 'any', or 'unknown'"_translatable,
        u8"catch variable can only be typed as '*', 'any', or 'unknown'",
        {
            u8"catch variable can only be typed as '*', 'any', or 'unknown'",
            u8"catch variable can only be typed as '*', 'any', or 'unknown'",
            u8"catch variable can only be typed as '*', 'any', or 'unknown'",
            u8"vari\u00e1vel do catch s\u00f3 pode ser tipada como '*', 'any' ou 'unknown'",
            u8"catch variable can only be typed as '*', 'any', or 'unknown'",
        },
    },
    {
        "character is not allowed in identifiers"_translatable,
        u8"character is not allowed in identifiers",
        {
            u8"Ung\u00fcltiges Zeichen in Bezeichner",
            u8"hold up! \u270b no '{0}' allowed",
            u8"caract\u00e8re non autoris\u00e9 dans les identifiants",
            u8"caracter n\u00e3o \u00e9 permitido em identificadores",
            u8"tecknet \u00e4r inte till\u00e5tet i indentifierare",
        },
    },
    {
        "children end here"_translatable,
        u8"children end here",
        {
            u8"Children enden hier",
            u8"\U0001f6b8\U0001f6ab\u26d4",
            u8"children end here",
            u8"os n\u00f3s acabam aqui",
            u8"children end here",
        },
    },
    {
        "class"_translatable,
        u8"class",
        {
            u8"class",
            u8"class",
            u8"class",
            u8"class",
            u8"class",
        },
    },
    {
        "class 'extends' clause"_translatable,
        u8"class 'extends' clause",
        {
            u8"class 'extends' clause",
            u8"class 'extends' clause",
            u8"class 'extends' clause",
            u8"class 'extends' clause",
            u8"class 'extends' clause",
        },
    },
    {
        "class 'implements' clause"_translatable,
        u8"class 'implements' clause",
        {
            u8"class 'implements' clause",
            u8"class 'implements' clause",
            u8"class 'implements' clause",
            u8"class 'implements' clause",
            u8"class 'implements' clause",
        },
    },
    {
        "class is not marked abstract"_translatable,
        u8"class is not marked abstract",
        {
            u8"class is not marked abstract",
            u8"class is not marked abstract",
            u8"class is not marked abstract",
            u8"classe n\u00e3o \u00e9 marcada como abstrata",
            u8"class is not marked abstract",
        },
    },
    {
        "classes cannot be named 'let'"_translatable,
        u8"classes cannot be named 'let'",
        {
            u8"Klassen d\u00fcrfen nicht mit 'let' benannt werden",
            u8"why would you call a class 'let'?",
            u8"une classe ne peut \u00eatre nomm\u00e9e 'let'",
            u8"classes n\u00e3o podem se chamar 'let'",
            u8"klass kan inte ben\u00e4mnas 'let'",
        },
    },
    {
        "code point in Unicode escape sequence must not be greater than U+10FFFF"_translatable,
        u8"code point in Unicode escape sequence must not be greater than U+10FFFF",
        {
            u8"Codepunkt innerhalb der Unicode-Escapesequenz darf nicht gr\u00f6\u00dfer als U+10FFFF sein",
            u8"U+10FFFF is the limit. what are you trying to accomplish?",
            u8"un point de code dans une s\u00e9quence d'\u00e9chappement Unicode ne peut d\u00e9passer la valeur U+10FFFF",
            u8"code point em sequ\u00eancias de escape Unicode n\u00e3o pode ser maior que U+10FFFF",
            u8"code point in Unicode escape sequence must not be greater than U+10FFFF",
        },
    },
    {
        "code point out of range"_translatable,
        u8"code point out of range",
        {
            u8"Codepunkt au\u00dferhalb des zul\u00e4ssigen Bereichs",
            u8"it won't fit \U0001f930",
            u8"point de code hors limite",
            u8"code point fora do intervalo permitido",
            u8"kod punkt ur span",
        },
    },
    {
        "commas are not allowed after spread parameter"_translatable,
        u8"commas are not allowed after spread parameter",
        {
            u8"Ung\u00fcltiges Komma nach Spread-Parameter",
            u8"a comma makes sense, but TC39 says no \u26d4",
            u8"les virgules ne sont pas autoris\u00e9es apr\u00e8s un param\u00e8tre d'expansion",
            u8"v\u00edrgulas n\u00e3o s\u00e3o permitidas ap\u00f3s par\u00e2metro com spread",
            u8"kommatecken \u00e4r inte till\u00e5tet efter sprid parameter",
        },
    },
    {
        "commas are not allowed between class methods"_translatable,
        u8"commas are not allowed between class methods",
        {
            u8"Kommata sind nicht erlaubt zwischen Methoden einer Klasse",
            u8"get this comma out of my sight",
            u8"les virgules ne sont pas autoris\u00e9es entre les m\u00e9thodes de classe",
            u8"v\u00edrgulas n\u00e3o s\u00e3o permitidas entre m\u00e9todos de uma classe",
            u8"commas are not allowed between class methods",
        },
    },
    {
        "computed enum member name must be a simple string"_translatable,
        u8"computed enum member name must be a simple string",
        {
            u8"computed enum member name must be a simple string",
            u8"computed enum member name must be a simple string",
            u8"computed enum member name must be a simple string",
            u8"nome do membro do enum computado precisa ser uma string simples",
            u8"computed enum member name must be a simple string",
        },
    },
    {
        "computed value disables enum autoincrement"_translatable,
        u8"computed value disables enum autoincrement",
        {
            u8"computed value disables enum autoincrement",
            u8"computed value disables enum autoincrement",
            u8"computed value disables enum autoincrement",
            u8"valores computados desabilitam a incrementa\u00e7\u00e3o autom\u00e1tica do enum",
            u8"computed value disables enum autoincrement",
        },
    },
    {
        "const fields within classes are only allowed in TypeScript, not JavaScript"_translatable,
        u8"const fields within classes are only allowed in TypeScript, not JavaScript",
        {
            u8"Innerhalb Klassen sind const-Felder nur in TypeScript g\u00fcltig, nicht jedoch in JavaScript",
            u8"this field is a bit CONSTipated \U0001f922 ",
            u8"les champs const dans des classes ne sont autoris\u00e9s qu'avec TypeScript, et pas JavaScript",
            u8"campos constantes dentro de classes s\u00f3 s\u00e3o permitidos em TypeScript, n\u00e3o em JavaScript",
            u8"const fields within classes are only allowed in TypeScript, not JavaScript",
        },
    },
    {
        "const variable"_translatable,
        u8"const variable",
        {
            u8"const variable",
            u8"const variable",
            u8"const variable",
            u8"const variable",
            u8"const variable",
        },
    },
    {
        "const variable declared here"_translatable,
        u8"const variable declared here",
        {
            u8"Konstante Variable wurde hier deklariert",
            u8"see? C O N S T!",
            u8"variable constante d\u00e9clar\u00e9e ici",
            u8"vari\u00e1vel constante declarada aqui",
            u8"konstant variabel deklarerad h\u00e4r",
        },
    },
    {
        "const variables cannot have '!' (definite assignment assertion)"_translatable,
        u8"const variables cannot have '!' (definite assignment assertion)",
        {
            u8"const variables cannot have '!' (definite assignment assertion)",
            u8"const variables cannot have '!' (definite assignment assertion)",
            u8"const variables cannot have '!' (definite assignment assertion)",
            u8"const variables cannot have '!' (definite assignment assertion)",
            u8"const variables cannot have '!' (definite assignment assertion)",
        },
    },
    {
        "containing 'declare namespace' starts here"_translatable,
        u8"containing 'declare namespace' starts here",
        {
            u8"containing 'declare namespace' starts here",
            u8"containing 'declare namespace' starts here",
            u8"containing 'declare namespace' starts here",
            u8"containing 'declare namespace' starts here",
            u8"containing 'declare namespace' starts here",
        },
    },
    {
        "containing namespace or module declared here"_translatable,
        u8"containing namespace or module declared here",
        {
            u8"containing namespace or module declared here",
            u8"containing namespace or module declared here",
            u8"containing namespace or module declared here",
            u8"containing namespace or module declared here",
            u8"containing namespace or module declared here",
        },
    },
    {
        "continue can only be used inside of a loop"_translatable,
        u8"continue can only be used inside of a loop",
        {
            u8"continue ist nur innerhalb von Schleifen g\u00fcltig",
            u8"Just stop.",
            u8"continue ne peut \u00eatre utilis\u00e9 qu'\u00e0 l'int\u00e9rieur d'une boucle",
            u8"continue s\u00f3 pode ser usado dentro de um loop",
            u8"continue kan enbart vara inuti en loop",
        },
    },
    {
        "decorator belongs immediately before this overloaded method"_translatable,
        u8"decorator belongs immediately before this overloaded method",
        {
            u8"decorator belongs immediately before this overloaded method",
            u8"decorator belongs immediately before this overloaded method",
            u8"decorator belongs immediately before this overloaded method",
            u8"decorator belongs immediately before this overloaded method",
            u8"decorator belongs immediately before this overloaded method",
        },
    },
    {
        "decorator starts here"_translatable,
        u8"decorator starts here",
        {
            u8"decorator starts here",
            u8"decorator starts here",
            u8"decorator starts here",
            u8"decorator starts here",
            u8"decorator starts here",
        },
    },
    {
        "decorators are not allowed inside TypeScript interfaces"_translatable,
        u8"decorators are not allowed inside TypeScript interfaces",
        {
            u8"decorators are not allowed inside TypeScript interfaces",
            u8"decorators are not allowed inside TypeScript interfaces",
            u8"decorators are not allowed inside TypeScript interfaces",
            u8"decorators are not allowed inside TypeScript interfaces",
            u8"decorators are not allowed inside TypeScript interfaces",
        },
    },
    {
        "decorators are not allowed on abstract properties"_translatable,
        u8"decorators are not allowed on abstract properties",
        {
            u8"decorators are not allowed on abstract properties",
            u8"decorators are not allowed on abstract properties",
            u8"decorators are not allowed on abstract properties",
            u8"decorators are not allowed on abstract properties",
            u8"decorators are not allowed on abstract properties",
        },
    },
    {
        "decorators may be before 'export' or here, but not in both locations"_translatable,
        u8"decorators may be before 'export' or here, but not in both locations",
        {
            u8"decorators may be before 'export' or here, but not in both locations",
            u8"decorators may be before 'export' or here, but not in both locations",
            u8"decorators may be before 'export' or here, but not in both locations",
            u8"decorators may be before 'export' or here, but not in both locations",
            u8"decorators may be before 'export' or here, but not in both locations",
        },
    },
    {
        "decorators must appear after overload signatures"_translatable,
        u8"decorators must appear after overload signatures",
        {
            u8"decorators must appear after overload signatures",
            u8"decorators must appear after overload signatures",
            u8"decorators must appear after overload signatures",
            u8"decorators must appear after overload signatures",
            u8"decorators must appear after overload signatures",
        },
    },
    {
        "decorators must appear before '{1}"_translatable,
        u8"decorators must appear before '{1}",
        {
            u8"decorators must appear before '{1}",
            u8"decorators must appear before '{1}",
            u8"decorators must appear before '{1}",
            u8"decorators must appear before '{1}",
            u8"decorators must appear before '{1}",
        },
    },
    {
        "depth limit exceeded"_translatable,
        u8"depth limit exceeded",
        {
            u8"Maximale Verschachtelungstiefe \u00fcberschritten",
            u8"ow! my cervix! \U0001f930",
            u8"limite de profondeur d\u00e9pass\u00e9e",
            u8"limite de profundidade excedido",
            u8"djup begr\u00e4nsning \u00f6verskriden",
        },
    },
    {
        "do-while loop is missing '{1}' around condition"_translatable,
        u8"do-while loop is missing '{1}' around condition",
        {
            u8"'{1}' fehlt um Bedingung der do-while-Schleife",
            u8"okay mister \"I'm very smart because I use do-while loops\"",
            u8"une boucle do-while n\u00e9cesite '{1}' autour de la condition",
            u8"falta '{1}' ao redor da condi\u00e7\u00e3o do loop do-while",
            u8"do-while loop saknar '{1}' runt vilkor",
        },
    },
    {
        "do-while loop needs parentheses around condition"_translatable,
        u8"do-while loop needs parentheses around condition",
        {
            u8"Klammern um Bedingung der do-while-Schleife fehlen",
            u8"just write a regular loop",
            u8"une boucle do-while n\u00e9cessite des parenth\u00e8ses autour de la condition",
            u8"loop do-while precisa de par\u00eanteses ao redor da condi\u00e7\u00e3o",
            u8"do-while loop beh\u00f6ver paranteser runt vilkor",
        },
    },
    {
        "do-while statement starts here"_translatable,
        u8"do-while statement starts here",
        {
            u8"do-while-Schleife beginnt hier",
            u8"lonely 'do' is here",
            u8"instruction do-while d\u00e9but\u00e9e ici",
            u8"instru\u00e7\u00e3o do-while inicia aqui",
            u8"do-while p\u00e5st\u00e5ende startar h\u00e4r",
        },
    },
    {
        "duplicated case clause in switch statement"_translatable,
        u8"duplicated case clause in switch statement",
        {
            u8"duplicated case clause in switch statement",
            u8"duplicated case clause in switch statement",
            u8"duplicated case clause in switch statement",
            u8"duplicated case clause in switch statement",
            u8"duplicated case clause in switch statement",
        },
    },
    {
        "enum"_translatable,
        u8"enum",
        {
            u8"enum",
            u8"enum",
            u8"enum",
            u8"enum",
            u8"enum",
        },
    },
    {
        "enum member name cannot be numeric"_translatable,
        u8"enum member name cannot be numeric",
        {
            u8"enum member name cannot be numeric",
            u8"enum member name cannot be numeric",
            u8"enum member name cannot be numeric",
            u8"nome do membro do enum n\u00e3o pode ser num\u00e9rico",
            u8"enum member name cannot be numeric",
        },
    },
    {
        "enum member needs initializer"_translatable,
        u8"enum member needs initializer",
        {
            u8"enum member needs initializer",
            u8"enum member needs initializer",
            u8"enum member needs initializer",
            u8"membro do enum precisa de um inicializador",
            u8"enum member needs initializer",
        },
    },
    {
        "escaped character is not allowed in identifiers"_translatable,
        u8"escaped character is not allowed in identifiers",
        {
            u8"Escape-Zeichen darf nicht nicht in Bezeichnern verwendet werden",
            u8"fugitive \U0001f9b9\u200d\u2642\ufe0f is not allowed in identifiers",
            u8"caract\u00e8re \u00e9chapp\u00e9 non permis dans les identifiants",
            u8"caracter escapado n\u00e3o \u00e9 permiido em identificadores",
            u8"flykttecken \u00e4r inte till\u00e5tet i indentifierare",
        },
    },
    {
        "escaping '-' is not allowed in tag names; write '-' instead"_translatable,
        u8"escaping '-' is not allowed in tag names; write '-' instead",
        {
            u8"Escape von '-' ist in Tagnamen nicht erlaubt. '-' anstattdessen schreiben",
            u8"stop being so fancy; just write '-'",
            u8"escaping '-' is not allowed in tag names; write '-' instead",
            u8"escapar '-' n\u00e3o \u00e9 permitido em nomes de tags; use '-'",
            u8"escaping '-' is not allowed in tag names; write '-' instead",
        },
    },
    {
        "event attributes must be camelCase: '{1}'"_translatable,
        u8"event attributes must be camelCase: '{1}'",
        {
            u8"Event-Attribute m\u00fcssen im camelCase geschrieben werden: '{1}'",
            u8"event attributes must be \U0001f42aCase: '{1}'",
            u8"event attributes must be camelCase: '{1}'",
            u8"atributos de eventos precisam ser camelCase: '{1}'",
            u8"event attributes must be camelCase: '{1}'",
        },
    },
    {
        "existing variable declared here"_translatable,
        u8"existing variable declared here",
        {
            u8"Bereits existierende Variable wurde hier deklariert",
            u8"to this variable here",
            u8"existing variable declared here",
            u8"vari\u00e1vel existente foi declarada aqui",
            u8"existing variable declared here",
        },
    },
    {
        "expected ')' to close function call"_translatable,
        u8"expected ')' to close function call",
        {
            u8"')' f\u00fcr Funktionsaufruf fehlt",
            u8"where's my ')' at?",
            u8"')' attendu pour clore un appel de fonction",
            u8"')' esperado para fechar a chamada de fun\u00e7\u00e3o",
            u8"f\u00f6rv\u00e4ntade ')' f\u00f6r att slutf\u00f6ra funktionkallelse",
        },
    },
    {
        "expected ',' between object literal entries"_translatable,
        u8"expected ',' between object literal entries",
        {
            u8"Komma fehlt zwischen Feldern des Objekt-Literals",
            u8"you dropped this: ,",
            u8"',' attendu entre les entr\u00e9es litt\u00e9rales d'un objet",
            u8"',' esperada entre entradas de um objeto",
            u8"f\u00f6rv\u00e4ntade ',' mellan f\u00f6rekommande objektlitteral",
        },
    },
    {
        "expected '?' to mark tuple element as optional"_translatable,
        u8"expected '?' to mark tuple element as optional",
        {
            u8"expected '?' to mark tuple element as optional",
            u8"expected '?' to mark tuple element as optional",
            u8"expected '?' to mark tuple element as optional",
            u8"esperado '?' para marcar o elemento da tupla como opcional",
            u8"expected '?' to mark tuple element as optional",
        },
    },
    {
        "expected 'as' between '{1}' and '{2}'"_translatable,
        u8"expected 'as' between '{1}' and '{2}'",
        {
            u8"'as' zwischen '{1}' und '{2}' erwartet",
            u8"you forgot 'as' between '{1}' and '{2}'",
            u8"'as' attendu entre '{1}' and '{2}'",
            u8"'as' esperado entre '{1}' e '{2}'",
            u8"f\u00f6rv\u00e4ntade 'as' mellan '{1}' och '{2}'",
        },
    },
    {
        "expected 'from \"name_of_module.mjs\"'"_translatable,
        u8"expected 'from \"name_of_module.mjs\"'",
        {
            u8"'from \"name_of_module.mjs\"' erwartet",
            u8"where are we importing from?",
            u8"'from \"name_of_module.mjs\"' attendu",
            u8"esperado 'from \"nome_do_modulo.mjs\"'",
            u8"f\u00f6rv\u00e4ntade 'from \"name_of_module.mjs\"'",
        },
    },
    {
        "expected 'from' before module specifier"_translatable,
        u8"expected 'from' before module specifier",
        {
            u8"'from' vor Modulspezifikation erwartet",
            u8"be polite and say 'from'",
            u8"'from' attendu avant un sp\u00e9cificateur de module",
            u8"esperado 'from' antes do nome do m\u00f3dulo",
            u8"f\u00f6rv\u00e4ntade 'from' f\u00f6re modulspecifierare",
        },
    },
    {
        "expected '{{'"_translatable,
        u8"expected '{{'",
        {
            u8"'{{' erwartet",
            u8"I was hoping for a '{{'",
            u8"'{{' attendu",
            u8"'{{' esperado",
            u8"f\u00f6rv\u00e4ntade '{{'",
        },
    },
    {
        "expected at least one parameter in generic parameter list"_translatable,
        u8"expected at least one parameter in generic parameter list",
        {
            u8"expected at least one parameter in generic parameter list",
            u8"expected at least one parameter in generic parameter list",
            u8"expected at least one parameter in generic parameter list",
            u8"esperado ao menos um par\u00e2metro na lista de par\u00e2metros gen\u00e9ricos",
            u8"expected at least one parameter in generic parameter list",
        },
    },
    {
        "expected expression after '('"_translatable,
        u8"expected expression after '('",
        {
            u8"expected expression after '('",
            u8"expected expression after '('",
            u8"expected expression after '('",
            u8"expected expression after '('",
            u8"expected expression after '('",
        },
    },
    {
        "expected expression after 'case'"_translatable,
        u8"expected expression after 'case'",
        {
            u8"Ausdruck nach 'case' erwartet",
            u8"this 'case' is awful lonely",
            u8"instruction attendue apr\u00e8s 'case'",
            u8"esperada uma express\u00e3o ap\u00f3s 'case'",
            u8"f\u00f6rv\u00e4ntade ett uttryck efter 'case'",
        },
    },
    {
        "expected expression before newline"_translatable,
        u8"expected expression before newline",
        {
            u8"Ausdruck vor Zeilenumbruch erwartet",
            u8"premature newline",
            u8"instruction attendue avant le saut de ligne",
            u8"esperada uma express\u00e3o antes da quebra de linha",
            u8"f\u00f6rv\u00e4ntade ett uttryck f\u00f6re nyrad",
        },
    },
    {
        "expected expression before semicolon"_translatable,
        u8"expected expression before semicolon",
        {
            u8"Ausdruck vor Semikolon erwartet",
            u8"I need something before that semicolon",
            u8"instruction attendue avant un point-virgule",
            u8"esperada uma express\u00e3o antes do ponto e v\u00edrgula",
            u8"f\u00f6rv\u00e4ntade ett uttryck f\u00f6re semikolon",
        },
    },
    {
        "expected hexadecimal digits in Unicode escape sequence"_translatable,
        u8"expected hexadecimal digits in Unicode escape sequence",
        {
            u8"Hexadezimale Ziffern in Unicode-Escapesequenz erwartet",
            u8"what are you trying to do? This is a Unicode escape sequence, not a Wendy's \U0001f354",
            u8"nombres hexadecimaux attendus dans une s\u00e9quence d'\u00e9chappement Unicode",
            u8"d\u00edgitos hexadecimais s\u00e3o esperados em uma sequ\u00eancia de escape Unicode",
            u8"f\u00f6rv\u00e4ntade hexadecimala siffror i Unicode flyktsekvens",
        },
    },
    {
        "expected parameter for arrow function, but got a literal instead"_translatable,
        u8"expected parameter for arrow function, but got a literal instead",
        {
            u8"Unerwartetes Literal anstelle des Parameters der Arrow-Funktion",
            u8"you stupid bastard, you can't have a literal as an arrow function parameter",
            u8"param\u00e8tre attendu au lieu d'un litt\u00e9ral pour la fonction fl\u00e9ch\u00e9e",
            u8"esperado um par\u00e2metro para a arrow function, mas em vez disso foi encontrado um valor",
            u8"f\u00f6rv\u00e4ntade parameter f\u00f6r pilfunktion, men fick in litter\u00e4r ist\u00e4llet",
        },
    },
    {
        "expected parameter for arrow function, but got an expression instead"_translatable,
        u8"expected parameter for arrow function, but got an expression instead",
        {
            u8"Unerwarter Ausdruck anstelle des Parameters der Arrow-Funktion",
            u8"express your feelings, not your arrow function parameters",
            u8"param\u00e8tre attendu au lieu d'une expression pour la fonction fl\u00e9ch\u00e9e",
            u8"esperado um par\u00e2metro para a arrow function, mas em vez disso foi encontrada uma express\u00e3o",
            u8"f\u00f6rv\u00e4ntade paramter till pilfunktion, men fick ett uttryck ist\u00e4llet",
        },
    },
    {
        "expected variable name after '...'"_translatable,
        u8"expected variable name after '...'",
        {
            u8"expected variable name after '...'",
            u8"expected variable name after '...'",
            u8"expected variable name after '...'",
            u8"expected variable name after '...'",
            u8"expected variable name after '...'",
        },
    },
    {
        "expected variable name for 'catch'"_translatable,
        u8"expected variable name for 'catch'",
        {
            u8"Variablenname f\u00fcr 'catch' fehlt",
            u8"name your variable, please",
            u8"nom de variable requis pour 'catch'",
            u8"esperado um nome de vari\u00e1vel para o 'catch'",
            u8"f\u00f6rv\u00e4ntade variabel namn f\u00f6r 'catch'",
        },
    },
    {
        "expected variable name for 'import'-'as'"_translatable,
        u8"expected variable name for 'import'-'as'",
        {
            u8"Variablenname f\u00fcr 'import'-'as' fehlt",
            u8"you said 'as', so give me a variable name",
            u8"nom de variable requis pour 'import'-'as'",
            u8"esperado um nome de vari\u00e1vel para 'import'-'as'",
            u8"expected variable name for 'import'-'as'",
        },
    },
    {
        "expected {1:headlinese}"_translatable,
        u8"expected {1:headlinese}",
        {
            u8"{1:headlinese} erwartet",
            u8"expected {1:headlinese}",
            u8"expected {1:headlinese}",
            u8"esperado {1:headlinese}",
            u8"expected {1:headlinese}",
        },
    },
    {
        "expected {1:singular}"_translatable,
        u8"expected {1:singular}",
        {
            u8"{1:singular} erwartet",
            u8"expected {1:singular}",
            u8"expected {1:singular}",
            u8"esperado {1:singular}",
            u8"expected {1:singular}",
        },
    },
    {
        "export default previously appeared here"_translatable,
        u8"export default previously appeared here",
        {
            u8"export default previously appeared here",
            u8"export default previously appeared here",
            u8"export default previously appeared here",
            u8"export default previously appeared here",
            u8"export default previously appeared here",
        },
    },
    {
        "exporting requires 'default'"_translatable,
        u8"exporting requires 'default'",
        {
            u8"Exportieren erfordert 'default'",
            u8"exporting with no name? c'mon",
            u8"l'exportation n\u00e9cessite 'default'",
            u8"exportar requer 'default'",
            u8"exportering kr\u00e4ver 'default'",
        },
    },
    {
        "exporting requires '{{' and '}'"_translatable,
        u8"exporting requires '{{' and '}'",
        {
            u8"Exportieren erfordert '{{' und '}'",
            u8"can I get a side of curly fries please? \U0001f35f",
            u8"l'exportation n\u00e9cessite '{{' and '}'",
            u8"exportar requer '{{' e '}'",
            u8"exportering kr\u00e4ver '{{' och '}'",
        },
    },
    {
        "extra ',' is not allowed between enum members"_translatable,
        u8"extra ',' is not allowed between enum members",
        {
            u8"extra ',' is not allowed between enum members",
            u8"extra ',' is not allowed between enum members",
            u8"extra ',' is not allowed between enum members",
            u8"',' extra n\u00e3o \u00e9 permitido entre membros de um enum",
            u8"extra ',' is not allowed between enum members",
        },
    },
    {
        "extra ',' is not allowed between function call arguments"_translatable,
        u8"extra ',' is not allowed between function call arguments",
        {
            u8"Mehrere Kommata zwischen den Argumenten eines Funktionsaufruf sind ung\u00fcltig",
            u8"that's way too many commas \U0001f6ae",
            u8"',' suppl\u00e9mentaire non autoris\u00e9 entre les arguments d'appel d'une fonction",
            u8"',' extra n\u1ebdo \u00e9 permitida entre argumentos de uma chamada de fun\u00e7\u00e3o",
            u8"extra ',' \u00e4r inte till\u00e5tet mellan funktionkallelses argument",
        },
    },
    {
        "field declared here"_translatable,
        u8"field declared here",
        {
            u8"field declared here",
            u8"field declared here",
            u8"field declared here",
            u8"campo declaradoa qui",
            u8"field declared here",
        },
    },
    {
        "field marked abstract here"_translatable,
        u8"field marked abstract here",
        {
            u8"field marked abstract here",
            u8"field marked abstract here",
            u8"field marked abstract here",
            u8"campo marcado como abstrato aqui",
            u8"field marked abstract here",
        },
    },
    {
        "field was declared as an accessor here"_translatable,
        u8"field was declared as an accessor here",
        {
            u8"field was declared as an accessor here",
            u8"field was declared as an accessor here",
            u8"field was declared as an accessor here",
            u8"field was declared as an accessor here",
            u8"field was declared as an accessor here",
        },
    },
    {
        "first parameter starts here"_translatable,
        u8"first parameter starts here",
        {
            u8"first parameter starts here",
            u8"first parameter starts here",
            u8"first parameter starts here",
            u8"primeiro par\u00e2metro inicia aqui",
            u8"first parameter starts here",
        },
    },
    {
        "for loop needs an iterable, or condition and update clauses"_translatable,
        u8"for loop needs an iterable, or condition and update clauses",
        {
            u8"for-Schleife erfordert entweder ein Iterable oder eine Bedingung und Updateanweisung",
            u8"finish writing your for loop",
            u8"une boucle for n\u00e9cessite un it\u00e9rable ou des clauses de condition et de mise \u00e0 jour",
            u8"loop for requer um iter\u00e1vel, ou uma condi\u00e7\u00e3o e cl\u00e1usulas de atualiza\u00e7\u00e3o",
            u8"for loop beh\u00f6ver en itererande eller vilkorligen uppdaterande moment",
        },
    },
    {
        "for-in loop expression cannot have semicolons"_translatable,
        u8"for-in loop expression cannot have semicolons",
        {
            u8"Ausdruck der for-in-Schleife darf keine Semikolon beinhalten",
            u8"you are forin a rude awakening if you think that's allowed",
            u8"une instruction de boucle for-in ne peut contenir de points-virgules",
            u8"loop for-in n\u00e3o pode ter ponto e v\u00edrgula",
            u8"for-in loop satser kan inte ha semikolon",
        },
    },
    {
        "for-of loop expression cannot have semicolons"_translatable,
        u8"for-of loop expression cannot have semicolons",
        {
            u8"Ausdruck der for-in-Schleife darf keine Semikolon beinhalten",
            u8"forof syntax inforof loop",
            u8"une instruction de boucle for-of ne peut contenir de points-virgules",
            u8"loop for-of n\u00e3o pode ter ponto e v\u00edrgula",
            u8"for-of loop satser kan inte ha semikolon",
        },
    },
    {
        "forwarding exports are only allowed in export-from"_translatable,
        u8"forwarding exports are only allowed in export-from",
        {
            u8"Forwarding-Exporte sind nur in export-from zul\u00e4ssig",
            u8"forwarding exports are only allowed in export-from",
            u8"les exports transf\u00e9r\u00e9s ne sont autoris\u00e9s qu'avec export-from",
            u8"re-encaminhar exports s\u00f3 \u00e9 permitido em export-from",
            u8"framf\u00f6randeexportering \u00e4r enbart till\u00e5tet i export-from",
        },
    },
    {
        "free {1} and {0} {1} {2}"_translatable,
        u8"free {1} and {0} {1} {2}",
        {
            u8"freies {1} und {0} {1} {2}",
            u8"free {1} and {0} {1} {2}",
            u8"free {1} and {0} {1} {2}",
            u8"free {1} and {0} {1} {2}",
            u8"free {1} and {0} {1} {2}",
        },
    },
    {
        "function"_translatable,
        u8"function",
        {
            u8"function",
            u8"function",
            u8"function",
            u8"function",
            u8"function",
        },
    },
    {
        "function 'let' call may be confused for destructuring; remove parentheses to declare a variable"_translatable,
        u8"function 'let' call may be confused for destructuring; remove parentheses to declare a variable",
        {
            u8"function 'let' call may be confused for destructuring; remove parentheses to declare a variable",
            u8"function 'let' call may be confused for destructuring; remove parentheses to declare a variable",
            u8"function 'let' call may be confused for destructuring; remove parentheses to declare a variable",
            u8"function 'let' call may be confused for destructuring; remove parentheses to declare a variable",
            u8"function 'let' call may be confused for destructuring; remove parentheses to declare a variable",
        },
    },
    {
        "function call started here"_translatable,
        u8"function call started here",
        {
            u8"Funktionsaufruf beginnt hier",
            u8"lookie here \U0001f447",
            u8"appel de fonction d\u00e9but\u00e9 ici",
            u8"chamada de fun\u00e7\u00e3o iniciou aqui",
            u8"funktionkallelse startar h\u00e4r",
        },
    },
    {
        "function called before declaration in block scope: {0}"_translatable,
        u8"function called before declaration in block scope: {0}",
        {
            u8"Funktion '{0}' wird im Block-Scope vor ihrer Deklaration aufgerufen",
            u8"this code freaks Safari out",
            u8"fonction appel\u00e9e avant sa d\u00e9claration dans la port\u00e9e de bloc : {0}",
            u8"fun\u00e7\u00e3o chamada antes de ser declarada: {0}",
            u8"function called before declaration in block scope: {0}",
        },
    },
    {
        "function declared here"_translatable,
        u8"function declared here",
        {
            u8"Funktion wird hier deklariert",
            u8"Safari hates this",
            u8"fonction d\u00e9clar\u00e9e ici",
            u8"fun\u00e7\u00e3o declarada aqui",
            u8"funktion deklarerad h\u00e4r",
        },
    },
    {
        "function overload signature cannot have generator '*'"_translatable,
        u8"function overload signature cannot have generator '*'",
        {
            u8"function overload signature cannot have generator '*'",
            u8"function overload signature cannot have generator '*'",
            u8"function overload signature cannot have generator '*'",
            u8"overload de assinatura de fun\u00e7\u00e3o n\u00e3o pode ter '*'",
            u8"function overload signature cannot have generator '*'",
        },
    },
    {
        "function overload signature must be named '{1}'"_translatable,
        u8"function overload signature must be named '{1}'",
        {
            u8"function overload signature must be named '{1}'",
            u8"function overload signature must be named '{1}'",
            u8"function overload signature must be named '{1}'",
            u8"overload de assinatura de fun\u00e7\u00e3o precisa se chamar '{1}'",
            u8"function overload signature must be named '{1}'",
        },
    },
    {
        "function parameter cannot be parenthesized"_translatable,
        u8"function parameter cannot be parenthesized",
        {
            u8"function parameter cannot be parenthesized",
            u8"function parameter cannot be parenthesized",
            u8"function parameter cannot be parenthesized",
            u8"function parameter cannot be parenthesized",
            u8"function parameter cannot be parenthesized",
        },
    },
    {
        "function starts here"_translatable,
        u8"function starts here",
        {
            u8"Funktionsaufruf beginnt hier",
            u8"IIFE started here",
            u8"function starts here",
            u8"fun\u00e7\u00e3o inicia aqui",
            u8"function starts here",
        },
    },
    {
        "functions in .d.ts files cannot be async; return a Promise type"_translatable,
        u8"functions in .d.ts files cannot be async; return a Promise type",
        {
            u8"functions in .d.ts files cannot be async; return a Promise type",
            u8"functions in .d.ts files cannot be async; return a Promise type",
            u8"functions in .d.ts files cannot be async; return a Promise type",
            u8"functions in .d.ts files cannot be async; return a Promise type",
            u8"functions in .d.ts files cannot be async; return a Promise type",
        },
    },
    {
        "functions in .d.ts files cannot be generators; return a Generator type"_translatable,
        u8"functions in .d.ts files cannot be generators; return a Generator type",
        {
            u8"functions in .d.ts files cannot be generators; return a Generator type",
            u8"functions in .d.ts files cannot be generators; return a Generator type",
            u8"functions in .d.ts files cannot be generators; return a Generator type",
            u8"functions in .d.ts files cannot be generators; return a Generator type",
            u8"functions in .d.ts files cannot be generators; return a Generator type",
        },
    },
    {
        "functions in .d.ts files cannot have a body"_translatable,
        u8"functions in .d.ts files cannot have a body",
        {
            u8"functions in .d.ts files cannot have a body",
            u8"functions in .d.ts files cannot have a body",
            u8"functions in .d.ts files cannot have a body",
            u8"functions in .d.ts files cannot have a body",
            u8"functions in .d.ts files cannot have a body",
        },
    },
    {
        "functions/methods should not have '=>'"_translatable,
        u8"functions/methods should not have '=>'",
        {
            u8"Funktionen/Methoden sollten kein '=>' haben",
            u8"no arrows allowed",
            u8"les fonctions/m\u00e9thodes ne peuvent contenir '=>'",
            u8"fun\u00e7\u00f5es/m\u00e9todos n\u00e3o podem ter '=>'",
            u8"functions/methods should not have '=>'",
        },
    },
    {
        "generator function '*' belongs after keyword function"_translatable,
        u8"generator function '*' belongs after keyword function",
        {
            u8"'*'-Zeichen f\u00fcr Generatorfunktionen wird nach dem function-Schl\u00fcsselwort erwartet",
            u8"slide this '*' to the right",
            u8"une fonction g\u00e9n\u00e9ratrice '*' figure apr\u00e8s la fonction mot-cl\u00e9",
            u8"'*' de uma fun\u00e7\u00e3o generator precisa ficar ap\u00f3s a palavra-chave function",
            u8"generator function '*' belongs after keyword function",
        },
    },
    {
        "generator function '*' belongs before function name"_translatable,
        u8"generator function '*' belongs before function name",
        {
            u8"'*'-Zeichen f\u00fcr Generatorfunktionen wird vor Funktionsnamen erwartet",
            u8"slide this '*' to the left",
            u8"une fonction g\u00e9n\u00e9ratrice '*' figure avant le nom de la fonction",
            u8"'*' de uma fun\u00e7\u00e3o generator precisa ficar antes do nome da fun\u00e7\u00e3o",
            u8"generatorfunktion '*' tillh\u00f6r f\u00f6re funktionens namn",
        },
    },
    {
        "generic arrow function needs ',' here in TSX"_translatable,
        u8"generic arrow function needs ',' here in TSX",
        {
            u8"generic arrow function needs ',' here in TSX",
            u8"generic arrow function needs ',' here in TSX",
            u8"generic arrow function needs ',' here in TSX",
            u8"aqui no TSX, uma arrow function gen\u00e9rica precisa de ','",
            u8"generic arrow function needs ',' here in TSX",
        },
    },
    {
        "generic parameter"_translatable,
        u8"generic parameter",
        {
            u8"generic parameter",
            u8"generic parameter",
            u8"generic parameter",
            u8"generic parameter",
            u8"generic parameter",
        },
    },
    {
        "getters and setters cannot be generators"_translatable,
        u8"getters and setters cannot be generators",
        {
            u8"getters and setters cannot be generators",
            u8"getters and setters cannot be generators",
            u8"getters and setters cannot be generators",
            u8"getters and setters cannot be generators",
            u8"getters and setters cannot be generators",
        },
    },
    {
        "getters and setters cannot have overload signatures"_translatable,
        u8"getters and setters cannot have overload signatures",
        {
            u8"getters and setters cannot have overload signatures",
            u8"getters and setters cannot have overload signatures",
            u8"getters and setters cannot have overload signatures",
            u8"getters and setters cannot have overload signatures",
            u8"getters and setters cannot have overload signatures",
        },
    },
    {
        "here"_translatable,
        u8"here",
        {
            u8"hier",
            u8"there \U0001f448",
            u8"here",
            u8"aqui",
            u8"here",
        },
    },
    {
        "here is the assignment assertion operator"_translatable,
        u8"here is the assignment assertion operator",
        {
            u8"here is the assignment assertion operator",
            u8"here is the assignment assertion operator",
            u8"here is the assignment assertion operator",
            u8"aqui est\u00e1 o operador de asser\u00e7\u00e3o de atribui\u00e7\u00e3o",
            u8"here is the assignment assertion operator",
        },
    },
    {
        "hex number literal has no digits"_translatable,
        u8"hex number literal has no digits",
        {
            u8"Hexadezimales Zahlenliteral ohne Ziffern",
            u8"hex number literal has no digits",
            u8"le litt\u00e9ral num\u00e9rique hex n'a pas de chiffres",
            u8"n\u00famero hexadecimal n\u00e3o tem d\u00edgitos",
            u8"hex nummerlitteral har inga siffror",
        },
    },
    {
        "if statement is missing '{1}' around condition"_translatable,
        u8"if statement is missing '{1}' around condition",
        {
            u8"'{1}' fehlt um Bedingung der if-Anweisung",
            u8"you dropped this: '{1}'",
            u8"une instruction if n\u00e9cessite '{1}' autour de la condition",
            u8"falta '{1}' ao redor da condi\u00e7\u00e3o da instru\u00e7\u00e3o if",
            u8"if sats saknar '{1}' runt vilkor",
        },
    },
    {
        "if statement needs parentheses around condition"_translatable,
        u8"if statement needs parentheses around condition",
        {
            u8"Klammern fehlen um Bedingung der if-Anweisung",
            u8"sorry. I wish I was programming in Go right now too",
            u8"une instruction if n\u00e9cessite des parenth\u00e8ses autour de la condition",
            u8"instru\u00e7\u00e3o if requer par\u00eanteses ao redor da condi\u00e7\u00e3o",
            u8"if sats beh\u00f6ver paranteser runt vilkor",
        },
    },
    {
        "import alias"_translatable,
        u8"import alias",
        {
            u8"import alias",
            u8"import alias",
            u8"import alias",
            u8"import alias",
            u8"import alias",
        },
    },
    {
        "imported type"_translatable,
        u8"imported type",
        {
            u8"imported type",
            u8"imported type",
            u8"imported type",
            u8"imported type",
            u8"imported type",
        },
    },
    {
        "imported variable"_translatable,
        u8"imported variable",
        {
            u8"imported variable",
            u8"imported variable",
            u8"imported variable",
            u8"imported variable",
            u8"imported variable",
        },
    },
    {
        "imported variable declared here"_translatable,
        u8"imported variable declared here",
        {
            u8"Importierte Variable wurde hier deklariert",
            u8"right here, buddy",
            u8"imported variable declared here",
            u8"vari\u00e1vel importada declarada aqui",
            u8"imported variable declared here",
        },
    },
    {
        "incomplete export; expected 'export default ...' or 'export {{name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'"_translatable,
        u8"incomplete export; expected 'export default ...' or 'export {{name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'",
        {
            u8"Unvollst\u00e4ndiger Export. M\u00f6glichkeiten sind: 'export default ...' oder 'export {{name}' oder 'export * from ...' oder 'export class' oder 'export function' oder 'export let'",
            u8"export WHAT!?",
            u8"export incompl ; 'export default ...' ou 'export {{name}' ou 'export * from ...' ou 'export class' ou 'export function' ou 'export let' attendu",
            u8"export incompleto; esperado 'export default ...' ou 'export {{nome}' ou 'export * from ...' ou 'export class' ou 'export function' ou 'export let'",
            u8"ofullst\u00e4ndig exportering; f\u00f6rv\u00e4ntades 'export default ...' eller 'export {{name}' eller 'export * from ...' eller 'export class' eller 'export function' eller 'export let'",
        },
    },
    {
        "index signature must be a field, not a method"_translatable,
        u8"index signature must be a field, not a method",
        {
            u8"index signature must be a field, not a method",
            u8"index signature must be a field, not a method",
            u8"index signature must be a field, not a method",
            u8"index signature precisa ser um campo, n\u00e3o um m\u00e9todo",
            u8"index signature must be a field, not a method",
        },
    },
    {
        "index signature parameter"_translatable,
        u8"index signature parameter",
        {
            u8"index signature parameter",
            u8"index signature parameter",
            u8"index signature parameter",
            u8"index signature parameter",
            u8"index signature parameter",
        },
    },
    {
        "index signatures require a value type"_translatable,
        u8"index signatures require a value type",
        {
            u8"index signatures require a value type",
            u8"index signatures require a value type",
            u8"index signatures require a value type",
            u8"index signature precisa de um tipo para o valor",
            u8"index signatures require a value type",
        },
    },
    {
        "index starts here"_translatable,
        u8"index starts here",
        {
            u8"index starts here",
            u8"index starts here",
            u8"index starts here",
            u8"index starts here",
            u8"index starts here",
        },
    },
    {
        "indexing requires an expression"_translatable,
        u8"indexing requires an expression",
        {
            u8"Indizierung erfordert einen Ausdruck",
            u8"put something in the box \U0001f4e6",
            u8"l'indexation n\u00e9cessite une expression",
            u8"indexar requer uma express\u00e3o",
            u8"indexering kr\u00e4ver ett uttryck",
        },
    },
    {
        "initial value was given here"_translatable,
        u8"initial value was given here",
        {
            u8"initial value was given here",
            u8"initial value was given here",
            u8"initial value was given here",
            u8"initial value was given here",
            u8"initial value was given here",
        },
    },
    {
        "initializer starts here"_translatable,
        u8"initializer starts here",
        {
            u8"initializer starts here",
            u8"initializer starts here",
            u8"initializer starts here",
            u8"inicializador inicia aqui",
            u8"initializer starts here",
        },
    },
    {
        "inside namespace here"_translatable,
        u8"inside namespace here",
        {
            u8"inside namespace here",
            u8"inside namespace here",
            u8"inside namespace here",
            u8"inside namespace here",
            u8"inside namespace here",
        },
    },
    {
        "integer cannot be represented and will be rounded to '{1}'"_translatable,
        u8"integer cannot be represented and will be rounded to '{1}'",
        {
            u8"integer cannot be represented and will be rounded to '{1}'",
            u8"this number's too thicc for JavaScript; '{1}' would be used instead",
            u8"integer cannot be represented and will be rounded to '{1}'",
            u8"inteiro n\u00e3o pode ser representado e vai ser arredondado para '{1}'",
            u8"integer cannot be represented and will be rounded to '{1}'",
        },
    },
    {
        "interface"_translatable,
        u8"interface",
        {
            u8"interface",
            u8"interface",
            u8"interface",
            u8"interface",
            u8"interface",
        },
    },
    {
        "interface 'extends' clause"_translatable,
        u8"interface 'extends' clause",
        {
            u8"interface 'extends' clause",
            u8"interface 'extends' clause",
            u8"interface 'extends' clause",
            u8"interface 'extends' clause",
            u8"interface 'extends' clause",
        },
    },
    {
        "interface properties are always public and cannot be private"_translatable,
        u8"interface properties are always public and cannot be private",
        {
            u8"interface properties are always public and cannot be private",
            u8"interface properties are always public and cannot be private",
            u8"interface properties are always public and cannot be private",
            u8"propriedades de interfaces s\u00e3o sempre p\u00fablicas e n\u00e3o podem ser privadas",
            u8"interface properties are always public and cannot be private",
        },
    },
    {
        "interface properties cannot be marked public explicitly"_translatable,
        u8"interface properties cannot be marked public explicitly",
        {
            u8"interface properties cannot be marked public explicitly",
            u8"interface properties cannot be marked public explicitly",
            u8"interface properties cannot be marked public explicitly",
            u8"propriedades de interfaces n\u00e3o podem ser marcadas como p\u00fablicas explicitamente",
            u8"interface properties cannot be marked public explicitly",
        },
    },
    {
        "interfaces cannot contain static blocks"_translatable,
        u8"interfaces cannot contain static blocks",
        {
            u8"interfaces cannot contain static blocks",
            u8"interfaces cannot contain static blocks",
            u8"interfaces cannot contain static blocks",
            u8"interfaces n\u00e3o podem conter blocos est\u00e1ticos",
            u8"interfaces cannot contain static blocks",
        },
    },
    {
        "invalid UTF-8 sequence"_translatable,
        u8"invalid UTF-8 sequence",
        {
            u8"Ung\u00fcltige UTF-8 Sequenz",
            u8"quick-lint-js only works with nonbinary files",
            u8"s\u00e9quence UTF-8 invalide",
            u8"sequ\u00eancia UTF-8 inv\u00e1lida",
            u8"ogiltig UTF-8 sekvens",
        },
    },
    {
        "invalid expression left of assignment"_translatable,
        u8"invalid expression left of assignment",
        {
            u8"Ung\u00fcltiger Ausdruck linkerseits der Zuweisung",
            u8"what the heck are you trying to assign to?",
            u8"expression invalide \u00e0 gauche de l'assignation",
            u8"express\u00e3o inv\u00e1lida no lado esquerdo da atribui\u00e7\u00e3o",
            u8"ogiltigt uttryck f\u00f6re tilldelning",
        },
    },
    {
        "invalid function parameter"_translatable,
        u8"invalid function parameter",
        {
            u8"Ung\u00fcltiger Funktionsparameter",
            u8"that's not what a parameter looks like",
            u8"param\u00e8tre de fonction invalide",
            u8"par\u00e2metro de fun\u00e7\u00e3o inv\u00e1lido",
            u8"ogiltig funktions parameter",
        },
    },
    {
        "invalid hex escape sequence: {0}"_translatable,
        u8"invalid hex escape sequence: {0}",
        {
            u8"Ung\u00fcltige Hex-Escapesequenz: {0}",
            u8"this ain't hex",
            u8"s\u00e9quence d'\u00e9chappement hex invalide: {0}",
            u8"sequ\u00eancia de escape hex inv\u00e1lida: {0}",
            u8"ogiltig kring\u00e5ende hex sekvens: {0}",
        },
    },
    {
        "invalid lone literal in object literal"_translatable,
        u8"invalid lone literal in object literal",
        {
            u8"Vereinzeltes Literal in Objekt-Literal",
            u8"what's this literal supposed to mean in an object?",
            u8"litt\u00e9ral isol\u00e9 invalide dans un litt\u00e9ral objet",
            u8"valor sozinho \u00e9 inv\u00e1lido em um objeto",
            u8"ogiltigt l\u00e5neuttryck i objektliteral",
        },
    },
    {
        "keywords cannot contain escape sequences"_translatable,
        u8"keywords cannot contain escape sequences",
        {
            u8"Schl\u00fcsselworte d\u00fcrfen keine Escapesequenzen beinhalten",
            u8"that sequence should escape from this keyword cuz it's not allowed here",
            u8"les mots-cl\u00e9s ne peuvent pas contenir de s\u00e9quence d'\u00e9chappement",
            u8"palavras-chave n\u00e3o podem conter sequ\u00eancias de escape",
            u8"nyckelord kan inte inneh\u00e5lla en flyktsekvens",
        },
    },
    {
        "label named 'await' not allowed in async function"_translatable,
        u8"label named 'await' not allowed in async function",
        {
            u8"Labels namens 'await' sind innerhalb async-Functionen verboten",
            u8"'goto await;' isn't a thing",
            u8"\u00e9tiquette nomm\u00e9e 'await' non autoris\u00e9e dans les fonctions async",
            u8"label chamada 'await' n\u00e3o \u00e9 permitida em fun\u00e7\u00e3o async",
            u8"label named 'await' not allowed in async function",
        },
    },
    {
        "labelled statement"_translatable,
        u8"labelled statement",
        {
            u8"labelled statement",
            u8"labelled statement",
            u8"labelled statement",
            u8"instru\u00e7\u00e3o com label",
            u8"labelled statement",
        },
    },
    {
        "leading commas are not allowed in generic parameter lists"_translatable,
        u8"leading commas are not allowed in generic parameter lists",
        {
            u8"leading commas are not allowed in generic parameter lists",
            u8"leading commas are not allowed in generic parameter lists",
            u8"leading commas are not allowed in generic parameter lists",
            u8"v\u00edrgulas no in\u00edcio n\u00e3o s\u00e3o permitidas em listas de par\u00e2metros gen\u00e9ricos",
            u8"leading commas are not allowed in generic parameter lists",
        },
    },
    {
        "legacy octal literal may not be BigInt"_translatable,
        u8"legacy octal literal may not be BigInt",
        {
            u8"Veraltete Oktalliterale sind in BigInts nicht erlaubt",
            u8"0Ops",
            u8"un litt\u00e9ral octal classique ne peut pas \u00eatre de type BigInt",
            u8"n\u00famero octal legado n\u00e3o pode ser BigInt",
            u8"\u00e4rftligt octal nummerlitteral kan inte vara BigInt",
        },
    },
    {
        "legacy octal literals may not contain underscores"_translatable,
        u8"legacy octal literals may not contain underscores",
        {
            u8"Veraltete Oktalliterale d\u00fcrfen keine Unterstriche enthalten",
            u8"legacy_octal_literals_may_not_contain_underscores",
            u8"un litt\u00e9ral octal classique ne peut pas contenir de tiret de soulignement",
            u8"n\u00famero octal legado n\u00e3o pode conter underscore",
            u8"\u00e4rftligt octal nummerlitteral kan inte inneh\u00e5lla understr\u00e4ck",
        },
    },
    {
        "let statement cannot declare variables named 'let'"_translatable,
        u8"let statement cannot declare variables named 'let'",
        {
            u8"let darf keine Variablen namens 'let' deklarieren",
            u8"st-stop st-stuttering",
            u8"une instruction let ne peut d\u00e9clarer de variables nomm\u00e9es 'let'",
            u8"instru\u00e7\u00e3o let n\u00e3o pode declarar uma vari\u00e1vel chamada 'let'",
            u8"let p\u00e5st\u00e5ende kan inte deklareras med namnet 'let'",
        },
    },
    {
        "let variable"_translatable,
        u8"let variable",
        {
            u8"let variable",
            u8"let variable",
            u8"let variable",
            u8"let variable",
            u8"let variable",
        },
    },
    {
        "lower case letters compared with toUpperCase"_translatable,
        u8"lower case letters compared with toUpperCase",
        {
            u8"Kleinbuchstaben werden mit toUpperCase verglichen",
            u8"You sure you're getting what toUpperCase does?",
            u8"lower case letters compared with toUpperCase",
            u8"letras min\u00fasculas comparadas com toUpperCase",
            u8"lower case letters compared with toUpperCase",
        },
    },
    {
        "method starts here"_translatable,
        u8"method starts here",
        {
            u8"method starts here",
            u8"method starts here",
            u8"method starts here",
            u8"method starts here",
            u8"method starts here",
        },
    },
    {
        "methods cannot be marked 'declare'"_translatable,
        u8"methods cannot be marked 'declare'",
        {
            u8"methods cannot be marked 'declare'",
            u8"methods cannot be marked 'declare'",
            u8"methods cannot be marked 'declare'",
            u8"methods cannot be marked 'declare'",
            u8"methods cannot be marked 'declare'",
        },
    },
    {
        "methods cannot be readonly"_translatable,
        u8"methods cannot be readonly",
        {
            u8"methods cannot be readonly",
            u8"methods cannot be readonly",
            u8"methods cannot be readonly",
            u8"m\u00e9todos n\u00e3o podem ser readonly",
            u8"methods cannot be readonly",
        },
    },
    {
        "methods should not use the 'function' keyword"_translatable,
        u8"methods should not use the 'function' keyword",
        {
            u8"Methoden sollten nicht mehr das 'function'-Schl\u00fcsselwort verwenden",
            u8"'function' is boomer",
            u8"les m\u00e9thodes ne doivent pas utiliser le mot-cl\u00e9 'function'",
            u8"m\u00e9todos n\u00e3o podem usar a palavra-chave 'function'",
            u8"metoder b\u00f6r inte anv\u00e4nda nyckelordet 'function'",
        },
    },
    {
        "misleading use of ',' operator in conditional statement"_translatable,
        u8"misleading use of ',' operator in conditional statement",
        {
            u8"misleading use of ',' operator in conditional statement",
            u8"misleading use of ',' operator in conditional statement",
            u8"misleading use of ',' operator in conditional statement",
            u8"misleading use of ',' operator in conditional statement",
            u8"misleading use of ',' operator in conditional statement",
        },
    },
    {
        "misleading use of ',' operator in index"_translatable,
        u8"misleading use of ',' operator in index",
        {
            u8"misleading use of ',' operator in index",
            u8"misleading use of ',' operator in index",
            u8"misleading use of ',' operator in index",
            u8"misleading use of ',' operator in index",
            u8"misleading use of ',' operator in index",
        },
    },
    {
        "mismatched JSX tags; expected '</{1}>'"_translatable,
        u8"mismatched JSX tags; expected '</{1}>'",
        {
            u8"Unpassender JSX-Tag; '</{1}>' wurde anstattdessen erwartet",
            u8"can't you count? I wanted a '</{1}>'! \U0001f910",
            u8"mismatched JSX tags; expected '</{1}>'",
            u8"tags JSX sem correspond\u00eancia; esperado '</{1}>'",
            u8"mismatched JSX tags; expected '</{1}>'",
        },
    },
    {
        "missing ',' between array elements"_translatable,
        u8"missing ',' between array elements",
        {
            u8"missing ',' between array elements",
            u8"missing ',' between array elements",
            u8"missing ',' between array elements",
            u8"missing ',' between array elements",
            u8"missing ',' between array elements",
        },
    },
    {
        "missing ',' between variable declarations"_translatable,
        u8"missing ',' between variable declarations",
        {
            u8"Komma fehlt zwischen Variablendeklarationen",
            u8",",
            u8"',' manquant entre les d\u00e9clarations de variable",
            u8"falta ',' entre declara\u00e7\u00f5es de vari\u00e1veis",
            u8"saknar ',' mellan variabel deklaration",
        },
    },
    {
        "missing ',', ';', or newline between object type entries"_translatable,
        u8"missing ',', ';', or newline between object type entries",
        {
            u8"missing ',', ';', or newline between object type entries",
            u8"missing ',', ';', or newline between object type entries",
            u8"missing ',', ';', or newline between object type entries",
            u8"falta ',', ';' ou uma quebra de linha entre as entradas do tipo",
            u8"missing ',', ';', or newline between object type entries",
        },
    },
    {
        "missing '...' in JSX attribute spread"_translatable,
        u8"missing '...' in JSX attribute spread",
        {
            u8"'...' fehlt in JSX-Attribut-Spread",
            u8"the solution is \u2026",
            u8"missing '...' in JSX attribute spread",
            u8"falta o '...' para fazer o spread dos atributos no JSX",
            u8"missing '...' in JSX attribute spread",
        },
    },
    {
        "missing ':' in conditional expression"_translatable,
        u8"missing ':' in conditional expression",
        {
            u8"':' des tern\u00e4ren Operators fehlt",
            u8"how did the grammar Nazi die? colon cancer.",
            u8"':' manquant dans l'expression conditionnelle",
            u8"falta ':' na express\u00e3o condicional",
            u8"saknar ':' i vilkorsuttryck",
        },
    },
    {
        "missing '<>' and '</>' to enclose multiple children"_translatable,
        u8"missing '<>' and '</>' to enclose multiple children",
        {
            u8"'<>' und '</>' fehlt, um mehrere Children einzuschlie\u00dfen",
            u8"give 'em a big ol' hug \U0001fac2 with '<>' and '</>'",
            u8"missing '<>' and '</>' to enclose multiple children",
            u8"falta '<>' e '</>' para fechar os m\u00faltiplos n\u00f3s",
            u8"missing '<>' and '</>' to enclose multiple children",
        },
    },
    {
        "missing '=' after variable"_translatable,
        u8"missing '=' after variable",
        {
            u8"'=' fehlt nach Variablenname",
            u8"= should be used like: 'let you = dumb'",
            u8"'=' manquant apr\u00e8s une variable",
            u8"falta '=' ap\u00f3s a vari\u00e1vel",
            u8"saknar '=' efter variabel",
        },
    },
    {
        "missing 'break;' or '// fallthrough' comment between statement and 'case'"_translatable,
        u8"missing 'break;' or '// fallthrough' comment between statement and 'case'",
        {
            u8"missing 'break;' or '// fallthrough' comment between statement and 'case'",
            u8"missing 'break;' or '// fallthrough' comment between statement and 'case'",
            u8"missing 'break;' or '// fallthrough' comment between statement and 'case'",
            u8"missing 'break;' or '// fallthrough' comment between statement and 'case'",
            u8"missing 'break;' or '// fallthrough' comment between statement and 'case'",
        },
    },
    {
        "missing 'export' keyword for function"_translatable,
        u8"missing 'export' keyword for function",
        {
            u8"missing 'export' keyword for function",
            u8"missing 'export' keyword for function",
            u8"missing 'export' keyword for function",
            u8"missing 'export' keyword for function",
            u8"missing 'export' keyword for function",
        },
    },
    {
        "missing 'if' after 'else'"_translatable,
        u8"missing 'if' after 'else'",
        {
            u8"missing 'if' after 'else'",
            u8"it's 'else if', silly",
            u8"missing 'if' after 'else'",
            u8"falta o 'if' ap\u00f3s o 'else'",
            u8"missing 'if' after 'else'",
        },
    },
    {
        "missing 'new' in constructor type"_translatable,
        u8"missing 'new' in constructor type",
        {
            u8"missing 'new' in constructor type",
            u8"missing 'new' in constructor type",
            u8"missing 'new' in constructor type",
            u8"missing 'new' in constructor type",
            u8"missing 'new' in constructor type",
        },
    },
    {
        "missing 'while (condition)' for do-while statement"_translatable,
        u8"missing 'while (condition)' for do-while statement",
        {
            u8"'while (condition)' der do-while-Schleife fehlt",
            u8"you left your 'do' hanging",
            u8"'while (condition)' manquant pour une instruction for do-while",
            u8"falta 'while (condi\u00e7\u00e3o)' para a instru\u00e7\u00e3o do-while",
            u8"saknar 'while (vilkor)' till do-while p\u00e5st\u00e5ende",
        },
    },
    {
        "missing TypeScript type"_translatable,
        u8"missing TypeScript type",
        {
            u8"missing TypeScript type",
            u8"missing TypeScript type",
            u8"missing TypeScript type",
            u8"falta o tipo de TypeScript",
            u8"missing TypeScript type",
        },
    },
    {
        "missing arrow operator for arrow function"_translatable,
        u8"missing arrow operator for arrow function",
        {
            u8"Arrow-Operator der Arrow-Funktion fehlt",
            u8"\u27a1",
            u8"op\u00e9rateur de fl\u00e8che manquant pour la fonction fl\u00e9ch\u00e9e",
            u8"falta o arrow operator da arrow function",
            u8"missing arrow operator for arrow function",
        },
    },
    {
        "missing body for 'for' loop"_translatable,
        u8"missing body for 'for' loop",
        {
            u8"K\u00f6rper der for-Schleife fehlt",
            u8"missing body 4 4 loop",
            u8"corps manquant pour la boucle 'for'",
            u8"falta o conte\u00fado do loop 'for'",
            u8"saknar stycke f\u00f6r 'for' loop",
        },
    },
    {
        "missing body for 'if' statement"_translatable,
        u8"missing body for 'if' statement",
        {
            u8"K\u00f6rper der if-Anweisung fehlt",
            u8"then what?",
            u8"corps manquant pour l'instruction 'if'",
            u8"falta o conte\u00fado da instru\u00e7\u00e3o 'if'",
            u8"saknar stycke f\u00f6r 'if' p\u00e5st\u00e5ende",
        },
    },
    {
        "missing body for 'switch' statement"_translatable,
        u8"missing body for 'switch' statement",
        {
            u8"K\u00f6rper des switch-Statements fehlt",
            u8"no switch cases? not even one?",
            u8"corps manquant pour l'instruction 'switch'",
            u8"falta o conte\u00fado da instru\u00e7\u00e3o 'switch'",
            u8"saknar stycke f\u00f6r 'switch' p\u00e5st\u00e5ende",
        },
    },
    {
        "missing body for TypeScript interface"_translatable,
        u8"missing body for TypeScript interface",
        {
            u8"missing body for TypeScript interface",
            u8"missing body for TypeScript interface",
            u8"missing body for TypeScript interface",
            u8"falta o conte\u00fado da interface de TypeScript",
            u8"missing body for TypeScript interface",
        },
    },
    {
        "missing body for TypeScript namespace"_translatable,
        u8"missing body for TypeScript namespace",
        {
            u8"missing body for TypeScript namespace",
            u8"missing body for TypeScript namespace",
            u8"missing body for TypeScript namespace",
            u8"missing body for TypeScript namespace",
            u8"missing body for TypeScript namespace",
        },
    },
    {
        "missing body for catch clause"_translatable,
        u8"missing body for catch clause",
        {
            u8"K\u00f6rper des 'catch'-Blocks fehlt",
            u8"did you dispose of the body?",
            u8"corps manquant pour la clause catch",
            u8"falta o conte\u00fado da cl\u00e1usula catch",
            u8"saknar stycke f\u00f6re catch sats",
        },
    },
    {
        "missing body for class"_translatable,
        u8"missing body for class",
        {
            u8"Klassenk\u00f6rper fehlt",
            u8"this class has been decapitated! \U0001f9df\u200d\u2640\ufe0f",
            u8"corps manquant pour la classe",
            u8"falta o conte\u00fado da classe",
            u8"saknar stycke f\u00f6r klass",
        },
    },
    {
        "missing body for do-while loop"_translatable,
        u8"missing body for do-while loop",
        {
            u8"K\u00f6rper der do-while-Schleife fehlt",
            u8"I should decapitate you for using a do-while loop",
            u8"corps manquant pour la boucle do-while",
            u8"falta o conte\u00fado do loop do-while",
            u8"saknar stycke f\u00f6r do-while loop",
        },
    },
    {
        "missing body for finally clause"_translatable,
        u8"missing body for finally clause",
        {
            u8"K\u00f6rper des 'finally'-Blocks fehlt",
            u8"what do you wanna do at the end?",
            u8"corps manquant pour la clause finally",
            u8"falta o conte\u00fado da cl\u00e1usula finally",
            u8"saknar stycke f\u00f6r finally sats",
        },
    },
    {
        "missing body for function"_translatable,
        u8"missing body for function",
        {
            u8"K\u00f6rper der Funktion fehlt",
            u8"what's this function supposed to do?",
            u8"corps manquant pour la fonction",
            u8"falta o conte\u00fado da fun\u00e7\u00e3o",
            u8"missing body for function",
        },
    },
    {
        "missing body for try statement"_translatable,
        u8"missing body for try statement",
        {
            u8"K\u00f6rper des try-Statements fehlt",
            u8"you're trying too hard",
            u8"corps manquant pour l'instruction try",
            u8"falta o conte\u00fado da instru\u00e7\u00e3o try",
            u8"saknar stycke f\u00f6r 'try' p\u00e5st\u00e5ende",
        },
    },
    {
        "missing body for while loop"_translatable,
        u8"missing body for while loop",
        {
            u8"K\u00f6rper der while-Schleife fehlt",
            u8"why don't you write some code?",
            u8"corps manquant pour la boucle while",
            u8"falta o conte\u00fado do loop while",
            u8"saknar stycke f\u00f6r while loop",
        },
    },
    {
        "missing body for {1:headlinese}"_translatable,
        u8"missing body for {1:headlinese}",
        {
            u8"K\u00f6rper f\u00fcr {1:headlinese} fehlt",
            u8"what's the point of {1:singular} with no body?",
            u8"corps manquant pour {1:headlinese}",
            u8"falta conte\u00fado para {1:headlinese}",
            u8"saknas stycke f\u00f6r {1:headlinese}",
        },
    },
    {
        "missing catch or finally clause for try statement"_translatable,
        u8"missing catch or finally clause for try statement",
        {
            u8"catch- oder finally-Klausel des try-Statements fehlt",
            u8"finally, you've got to try to catch it <mit> or you're gonna have a bad time",
            u8"clause catch ou finally manquante pour l'instruction try",
            u8"falta a cl\u00e1usula catch ou finally da instru\u00e7\u00e3o try",
            u8"saknar catch eller finally sats f\u00f6r try sats",
        },
    },
    {
        "missing catch variable name between parentheses"_translatable,
        u8"missing catch variable name between parentheses",
        {
            u8"catch-Variablenname fehlt zwischen Klammern",
            u8"who's on second? \u26be",
            u8"nom de variable de capture manquante entre les parenth\u00e8ses",
            u8"falta o nome da vari\u00e1vel entre par\u00eanteses",
            u8"saknar catch variabelnamn mellan paranteser",
        },
    },
    {
        "missing class method or field after decorator"_translatable,
        u8"missing class method or field after decorator",
        {
            u8"missing class method or field after decorator",
            u8"missing class method or field after decorator",
            u8"missing class method or field after decorator",
            u8"missing class method or field after decorator",
            u8"missing class method or field after decorator",
        },
    },
    {
        "missing comma between generic parameters"_translatable,
        u8"missing comma between generic parameters",
        {
            u8"missing comma between generic parameters",
            u8"missing comma between generic parameters",
            u8"missing comma between generic parameters",
            u8"falta a v\u00edrgula entre os par\u00e2metros gen\u00e9ricos",
            u8"missing comma between generic parameters",
        },
    },
    {
        "missing comma between object literal entries"_translatable,
        u8"missing comma between object literal entries",
        {
            u8"Komma fehlt zwischen Feldern des Objekt-Literals",
            u8"separate these fellas with a comma",
            u8"virgule manquante entre les entr\u00e9es du litt\u00e9ral objet",
            u8"falta a v\u00edrgula entre as entradas do objeto",
            u8"saknar comma mellan f\u00f6rekommande objektliteral",
        },
    },
    {
        "missing comparison; '{1}' does not extend to the right side of '{0}'"_translatable,
        u8"missing comparison; '{1}' does not extend to the right side of '{0}'",
        {
            u8"Vergleich fehlt. '{1}' wird nicht auf der rechten Seite von '{0}' angewandt",
            u8"'{1}' and '{0}' don't tango",
            u8"missing comparison; '{1}' does not extend to the right side of '{0}'",
            u8"falta a compara\u00e7\u00e3o; '{1}' n\u00e3o se extende at\u00e9 o lado direito do '{0}'",
            u8"missing comparison; '{1}' does not extend to the right side of '{0}'",
        },
    },
    {
        "missing condition for if statement"_translatable,
        u8"missing condition for if statement",
        {
            u8"Bedingung der if-Anweisung fehlt",
            u8"if WHAT?!",
            u8"condition manquante pour l'instruction if",
            u8"falta a condi\u00e7\u00e3o da instru\u00e7\u00e3o if",
            u8"saknar vilkor i if p\u00e5st\u00e5ende",
        },
    },
    {
        "missing condition for switch statement"_translatable,
        u8"missing condition for switch statement",
        {
            u8"Bedingung des switch-Statements fehlt",
            u8"switch WHAT?!",
            u8"condition manquante pour l'instruction switch",
            u8"falta a condi\u00e7\u00e3o da instru\u00e7\u00e3o switch",
            u8"saknar vilkor f\u00f6r switch p\u00e5st\u00e5ende",
        },
    },
    {
        "missing condition for while statement"_translatable,
        u8"missing condition for while statement",
        {
            u8"Bedingung der while-Schleife fehlt",
            u8"while WHAT?!",
            u8"condition manquante pour l'instruction while",
            u8"falta a condi\u00e7\u00e3o da instru\u00e7\u00e3o while",
            u8"saknar vilkor f\u00f6r while p\u00e5st\u00e5ende",
        },
    },
    {
        "missing end of array; expected ']'"_translatable,
        u8"missing end of array; expected ']'",
        {
            u8"Ende des Arrays fehlt. ']' erwartet",
            u8"you forgot to close Pandora's Box",
            u8"fin de tableau manquante ; ']' attendu",
            u8"falta o fim da array; esperado ']'",
            u8"saknar slut av lista; f\u00f6rv\u00e4ntades ']'",
        },
    },
    {
        "missing expression after type assertion"_translatable,
        u8"missing expression after type assertion",
        {
            u8"missing expression after type assertion",
            u8"missing expression after type assertion",
            u8"missing expression after type assertion",
            u8"missing expression after type assertion",
            u8"missing expression after type assertion",
        },
    },
    {
        "missing expression between parentheses"_translatable,
        u8"missing expression between parentheses",
        {
            u8"Ausdruck fehlt zwischen Klammern",
            u8"(\U0001f636)",
            u8"expression manquante entre parenth\u00e8ses",
            u8"falta a express\u00e3o entre os par\u00eanteses",
            u8"saknar uttryck mellan paranteser",
        },
    },
    {
        "missing expression in placeholder within template literal"_translatable,
        u8"missing expression in placeholder within template literal",
        {
            u8"missing expression in placeholder within template literal",
            u8"missing expression in placeholder within template literal",
            u8"missing expression in placeholder within template literal",
            u8"missing expression in placeholder within template literal",
            u8"missing expression in placeholder within template literal",
        },
    },
    {
        "missing for loop header"_translatable,
        u8"missing for loop header",
        {
            u8"Kopf der Schleife fehlt",
            u8"for WHAT?!",
            u8"en-t\u00eate de boucle for manquante",
            u8"falta o header do for",
            u8"saknar for loop rubrik",
        },
    },
    {
        "missing function parameter list"_translatable,
        u8"missing function parameter list",
        {
            u8"Parameterliste der Funktion fehlt",
            u8"how are you gonna call this function without a parameter list?",
            u8"liste de param\u00e8tres de fonction manquante",
            u8"falta a lista de par\u00e2metros da fun\u00e7\u00e3o",
            u8"saknar funktions parameter lista",
        },
    },
    {
        "missing header and body for 'for' loop"_translatable,
        u8"missing header and body for 'for' loop",
        {
            u8"Kopf und K\u00f6rper der for-Schleife fehlen",
            u8"for WHAT?!",
            u8"en-t\u00eate et corps manquants pour la boucle 'for'",
            u8"falta o header e o conte\u00fado do loop 'for'",
            u8"saknar rubrik och stycke f\u00f6r 'for' loop",
        },
    },
    {
        "missing initializer in const declaration"_translatable,
        u8"missing initializer in const declaration",
        {
            u8"Initialisierung der const-Deklaration fehlt",
            u8"think about it this way. If you cannot reassign it, then const '{0}' would always be undefined.",
            u8"initialisateur manquant dans la d\u00e9claration const",
            u8"falta o inicializador na declara\u00e7\u00e3o constante",
            u8"missing initializer in const declaration",
        },
    },
    {
        "missing name for class method"_translatable,
        u8"missing name for class method",
        {
            u8"missing name for class method",
            u8"missing name for class method",
            u8"missing name for class method",
            u8"falta o nome do m\u00e9todo da classe",
            u8"missing name for class method",
        },
    },
    {
        "missing name for element in named tuple type"_translatable,
        u8"missing name for element in named tuple type",
        {
            u8"missing name for element in named tuple type",
            u8"missing name for element in named tuple type",
            u8"missing name for element in named tuple type",
            u8"falta o nome para o elemento na named tuple",
            u8"missing name for element in named tuple type",
        },
    },
    {
        "missing name in function statement"_translatable,
        u8"missing name in function statement",
        {
            u8"Name fehlt innerhalb function-Statement",
            u8"what's this function called?",
            u8"nom manquant pour l'instruction de fonction",
            u8"falta o nome da fun\u00e7\u00e3o",
            u8"saknar namn f\u00f6r funktions p\u00e5st\u00e5ende",
        },
    },
    {
        "missing name of class"_translatable,
        u8"missing name of class",
        {
            u8"Klassenname fehlt",
            u8"what's this class called?",
            u8"nom de classe manquant",
            u8"falta o nome da classe",
            u8"saknar namn f\u00f6r klass",
        },
    },
    {
        "missing name of exported class"_translatable,
        u8"missing name of exported class",
        {
            u8"Name der exportierten Klasse fehlt",
            u8"what's this class called? and why is it exported?",
            u8"nom de classe export\u00e9e manquant",
            u8"falta o nome da classe exportada",
            u8"saknar namn f\u00f6r exporterad klass",
        },
    },
    {
        "missing name of exported function"_translatable,
        u8"missing name of exported function",
        {
            u8"Name der exportierten Funktion fehlt",
            u8"what's this function called? and why is it exported?",
            u8"nom de fonction export\u00e9e manquant",
            u8"falta o nome da fun\u00e7\u00e3o exportada",
            u8"saknar namn f\u00f6r exporterad funktion",
        },
    },
    {
        "missing name or parentheses for function"_translatable,
        u8"missing name or parentheses for function",
        {
            u8"Name oder Klammern fehlen f\u00fcr die Funktion",
            u8"IIFEs are uglier. try again.",
            u8"nom ou parenth\u00e8ses manquants pour la fonction",
            u8"falta o nome ou os par\u00eanteses da fun\u00e7\u00e3o",
            u8"saknar namn eller paranteser f\u00f6r funktion",
        },
    },
    {
        "missing operand for operator"_translatable,
        u8"missing operand for operator",
        {
            u8"Operand des Operators fehlt",
            u8"who taught you math? a gym teacher? \U0001f469\u200d\U0001f3eb",
            u8"op\u00e9rande manquante pour l'op\u00e9rateur",
            u8"falta o operando",
            u8"saknar operand f\u00f6r operat\u00f6r",
        },
    },
    {
        "missing operator between expression and arrow function"_translatable,
        u8"missing operator between expression and arrow function",
        {
            u8"Operator fehlt zwischen Ausdruck und Arrow-Funktion",
            u8"did you forget something here?",
            u8"op\u00e9rateur manquant entre l'expression et la fonction fl\u00e9ch\u00e9e",
            u8"falta o operador entre a express\u00e3o e a arrow function",
            u8"saknar operat\u00f6r mellan uttryck och pilfunktion",
        },
    },
    {
        "missing parameter name"_translatable,
        u8"missing parameter name",
        {
            u8"missing parameter name",
            u8"missing parameter name",
            u8"missing parameter name",
            u8"missing parameter name",
            u8"missing parameter name",
        },
    },
    {
        "missing parameters for arrow function"_translatable,
        u8"missing parameters for arrow function",
        {
            u8"Parameter fehlen f\u00fcr Arrow-Funktion",
            u8"you forgot the parameters",
            u8"param\u00e8tres manquants pour la fonction fl\u00e9ch\u00e9e",
            u8"faltam os par\u00eanteses da arrow function",
            u8"saknar parametrar f\u00f6re pilfunktion",
        },
    },
    {
        "missing parentheses around left-hand side of '**'"_translatable,
        u8"missing parentheses around left-hand side of '**'",
        {
            u8"Klammern um linke Seite von '**' fehlen",
            u8"JavaScript is stupid, so you need parentheses",
            u8"missing parentheses around left-hand side of '**'",
            u8"faltam os par\u00eanteses ao redor do lado esquerdo do '**'",
            u8"missing parentheses around left-hand side of '**'",
        },
    },
    {
        "missing parentheses around operand of '{0}'"_translatable,
        u8"missing parentheses around operand of '{0}'",
        {
            u8"Klammern fehlen um den Operanden von '{0}'",
            u8"JavaScript is stupid, so you need parentheses",
            u8"missing parentheses around operand of '{0}'",
            u8"faltam os par\u00eanteses ao redor do operando de '{0}'",
            u8"missing parentheses around operand of '{0}'",
        },
    },
    {
        "missing parentheses around parameter"_translatable,
        u8"missing parentheses around parameter",
        {
            u8"missing parentheses around parameter",
            u8"missing parentheses around parameter",
            u8"missing parentheses around parameter",
            u8"faltam os par\u00eanteses ao redor do par\u00e2metro",
            u8"missing parentheses around parameter",
        },
    },
    {
        "missing parentheses around self-invoked function"_translatable,
        u8"missing parentheses around self-invoked function",
        {
            u8"Klammern um selbstaufgerufene Funktion fehlen",
            u8"IIFEs are uglier. try again.",
            u8"missing parentheses around self-invoked function",
            u8"faltam os par\u00eanteses em volta da fun\u00e7\u00e3o invocada",
            u8"missing parentheses around self-invoked function",
        },
    },
    {
        "missing property name after '.' operator"_translatable,
        u8"missing property name after '.' operator",
        {
            u8"Eigenschaftsname fehlt nach dem '.'-Operator",
            u8"dot WHAT?!",
            u8"nom de propri\u00e9t\u00e9 manquant apr\u00e8s l'op\u00e9rateur '.'",
            u8"falta o nome da propriedade ap\u00f3s o operador '.'",
            u8"saknar egenskaps namn efter '.' operat\u00f6r",
        },
    },
    {
        "missing property name between '.' and '.'"_translatable,
        u8"missing property name between '.' and '.'",
        {
            u8"Eigenschaftsname fehlt zwischen '.' und '.'",
            u8"._.",
            u8"nom de propri\u00e9t\u00e9 manquante entre '.' et '.'",
            u8"falta o nome da propriedade entre '.' e '.'",
            u8"missing property name between '.' and '.'",
        },
    },
    {
        "missing quotes around module name '{0}'"_translatable,
        u8"missing quotes around module name '{0}'",
        {
            u8"missing quotes around module name '{0}'",
            u8"missing quotes around module name '{0}'",
            u8"missing quotes around module name '{0}'",
            u8"faltam aspas em volta do nome do m\u00f3dulo '{0}'",
            u8"missing quotes around module name '{0}'",
        },
    },
    {
        "missing semicolon after 'declare class' method"_translatable,
        u8"missing semicolon after 'declare class' method",
        {
            u8"missing semicolon after 'declare class' method",
            u8"missing semicolon after 'declare class' method",
            u8"missing semicolon after 'declare class' method",
            u8"missing semicolon after 'declare class' method",
            u8"missing semicolon after 'declare class' method",
        },
    },
    {
        "missing semicolon after abstract method"_translatable,
        u8"missing semicolon after abstract method",
        {
            u8"missing semicolon after abstract method",
            u8"missing semicolon after abstract method",
            u8"missing semicolon after abstract method",
            u8"falta o ponto e v\u00edrgula ap\u00f3s o m\u00e9todo abstrato",
            u8"missing semicolon after abstract method",
        },
    },
    {
        "missing semicolon after field"_translatable,
        u8"missing semicolon after field",
        {
            u8"missing semicolon after field",
            u8"missing semicolon after field",
            u8"missing semicolon after field",
            u8"falta o ponto e v\u00edrgula ap\u00f3s o campo",
            u8"missing semicolon after field",
        },
    },
    {
        "missing semicolon after index signature"_translatable,
        u8"missing semicolon after index signature",
        {
            u8"missing semicolon after index signature",
            u8"missing semicolon after index signature",
            u8"missing semicolon after index signature",
            u8"falta o ponto e v\u00edrgula no index signature",
            u8"missing semicolon after index signature",
        },
    },
    {
        "missing semicolon after interface method"_translatable,
        u8"missing semicolon after interface method",
        {
            u8"missing semicolon after interface method",
            u8"missing semicolon after interface method",
            u8"missing semicolon after interface method",
            u8"falta o ponto e v\u00edrgula ap\u00f3s o m\u00e9todo da interface",
            u8"missing semicolon after interface method",
        },
    },
    {
        "missing semicolon after method overload signature"_translatable,
        u8"missing semicolon after method overload signature",
        {
            u8"missing semicolon after method overload signature",
            u8"missing semicolon after method overload signature",
            u8"missing semicolon after method overload signature",
            u8"missing semicolon after method overload signature",
            u8"missing semicolon after method overload signature",
        },
    },
    {
        "missing semicolon after statement"_translatable,
        u8"missing semicolon after statement",
        {
            u8"Semikolon fehlt nach Anweisung",
            u8"I know you hate semicolons, but you need one here",
            u8"point-virgule manquant apr\u00e8s l'instruction",
            u8"falta o ponto e v\u00edrgula ap\u00f3s a instru\u00e7\u00e3o",
            u8"saknar semikolon efter p\u00e5st\u00e5ende",
        },
    },
    {
        "missing semicolon between condition and update parts of for loop"_translatable,
        u8"missing semicolon between condition and update parts of for loop",
        {
            u8"Semikolon fehlt zwischen Bedingung und Update-Anweisung der for-Schleife",
            u8"automatic semicolon insertion doesn't work here, buddy",
            u8"point-virgule manquant entre la condition et l'actualisation de la boucle for",
            u8"falta o ponto e v\u00edrgula entre as partes da condi\u00e7\u00e3o e da atualiza\u00e7\u00e3o do for",
            u8"saknar semikolon mellan vilkor och updaterings delen i for loopen",
        },
    },
    {
        "missing semicolon between init and condition parts of for loop"_translatable,
        u8"missing semicolon between init and condition parts of for loop",
        {
            u8"Semikolon fehlt zwischen Initialisierung und Bedingung der for-Schleife",
            u8"automatic semicolon insertion doesn't work here, buddy",
            u8"point-virgule manquant entre l'initialisation et la condition de la boucle for",
            u8"falta o ponto e v\u00edrgula entre as partes da inicializa\u00e7\u00e3o e da condi\u00e7\u00e3o do for",
            u8"saknar semikolon mellan start och vilkors delen i for loopen",
        },
    },
    {
        "missing type between '{1}' and '{0}'"_translatable,
        u8"missing type between '{1}' and '{0}'",
        {
            u8"missing type between '{1}' and '{0}'",
            u8"missing type between '{1}' and '{0}'",
            u8"missing type between '{1}' and '{0}'",
            u8"falta a tipagem entre '{1}' e '{0}'",
            u8"missing type between '{1}' and '{0}'",
        },
    },
    {
        "missing value for object property"_translatable,
        u8"missing value for object property",
        {
            u8"Wert der Objekteigenschaft fehlt",
            u8"follow this up with a value or something",
            u8"valeur manquante pour la propri\u00e9t\u00e9 d'objet",
            u8"falta o valor para a propriedade do objeto",
            u8"saknar v\u00e4rde f\u00f6r objektegenskap",
        },
    },
    {
        "missing variable name"_translatable,
        u8"missing variable name",
        {
            u8"Variablenname fehlt",
            u8"you forgot the variable name",
            u8"nom de variable manquant",
            u8"falta o nome da vari\u00e1vel",
            u8"saknar variabel namn",
        },
    },
    {
        "misspelled React attribute; write '{1}' instead"_translatable,
        u8"misspelled React attribute; write '{1}' instead",
        {
            u8"React-Attribut ist falsch geschrieben; '{1}' anstattdessen schreiben",
            u8"it's spelled '{1}', silly",
            u8"misspelled React attribute; write '{1}' instead",
            u8"erro de digita\u00e7\u00e3o no atributo de React; use '{1}'",
            u8"misspelled React attribute; write '{1}' instead",
        },
    },
    {
        "move the 'extends' clause before 'implements' here"_translatable,
        u8"move the 'extends' clause before 'implements' here",
        {
            u8"move the 'extends' clause before 'implements' here",
            u8"move the 'extends' clause before 'implements' here",
            u8"move the 'extends' clause before 'implements' here",
            u8"mova a cl\u00e1usula 'extends' para antes do 'implements' aqui",
            u8"move the 'extends' clause before 'implements' here",
        },
    },
    {
        "move the parameter decorator before '{0}' here"_translatable,
        u8"move the parameter decorator before '{0}' here",
        {
            u8"move the parameter decorator before '{0}' here",
            u8"move the parameter decorator before '{0}' here",
            u8"move the parameter decorator before '{0}' here",
            u8"move the parameter decorator before '{0}' here",
            u8"move the parameter decorator before '{0}' here",
        },
    },
    {
        "namespace"_translatable,
        u8"namespace",
        {
            u8"namespace",
            u8"namespace",
            u8"namespace",
            u8"namespace",
            u8"namespace",
        },
    },
    {
        "namespace alias cannot use 'import type'"_translatable,
        u8"namespace alias cannot use 'import type'",
        {
            u8"namespace alias cannot use 'import type'",
            u8"namespace alias cannot use 'import type'",
            u8"namespace alias cannot use 'import type'",
            u8"namespace alias cannot use 'import type'",
            u8"namespace alias cannot use 'import type'",
        },
    },
    {
        "namespace starts here"_translatable,
        u8"namespace starts here",
        {
            u8"namespace starts here",
            u8"namespace starts here",
            u8"namespace starts here",
            u8"namespace starts here",
            u8"namespace starts here",
        },
    },
    {
        "new variable shadows existing variable"_translatable,
        u8"new variable shadows existing variable",
        {
            u8"Neue Variable macht bereits existierende unsichtbar",
            u8"I think you meant to assign...",
            u8"new variable shadows existing variable",
            u8"nova vari\u00e1vel oculta uma vari\u00e1vel existente",
            u8"new variable shadows existing variable",
        },
    },
    {
        "newline is not allowed after 'abstract'"_translatable,
        u8"newline is not allowed after 'abstract'",
        {
            u8"newline is not allowed after 'abstract'",
            u8"newline is not allowed after 'abstract'",
            u8"newline is not allowed after 'abstract'",
            u8"quebra de linha n\u00e3o \u00e9 permitida ap\u00f3s 'abstract'",
            u8"newline is not allowed after 'abstract'",
        },
    },
    {
        "newline is not allowed after 'asserts'"_translatable,
        u8"newline is not allowed after 'asserts'",
        {
            u8"newline is not allowed after 'asserts'",
            u8"newline is not allowed after 'asserts'",
            u8"newline is not allowed after 'asserts'",
            u8"newline is not allowed after 'asserts'",
            u8"newline is not allowed after 'asserts'",
        },
    },
    {
        "newline is not allowed after 'export declare'"_translatable,
        u8"newline is not allowed after 'export declare'",
        {
            u8"newline is not allowed after 'export declare'",
            u8"newline is not allowed after 'export declare'",
            u8"newline is not allowed after 'export declare'",
            u8"newline is not allowed after 'export declare'",
            u8"newline is not allowed after 'export declare'",
        },
    },
    {
        "newline is not allowed after 'interface'"_translatable,
        u8"newline is not allowed after 'interface'",
        {
            u8"newline is not allowed after 'interface'",
            u8"newline is not allowed after 'interface'",
            u8"newline is not allowed after 'interface'",
            u8"quebra de linha n\u00e3o \u00e9 permitida ap\u00f3s 'interface'",
            u8"newline is not allowed after 'interface'",
        },
    },
    {
        "newline is not allowed after 'type'"_translatable,
        u8"newline is not allowed after 'type'",
        {
            u8"newline is not allowed after 'type'",
            u8"newline is not allowed after 'type'",
            u8"newline is not allowed after 'type'",
            u8"quebra de linha n\u00e3o \u00e9 permitida ap\u00f3s 'type'",
            u8"newline is not allowed after 'type'",
        },
    },
    {
        "newline is not allowed after '{0}'"_translatable,
        u8"newline is not allowed after '{0}'",
        {
            u8"newline is not allowed after '{0}'",
            u8"newline is not allowed after '{0}'",
            u8"newline is not allowed after '{0}'",
            u8"newline is not allowed after '{0}'",
            u8"newline is not allowed after '{0}'",
        },
    },
    {
        "newline is not allowed after '{0}' modifier in generic parameter"_translatable,
        u8"newline is not allowed after '{0}' modifier in generic parameter",
        {
            u8"newline is not allowed after '{0}' modifier in generic parameter",
            u8"newline is not allowed after '{0}' modifier in generic parameter",
            u8"newline is not allowed after '{0}' modifier in generic parameter",
            u8"newline is not allowed after '{0}' modifier in generic parameter",
            u8"newline is not allowed after '{0}' modifier in generic parameter",
        },
    },
    {
        "newline is not allowed before '<'"_translatable,
        u8"newline is not allowed before '<'",
        {
            u8"newline is not allowed before '<'",
            u8"newline is not allowed before '<'",
            u8"newline is not allowed before '<'",
            u8"newline is not allowed before '<'",
            u8"newline is not allowed before '<'",
        },
    },
    {
        "newline is not allowed before 'extends'"_translatable,
        u8"newline is not allowed before 'extends'",
        {
            u8"newline is not allowed before 'extends'",
            u8"newline is not allowed before 'extends'",
            u8"newline is not allowed before 'extends'",
            u8"newline is not allowed before 'extends'",
            u8"newline is not allowed before 'extends'",
        },
    },
    {
        "newline is not allowed before 'is'"_translatable,
        u8"newline is not allowed before 'is'",
        {
            u8"newline is not allowed before 'is'",
            u8"newline is not allowed before 'is'",
            u8"newline is not allowed before 'is'",
            u8"newline is not allowed before 'is'",
            u8"newline is not allowed before 'is'",
        },
    },
    {
        "newline is not allowed between 'async' and 'function'"_translatable,
        u8"newline is not allowed between 'async' and 'function'",
        {
            u8"newline is not allowed between 'async' and 'function'",
            u8"newline is not allowed between 'async' and 'function'",
            u8"newline is not allowed between 'async' and 'function'",
            u8"quebra de linha n\u00e3o \u00e9 permitida entre 'async' e 'function'",
            u8"newline is not allowed between 'async' and 'function'",
        },
    },
    {
        "newline is not allowed between 'async' and arrow function parameter list"_translatable,
        u8"newline is not allowed between 'async' and arrow function parameter list",
        {
            u8"Zeilenumbruch ist zwischen 'async' und Arrow-Funktion verboten",
            u8"put this on a single line, please",
            u8"un saut de ligne n'est pas autoris\u00e9 entre 'async' et la liste de param\u00e8tres d'une fonction fl\u00e9ch\u00e9e",
            u8"quebra de linha n\u00e3o \u00e9 permitida entre 'async' e lista de par\u00e2metros da arrow function",
            u8"nyrad \u00e4r inte till\u00e5ten mellan 'async' och pilfunktions parameter lista",
        },
    },
    {
        "newline is not allowed between '{0}' and the method name"_translatable,
        u8"newline is not allowed between '{0}' and the method name",
        {
            u8"newline is not allowed between '{0}' and the method name",
            u8"newline is not allowed between '{0}' and the method name",
            u8"newline is not allowed between '{0}' and the method name",
            u8"newline is not allowed between '{0}' and the method name",
            u8"newline is not allowed between '{0}' and the method name",
        },
    },
    {
        "newline is not allowed between field name and '!'"_translatable,
        u8"newline is not allowed between field name and '!'",
        {
            u8"newline is not allowed between field name and '!'",
            u8"newline is not allowed between field name and '!'",
            u8"newline is not allowed between field name and '!'",
            u8"quebra de linha n\u00e3o \u00e9 permitida entre o nome do campo e o '!'",
            u8"newline is not allowed between field name and '!'",
        },
    },
    {
        "newline is not allowed between variable name and '!'"_translatable,
        u8"newline is not allowed between variable name and '!'",
        {
            u8"newline is not allowed between variable name and '!'",
            u8"newline is not allowed between variable name and '!'",
            u8"newline is not allowed between variable name and '!'",
            u8"newline is not allowed between variable name and '!'",
            u8"newline is not allowed between variable name and '!'",
        },
    },
    {
        "nullish coalescing operator does nothing when left operand is never null"_translatable,
        u8"nullish coalescing operator does nothing when left operand is never null",
        {
            u8"nullish coalescing operator does nothing when left operand is never null",
            u8"nullish coalescing operator does nothing when left operand is never null",
            u8"nullish coalescing operator does nothing when left operand is never null",
            u8"nullish coalescing operator does nothing when left operand is never null",
            u8"nullish coalescing operator does nothing when left operand is never null",
        },
    },
    {
        "number literal contains consecutive underscores"_translatable,
        u8"number literal contains consecutive underscores",
        {
            u8"Zahlenliteral darf keine aufeinanderfolgenden Unterstriche enthalten",
            u8"too__many__underscores",
            u8"le litt\u00e9ral num\u00e9rique contient plusieurs tirets de soulignement cons\u00e9cutifs",
            u8"n\u00famero cont\u00e9m underscores consecutivos",
            u8"numerlitter\u00e4r inneh\u00e5ller upprepande understr\u00e4ck",
        },
    },
    {
        "number literal contains trailing underscore(s)"_translatable,
        u8"number literal contains trailing underscore(s)",
        {
            u8"Zahlenliteral endet mit Unterstrich(en)",
            u8"too_many_underscores_____",
            u8"le litt\u00e9ral num\u00e9rique est suivi d'un tiret de soulignement",
            u8"n\u00famero cont\u00e9m underscore(s) no final",
            u8"nummerlitter\u00e4r inneh\u00e5ller efterf\u00f6ljande understr\u00e4ck",
        },
    },
    {
        "object literal started here"_translatable,
        u8"object literal started here",
        {
            u8"Objektliteral beginnt hier",
            u8"runaway object literal started here",
            u8"litt\u00e9ral objet d\u00e9but\u00e9 ici",
            u8"objeto iniciou aqui",
            u8"objektlitteral startades h\u00e4r",
        },
    },
    {
        "octal literal may not have decimal"_translatable,
        u8"octal literal may not have decimal",
        {
            u8"Oktalliterale mit Dezimalpunkt sind nicht erlaubt",
            u8"but you said '0o'...",
            u8"un litt\u00e9ral octal ne peut avoir de partie d\u00e9cimale",
            u8"n\u00famero octal n\u00e3o pode ter casa decimal",
            u8"oktal nummerlitter\u00e4l kan inte ha decimaler",
        },
    },
    {
        "octal literal may not have exponent"_translatable,
        u8"octal literal may not have exponent",
        {
            u8"Oktalliterale mit Exponenten sind nicht erlaubt",
            u8"scientists don't use octal",
            u8"un litt\u00e9ral octal ne peut avoir d'exposant",
            u8"n\u00famero octal n\u00e3o pode ter expoente",
            u8"oktal nummerlitter\u00e4l kan inte ha exponent",
        },
    },
    {
        "octal number literal has no digits"_translatable,
        u8"octal number literal has no digits",
        {
            u8"Oktales Zahlenliteral ohne Ziffern",
            u8"<octupus-with-no-legs> has no digits",
            u8"le litt\u00e9ral num\u00e9rique octal n'a pas de chiffres",
            u8"n\u00famero octal n\u00e3o tem d\u00edgitos",
            u8"oktal nummerlitteral har inga siffror",
        },
    },
    {
        "only one comma is allowed between or after generic parameters"_translatable,
        u8"only one comma is allowed between or after generic parameters",
        {
            u8"only one comma is allowed between or after generic parameters",
            u8"only one comma is allowed between or after generic parameters",
            u8"only one comma is allowed between or after generic parameters",
            u8"apenas uma v\u00edrgula \u00e9 permitida entre ou ap\u00f3s par\u00e2metros gen\u00e9ricos",
            u8"only one comma is allowed between or after generic parameters",
        },
    },
    {
        "only optional tuple elements can follow this optional tuple element"_translatable,
        u8"only optional tuple elements can follow this optional tuple element",
        {
            u8"only optional tuple elements can follow this optional tuple element",
            u8"only optional tuple elements can follow this optional tuple element",
            u8"only optional tuple elements can follow this optional tuple element",
            u8"apenas elementos opcionais da tupla podem prosseguir esse elemento opcional",
            u8"only optional tuple elements can follow this optional tuple element",
        },
    },
    {
        "opening '<{1}>' tag here"_translatable,
        u8"opening '<{1}>' tag here",
        {
            u8"\u00d6ffnender '<{1}>' Tag ist hier",
            u8"\U0001f631 '<{1}>'",
            u8"opening '<{1}>' tag here",
            u8"tag de abertura '<{1}>' aqui",
            u8"opening '<{1}>' tag here",
        },
    },
    {
        "optional parameter cannot be followed by a required parameter"_translatable,
        u8"optional parameter cannot be followed by a required parameter",
        {
            u8"optional parameter cannot be followed by a required parameter",
            u8"optional parameter cannot be followed by a required parameter",
            u8"optional parameter cannot be followed by a required parameter",
            u8"optional parameter cannot be followed by a required parameter",
            u8"optional parameter cannot be followed by a required parameter",
        },
    },
    {
        "optional parameter cannot have both '?' and initializer; remove '?'"_translatable,
        u8"optional parameter cannot have both '?' and initializer; remove '?'",
        {
            u8"optional parameter cannot have both '?' and initializer; remove '?'",
            u8"optional parameter cannot have both '?' and initializer; remove '?'",
            u8"optional parameter cannot have both '?' and initializer; remove '?'",
            u8"par\u00e2metro opcional n\u00e3o pode ter '?' e inicializador; remova o '?'",
            u8"optional parameter cannot have both '?' and initializer; remove '?'",
        },
    },
    {
        "optional tuple elements cannot come after spread elements"_translatable,
        u8"optional tuple elements cannot come after spread elements",
        {
            u8"optional tuple elements cannot come after spread elements",
            u8"optional tuple elements cannot come after spread elements",
            u8"optional tuple elements cannot come after spread elements",
            u8"optional tuple elements cannot come after spread elements",
            u8"optional tuple elements cannot come after spread elements",
        },
    },
    {
        "original semicolon is here"_translatable,
        u8"original semicolon is here",
        {
            u8"original semicolon is here",
            u8"original semicolon is here",
            u8"original semicolon is here",
            u8"original semicolon is here",
            u8"original semicolon is here",
        },
    },
    {
        "overload signature must have the correct access specifier ('{1}')"_translatable,
        u8"overload signature must have the correct access specifier ('{1}')",
        {
            u8"overload signature must have the correct access specifier ('{1}')",
            u8"overload signature must have the correct access specifier ('{1}')",
            u8"overload signature must have the correct access specifier ('{1}')",
            u8"overload signature must have the correct access specifier ('{1}')",
            u8"overload signature must have the correct access specifier ('{1}')",
        },
    },
    {
        "overload signature must match modifiers on this overload method"_translatable,
        u8"overload signature must match modifiers on this overload method",
        {
            u8"overload signature must match modifiers on this overload method",
            u8"overload signature must match modifiers on this overload method",
            u8"overload signature must match modifiers on this overload method",
            u8"overload signature must match modifiers on this overload method",
            u8"overload signature must match modifiers on this overload method",
        },
    },
    {
        "overloaded function '{0}' declared here"_translatable,
        u8"overloaded function '{0}' declared here",
        {
            u8"overloaded function '{0}' declared here",
            u8"overloaded function '{0}' declared here",
            u8"overloaded function '{0}' declared here",
            u8"fun\u00e7\u00e3o overloaded '{0}' declarada aqui",
            u8"overloaded function '{0}' declared here",
        },
    },
    {
        "overloaded method is marked '{0}'"_translatable,
        u8"overloaded method is marked '{0}'",
        {
            u8"overloaded method is marked '{0}'",
            u8"overloaded method is marked '{0}'",
            u8"overloaded method is marked '{0}'",
            u8"overloaded method is marked '{0}'",
            u8"overloaded method is marked '{0}'",
        },
    },
    {
        "override properties are not allowed in interfaces"_translatable,
        u8"override properties are not allowed in interfaces",
        {
            u8"override properties are not allowed in interfaces",
            u8"override properties are not allowed in interfaces",
            u8"override properties are not allowed in interfaces",
            u8"override properties are not allowed in interfaces",
            u8"override properties are not allowed in interfaces",
        },
    },
    {
        "parameter"_translatable,
        u8"parameter",
        {
            u8"parameter",
            u8"parameter",
            u8"parameter",
            u8"parameter",
            u8"parameter",
        },
    },
    {
        "parameter decorator must be before other modifiers"_translatable,
        u8"parameter decorator must be before other modifiers",
        {
            u8"parameter decorator must be before other modifiers",
            u8"parameter decorator must be before other modifiers",
            u8"parameter decorator must be before other modifiers",
            u8"parameter decorator must be before other modifiers",
            u8"parameter decorator must be before other modifiers",
        },
    },
    {
        "parameter decorators are not allowed in 'declare class'"_translatable,
        u8"parameter decorators are not allowed in 'declare class'",
        {
            u8"parameter decorators are not allowed in 'declare class'",
            u8"parameter decorators are not allowed in 'declare class'",
            u8"parameter decorators are not allowed in 'declare class'",
            u8"parameter decorators are not allowed in 'declare class'",
            u8"parameter decorators are not allowed in 'declare class'",
        },
    },
    {
        "parameter decorators are not allowed in abstract methods"_translatable,
        u8"parameter decorators are not allowed in abstract methods",
        {
            u8"parameter decorators are not allowed in abstract methods",
            u8"parameter decorators are not allowed in abstract methods",
            u8"parameter decorators are not allowed in abstract methods",
            u8"parameter decorators are not allowed in abstract methods",
            u8"parameter decorators are not allowed in abstract methods",
        },
    },
    {
        "parameter decorators are only allowed in class methods"_translatable,
        u8"parameter decorators are only allowed in class methods",
        {
            u8"parameter decorators are only allowed in class methods",
            u8"parameter decorators are only allowed in class methods",
            u8"parameter decorators are only allowed in class methods",
            u8"parameter decorators are only allowed in class methods",
            u8"parameter decorators are only allowed in class methods",
        },
    },
    {
        "parameter properties are not allowed in 'declare class'"_translatable,
        u8"parameter properties are not allowed in 'declare class'",
        {
            u8"parameter properties are not allowed in 'declare class'",
            u8"parameter properties are not allowed in 'declare class'",
            u8"parameter properties are not allowed in 'declare class'",
            u8"parameter properties are not allowed in 'declare class'",
            u8"parameter properties are not allowed in 'declare class'",
        },
    },
    {
        "parameter properties are only allowed in class constructors"_translatable,
        u8"parameter properties are only allowed in class constructors",
        {
            u8"parameter properties are only allowed in class constructors",
            u8"parameter properties are only allowed in class constructors",
            u8"parameter properties are only allowed in class constructors",
            u8"parameter properties are only allowed in class constructors",
            u8"parameter properties are only allowed in class constructors",
        },
    },
    {
        "parameter properties cannot be a rest parameter"_translatable,
        u8"parameter properties cannot be a rest parameter",
        {
            u8"parameter properties cannot be a rest parameter",
            u8"parameter properties cannot be a rest parameter",
            u8"parameter properties cannot be a rest parameter",
            u8"parameter properties cannot be a rest parameter",
            u8"parameter properties cannot be a rest parameter",
        },
    },
    {
        "parameter properties cannot be destructured"_translatable,
        u8"parameter properties cannot be destructured",
        {
            u8"parameter properties cannot be destructured",
            u8"parameter properties cannot be destructured",
            u8"parameter properties cannot be destructured",
            u8"parameter properties cannot be destructured",
            u8"parameter properties cannot be destructured",
        },
    },
    {
        "parentheses are required around 'infer {1}'"_translatable,
        u8"parentheses are required around 'infer {1}'",
        {
            u8"parentheses are required around 'infer {1}'",
            u8"parentheses are required around 'infer {1}'",
            u8"parentheses are required around 'infer {1}'",
            u8"parentheses are required around 'infer {1}'",
            u8"parentheses are required around 'infer {1}'",
        },
    },
    {
        "prior spread element is here"_translatable,
        u8"prior spread element is here",
        {
            u8"prior spread element is here",
            u8"prior spread element is here",
            u8"prior spread element is here",
            u8"prior spread element is here",
            u8"prior spread element is here",
        },
    },
    {
        "private identifiers are not allowed for 'declare' fields; use 'private' instead"_translatable,
        u8"private identifiers are not allowed for 'declare' fields; use 'private' instead",
        {
            u8"private identifiers are not allowed for 'declare' fields; use 'private' instead",
            u8"private identifiers are not allowed for 'declare' fields; use 'private' instead",
            u8"private identifiers are not allowed for 'declare' fields; use 'private' instead",
            u8"private identifiers are not allowed for 'declare' fields; use 'private' instead",
            u8"private identifiers are not allowed for 'declare' fields; use 'private' instead",
        },
    },
    {
        "private properties are not allowed in object literals"_translatable,
        u8"private properties are not allowed in object literals",
        {
            u8"Innerhalb von Objektliteralen sind private Eigenschaften verboten",
            u8"objects can't have privates \U0001f92b",
            u8"les propri\u00e9t\u00e9s priv\u00e9es ne sont pas autoris\u00e9es dans les litt\u00e9raux objet",
            u8"propriedades privadas n\u00e3o s\u00e3o permitidas em objetos",
            u8"privata egenskaper \u00e4r inte till\u00e5tna i objektlitter\u00e4ler",
        },
    },
    {
        "property declared 'abstract' here"_translatable,
        u8"property declared 'abstract' here",
        {
            u8"property declared 'abstract' here",
            u8"property declared 'abstract' here",
            u8"property declared 'abstract' here",
            u8"property declared 'abstract' here",
            u8"property declared 'abstract' here",
        },
    },
    {
        "property declared static here"_translatable,
        u8"property declared static here",
        {
            u8"property declared static here",
            u8"property declared static here",
            u8"property declared static here",
            u8"property declared static here",
            u8"property declared static here",
        },
    },
    {
        "property declared using '{0}' here"_translatable,
        u8"property declared using '{0}' here",
        {
            u8"property declared using '{0}' here",
            u8"property declared using '{0}' here",
            u8"property declared using '{0}' here",
            u8"property declared using '{0}' here",
            u8"property declared using '{0}' here",
        },
    },
    {
        "redeclaration of global variable"_translatable,
        u8"redeclaration of global variable",
        {
            u8"Globale Variable wird erneut deklariert",
            u8"you already have this global",
            u8"red\u00e9claration de variable globale",
            u8"redeclara\u00e7\u00e3o de vari\u00e1vel global",
            u8"omdeklaration av global variabel",
        },
    },
    {
        "redeclaration of variable: {0}"_translatable,
        u8"redeclaration of variable: {0}",
        {
            u8"Variable '{0}' wird erneut deklariert",
            u8"you couldn't get enough of {0}, so you had to make two, huh?",
            u8"red\u00e9claration de variable: {0}",
            u8"redeclara\u00e7\u00e3o de vari\u00e1vel: {0}",
            u8"omdekleration av variabel: {0}",
        },
    },
    {
        "redundant 'await'"_translatable,
        u8"redundant 'await'",
        {
            u8"redundant 'await'",
            u8"redundant 'await'",
            u8"redundant 'await'",
            u8"'await' redundante",
            u8"redundant 'await'",
        },
    },
    {
        "redundant delete statement on variable"_translatable,
        u8"redundant delete statement on variable",
        {
            u8"Unn\u00f6tiges delete-Statement f\u00fcr Variable",
            u8"you really hate variables, huh? too bad; this doesn't work",
            u8"instruction delete redondante pour la variable",
            u8"instru\u00e7\u00e3o delete na vari\u00e1vel \u00e9 redundante",
            u8"redundant delete p\u00e5st\u00e5ende f\u00f6r variabel",
        },
    },
    {
        "remove '{0}' to update an existing variable"_translatable,
        u8"remove '{0}' to update an existing variable",
        {
            u8"Entferne '{0}' um die vorhandene Variable zu updaten",
            u8"or yeet '{0}'",
            u8"supprimer '{0}' pour actualiser une variable existante",
            u8"remova '{0}' para atualizar uma vari\u00e1vel j\u00e1 existente",
            u8"ta bort '{0}' f\u00f6r att uppdatera en existerande variabel",
        },
    },
    {
        "remove this 'type'"_translatable,
        u8"remove this 'type'",
        {
            u8"remove this 'type'",
            u8"remove this 'type'",
            u8"remove this 'type'",
            u8"remova esse 'type'",
            u8"remove this 'type'",
        },
    },
    {
        "return statement returns nothing (undefined)"_translatable,
        u8"return statement returns nothing (undefined)",
        {
            u8"Return-Statement gibt nichts (undefined) zur\u00fcck",
            u8"you forgot to return something",
            u8"l'instruction de retour ne retourne rien (undefined)",
            u8"instru\u00e7\u00e3o de return n\u00e3o retorna nada (undefined)",
            u8"return statement returns nothing (undefined)",
        },
    },
    {
        "see here"_translatable,
        u8"see here",
        {
            u8"siehe hier",
            u8"see here",
            u8"see here",
            u8"veja aqui",
            u8"see here",
        },
    },
    {
        "semicolon is not allowed after decorators"_translatable,
        u8"semicolon is not allowed after decorators",
        {
            u8"semicolon is not allowed after decorators",
            u8"semicolon is not allowed after decorators",
            u8"semicolon is not allowed after decorators",
            u8"semicolon is not allowed after decorators",
            u8"semicolon is not allowed after decorators",
        },
    },
    {
        "something happened"_translatable,
        u8"something happened",
        {
            u8"etwas geschah",
            u8"I wish you never happened",
            u8"something happened",
            u8"algo aconteceu",
            u8"something happened",
        },
    },
    {
        "space is required between '<' and '<' inside {1:headlinese}"_translatable,
        u8"space is required between '<' and '<' inside {1:headlinese}",
        {
            u8"space is required between '<' and '<' inside {1:headlinese}",
            u8"space is required between '<' and '<' inside {1:headlinese}",
            u8"space is required between '<' and '<' inside {1:headlinese}",
            u8"space is required between '<' and '<' inside {1:headlinese}",
            u8"space is required between '<' and '<' inside {1:headlinese}",
        },
    },
    {
        "spread starts here"_translatable,
        u8"spread starts here",
        {
            u8"spread starts here",
            u8"spread starts here",
            u8"spread starts here",
            u8"spread starts here",
            u8"spread starts here",
        },
    },
    {
        "spread tuple elements cannot be optional"_translatable,
        u8"spread tuple elements cannot be optional",
        {
            u8"spread tuple elements cannot be optional",
            u8"spread tuple elements cannot be optional",
            u8"spread tuple elements cannot be optional",
            u8"spread tuple elements cannot be optional",
            u8"spread tuple elements cannot be optional",
        },
    },
    {
        "static block starts here"_translatable,
        u8"static block starts here",
        {
            u8"static block starts here",
            u8"static block starts here",
            u8"static block starts here",
            u8"static block starts here",
            u8"static block starts here",
        },
    },
    {
        "static blocks cannot have a decorator"_translatable,
        u8"static blocks cannot have a decorator",
        {
            u8"static blocks cannot have a decorator",
            u8"static blocks cannot have a decorator",
            u8"static blocks cannot have a decorator",
            u8"static blocks cannot have a decorator",
            u8"static blocks cannot have a decorator",
        },
    },
    {
        "stray comma in function parameter"_translatable,
        u8"stray comma in function parameter",
        {
            u8"Vereinzeltes Komme in Funktionsparameter",
            u8"take that stray comma out back and have it meet its maker \U0001f52b",
            u8"virgule isol\u00e9e dans un param\u00e8tre de fonction",
            u8"v\u00edrgula extra em par\u00e2metro da fun\u00e7\u00e3o",
            u8"stray comma in function parameter",
        },
    },
    {
        "stray comma in let statement"_translatable,
        u8"stray comma in let statement",
        {
            u8"Vereinzeltes Komma in let-Statement",
            u8"throw that comma in the bin \U0001f6ae",
            u8"virgule isol\u00e9e dans une instruction let",
            u8"v\u00edrgula extra em instru\u00e7\u00e3o let",
            u8"vilset komma i let p\u00e5st\u00e5ende",
        },
    },
    {
        "string module name is only allowed with 'declare module'"_translatable,
        u8"string module name is only allowed with 'declare module'",
        {
            u8"string module name is only allowed with 'declare module'",
            u8"string module name is only allowed with 'declare module'",
            u8"string module name is only allowed with 'declare module'",
            u8"string module name is only allowed with 'declare module'",
            u8"string module name is only allowed with 'declare module'",
        },
    },
    {
        "switch statement is missing '{1}' around condition"_translatable,
        u8"switch statement is missing '{1}' around condition",
        {
            u8"'{1}' fehlt um Bedingung der switch-Anweisung",
            u8"give the condition a hug",
            u8"une instruction switch n\u00e9cessite '{1}' autour de la condition",
            u8"falta '{1}' ao redor da condi\u00e7\u00e3o da instru\u00e7\u00e3o switch",
            u8"switch sats saknas '{1}' runt vilkoren",
        },
    },
    {
        "switch statement needs parentheses around condition"_translatable,
        u8"switch statement needs parentheses around condition",
        {
            u8"Klammern fehlen um Bedingung der switch-Anweisung",
            u8"give the condition a hug",
            u8"une instruction switch n\u00e9cessite des parenth\u00e8ses autour de la condition",
            u8"instru\u00e7\u00e3o switch requer par\u00eanteses ao redor da condi\u00e7\u00e3o",
            u8"switch sats beh\u00f6ver paranteser runt vilkor",
        },
    },
    {
        "this case will run instead"_translatable,
        u8"this case will run instead",
        {
            u8"this case will run instead",
            u8"this case will run instead",
            u8"this case will run instead",
            u8"this case will run instead",
            u8"this case will run instead",
        },
    },
    {
        "this is a {1}, not a {2} ('{3}')"_translatable,
        u8"this is a {1}, not a {2} ('{3}')",
        {
            u8"this is a {1}, not a {2} ('{3}')",
            u8"this is a {1}, not a {2} ('{3}')",
            u8"this is a {1}, not a {2} ('{3}')",
            u8"this is a {1}, not a {2} ('{3}')",
            u8"this is a {1}, not a {2} ('{3}')",
        },
    },
    {
        "this required parameter appears after the optional parameter"_translatable,
        u8"this required parameter appears after the optional parameter",
        {
            u8"this required parameter appears after the optional parameter",
            u8"this required parameter appears after the optional parameter",
            u8"this required parameter appears after the optional parameter",
            u8"this required parameter appears after the optional parameter",
            u8"this required parameter appears after the optional parameter",
        },
    },
    {
        "this tuple type is a named tuple type because at least one element has a name"_translatable,
        u8"this tuple type is a named tuple type because at least one element has a name",
        {
            u8"this tuple type is a named tuple type because at least one element has a name",
            u8"this tuple type is a named tuple type because at least one element has a name",
            u8"this tuple type is a named tuple type because at least one element has a name",
            u8"essa tupla \u00e9 uma named tuple porque ao menos um elemento tem um nome",
            u8"this tuple type is a named tuple type because at least one element has a name",
        },
    },
    {
        "this {0} looks fishy"_translatable,
        u8"this {0} looks fishy",
        {
            u8"dieses {0} sieht merkw\u00fcrdig aus",
            u8"this {0} looks fishy",
            u8"this {0} looks fishy",
            u8"isso {0} parece suspeito",
            u8"this {0} looks fishy",
        },
    },
    {
        "try statement starts here"_translatable,
        u8"try statement starts here",
        {
            u8"try-Statement beginnt hier",
            u8"at least you tried",
            u8"l'instruction try d\u00e9bute ici",
            u8"instru\u00e7\u00e3o try iniciou aqui",
            u8"try sats startar h\u00e4r",
        },
    },
    {
        "type"_translatable,
        u8"type",
        {
            u8"type",
            u8"type",
            u8"type",
            u8"type",
            u8"type",
        },
    },
    {
        "type alias"_translatable,
        u8"type alias",
        {
            u8"type alias",
            u8"type alias",
            u8"type alias",
            u8"type alias",
            u8"type alias",
        },
    },
    {
        "type annotation is required when using '!' (definite assignment assertion)"_translatable,
        u8"type annotation is required when using '!' (definite assignment assertion)",
        {
            u8"type annotation is required when using '!' (definite assignment assertion)",
            u8"type annotation is required when using '!' (definite assignment assertion)",
            u8"type annotation is required when using '!' (definite assignment assertion)",
            u8"type annotation is required when using '!' (definite assignment assertion)",
            u8"type annotation is required when using '!' (definite assignment assertion)",
        },
    },
    {
        "type predicates are only allowed as function return types"_translatable,
        u8"type predicates are only allowed as function return types",
        {
            u8"type predicates are only allowed as function return types",
            u8"type predicates are only allowed as function return types",
            u8"type predicates are only allowed as function return types",
            u8"type predicates are only allowed as function return types",
            u8"type predicates are only allowed as function return types",
        },
    },
    {
        "type {0} is being defined here"_translatable,
        u8"type {0} is being defined here",
        {
            u8"type {0} is being defined here",
            u8"type {0} is being defined here",
            u8"type {0} is being defined here",
            u8"type {0} is being defined here",
            u8"type {0} is being defined here",
        },
    },
    {
        "typeof result is of type string and so will never equal undefined; use 'undefined' instead"_translatable,
        u8"typeof result is of type string and so will never equal undefined; use 'undefined' instead",
        {
            u8"typeof result is of type string and so will never equal undefined; use 'undefined' instead",
            u8"typeof result is of type string and so will never equal undefined; use 'undefined' instead",
            u8"typeof result is of type string and so will never equal undefined; use 'undefined' instead",
            u8"typeof result is of type string and so will never equal undefined; use 'undefined' instead",
            u8"typeof result is of type string and so will never equal undefined; use 'undefined' instead",
        },
    },
    {
        "unclosed block comment"_translatable,
        u8"unclosed block comment",
        {
            u8"Blockkommentar ohne Ende",
            u8"you accidentally commented out your whole program",
            u8"commentaire de bloc non ferm\u00e9",
            u8"bloco de coment\u00e1rio n\u00e3o encerrado",
            u8"oavslutad kommentationsstycke",
        },
    },
    {
        "unclosed class; expected '}' by end of file"_translatable,
        u8"unclosed class; expected '}' by end of file",
        {
            u8"Klasse ohne Ende. '}' bis sp\u00e4testens zum Ende der Datei erwartet",
            u8"forgetting to close your class is unclassy",
            u8"unclosed class; expected '}' by end of file",
            u8"classe n\u00e3o encerrada; esperado '}'",
            u8"unclosed class; expected '}' by end of file",
        },
    },
    {
        "unclosed code block; expected '}' by end of file"_translatable,
        u8"unclosed code block; expected '}' by end of file",
        {
            u8"Code-Block ohne Ende. '}' bis sp\u00e4testens zum Ende der Datei erwartet",
            u8"c'mon, you forgot '}'",
            u8"bloc de code non ferm\u00e9 ; '}' attendu avant la fin du fichier",
            u8"bloco de coment\u00e1rio n\u00e3o encerrado; esperado '}'",
            u8"oavslutad kod stycke; f\u00f6rv\u00e4ntade '}' innan slutet av filen",
        },
    },
    {
        "unclosed identifier escape sequence"_translatable,
        u8"unclosed identifier escape sequence",
        {
            u8"Unbeendete Bezeichner-Escapesequenz",
            u8"runaway \\u!",
            u8"s\u00e9quence d'\u00e9chappement d'identifiant non ferm\u00e9e",
            u8"sequ\u00eancia de escape n\u00e3o foi fechada",
            u8"oavslutad identifierare flyktsekvens",
        },
    },
    {
        "unclosed interface; expected '}' by end of file"_translatable,
        u8"unclosed interface; expected '}' by end of file",
        {
            u8"unclosed interface; expected '}' by end of file",
            u8"c'mon, you forgot '}'",
            u8"unclosed interface; expected '}' by end of file",
            u8"interface n\u00e3o encerrada; esperado '}'",
            u8"unclosed interface; expected '}' by end of file",
        },
    },
    {
        "unclosed object literal; expected '}'"_translatable,
        u8"unclosed object literal; expected '}'",
        {
            u8"Unbeendetes Objekt-Literal. '}' erwartet",
            u8"you objectively didn't close your object literal",
            u8"litt\u00e9ral objet non ferm\u00e9 ; '}' attendu",
            u8"objeto n\u00e3o encerrado; esperado '}'",
            u8"oavslutad objektlitter\u00e4r; f\u00f6rv\u00e4ntade '}'",
        },
    },
    {
        "unclosed regexp literal"_translatable,
        u8"unclosed regexp literal",
        {
            u8"Unbeendetes RegExp-Literal",
            u8"/unclosed regexp literal",
            u8"litt\u00e9ral regexp non ferm\u00e9",
            u8"regexp n\u00e3o encerrado",
            u8"oavslutad regexplitteral",
        },
    },
    {
        "unclosed string literal"_translatable,
        u8"unclosed string literal",
        {
            u8"Zeichenkette ohne Ende",
            u8"\"unclosed string literal",
            u8"litt\u00e9ral string non ferm\u00e9",
            u8"string n\u00e3o encerrada",
            u8"oavslutad str\u00e4nglitteral",
        },
    },
    {
        "unclosed template"_translatable,
        u8"unclosed template",
        {
            u8"Template ohne Ende",
            u8"`unclosed template",
            u8"template non ferm\u00e9",
            u8"template n\u00e3o foi fechado",
            u8"oavslutad mall",
        },
    },
    {
        "unexpected '!' after variable name"_translatable,
        u8"unexpected '!' after variable name",
        {
            u8"unexpected '!' after variable name",
            u8"unexpected '!' after variable name",
            u8"unexpected '!' after variable name",
            u8"unexpected '!' after variable name",
            u8"unexpected '!' after variable name",
        },
    },
    {
        "unexpected '#'"_translatable,
        u8"unexpected '#'",
        {
            u8"Unerwartete '#'",
            u8"#unexpected",
            u8"'#' inattendu",
            u8"'#' inesperado",
            u8"of\u00f6rv\u00e4ntad '#'",
        },
    },
    {
        "unexpected '...'; expected expression"_translatable,
        u8"unexpected '...'; expected expression",
        {
            u8"unexpected '...'; expected expression",
            u8"unexpected '...'; expected expression",
            u8"unexpected '...'; expected expression",
            u8"unexpected '...'; expected expression",
            u8"unexpected '...'; expected expression",
        },
    },
    {
        "unexpected ':' in expression; did you mean 'as'?"_translatable,
        u8"unexpected ':' in expression; did you mean 'as'?",
        {
            u8"unexpected ':' in expression; did you mean 'as'?",
            u8"unexpected ':' in expression; did you mean 'as'?",
            u8"unexpected ':' in expression; did you mean 'as'?",
            u8"':' inesperado na express\u00e3o; voc\u00ea quis dizer 'as'?",
            u8"unexpected ':' in expression; did you mean 'as'?",
        },
    },
    {
        "unexpected '?'"_translatable,
        u8"unexpected '?'",
        {
            u8"unexpected '?'",
            u8"unexpected '?'",
            u8"unexpected '?'",
            u8"'?' inesperado",
            u8"unexpected '?'",
        },
    },
    {
        "unexpected '?' in type; use '| void' to make an optional type"_translatable,
        u8"unexpected '?' in type; use '| void' to make an optional type",
        {
            u8"unexpected '?' in type; use '| void' to make an optional type",
            u8"unexpected '?' in type; use '| void' to make an optional type",
            u8"unexpected '?' in type; use '| void' to make an optional type",
            u8"unexpected '?' in type; use '| void' to make an optional type",
            u8"unexpected '?' in type; use '| void' to make an optional type",
        },
    },
    {
        "unexpected '?' when destructuring"_translatable,
        u8"unexpected '?' when destructuring",
        {
            u8"unexpected '?' when destructuring",
            u8"unexpected '?' when destructuring",
            u8"unexpected '?' when destructuring",
            u8"'?' inesperado ao desestruturar",
            u8"unexpected '?' when destructuring",
        },
    },
    {
        "unexpected '\\' in identifier"_translatable,
        u8"unexpected '\\' in identifier",
        {
            u8"Unerwartetes '\\' in Bezeichner",
            u8"unex\\pected",
            u8"'\\' inattendu dans un identifiant",
            u8"'\\' inesperado em um identificador",
            u8"of\u00f6rv\u00e4ntad '\\' i identifierare",
        },
    },
    {
        "unexpected 'case' outside switch statement"_translatable,
        u8"unexpected 'case' outside switch statement",
        {
            u8"Unerwartetes 'case' au\u00dferhalb des switch-Statements",
            u8"your 'case' fell out of your switch statement",
            u8"'case' inattendu en dehors d'une instruction switch",
            u8"'case' inesperado fora de uma instru\u00e7\u00e3o switch",
            u8"of\u00f6rv\u00e4ntad 'case' utanf\u00f6r switch sats",
        },
    },
    {
        "unexpected 'catch' without 'try'"_translatable,
        u8"unexpected 'catch' without 'try'",
        {
            u8"Unerwartetes 'catch' ohne zugeh\u00f6riges 'try'",
            u8"you'll never catch anything without trying",
            u8"instruction 'catch' inattendue en l'absence de 'try'",
            u8"'catch' inesperado sem um 'try'",
            u8"of\u00f6rv\u00e4ntad 'catch' utan n\u00e5gon 'try'",
        },
    },
    {
        "unexpected 'default' outside switch statement"_translatable,
        u8"unexpected 'default' outside switch statement",
        {
            u8"Unerwartetes 'default' au\u00dferhalb des switch-Statements",
            u8"your 'default' fell out of your switch statement",
            u8"'default' inattendu en dehors d'une instruction switch",
            u8"'default' inesperado fora de uma instru\u00e7\u00e3o switch",
            u8"of\u00f6rv\u00e4ntad 'default' utanf\u00f6r switch sats",
        },
    },
    {
        "unexpected 'finally' without 'try'"_translatable,
        u8"unexpected 'finally' without 'try'",
        {
            u8"'finally' ohne zugeh\u00f6riges 'try'",
            u8"you're not even gonna 'try'?",
            u8"'finally' inappropri\u00e9 sans 'try'",
            u8"inesperado 'finally' sem 'try'",
            u8"of\u00f6rv\u00e4ntad 'finally' utan 'try'",
        },
    },
    {
        "unexpected '{0}'"_translatable,
        u8"unexpected '{0}'",
        {
            u8"Unerwartetes '{0}'",
            u8"what the heck is '{0}'?",
            u8"'{0}' inattendu",
            u8"'{0}' inesperado",
            u8"of\u00f6rv\u00e4ntad '{0}'",
        },
    },
    {
        "unexpected characters in binary literal"_translatable,
        u8"unexpected characters in binary literal",
        {
            u8"Unerwartete Zeichen in bin\u00e4rem Zahlenliteral",
            u8"this number does not identify as binary",
            u8"caract\u00e8res inattendus dans un litt\u00e9ral binaire",
            u8"caracteres inesperados em um n\u00famero bin\u00e1rio",
            u8"of\u00f6rv\u00e4ntat tecken i bin\u00e4rlitteral",
        },
    },
    {
        "unexpected characters in hex literal"_translatable,
        u8"unexpected characters in hex literal",
        {
            u8"Unerwartete Zeichen in hexadezimalem Zahlenliteral",
            u8"unexpected characters in hex literal",
            u8"caract\u00e8res inattendus dans un litt\u00e9ral hex",
            u8"caracteres inesperados em um n\u00famero hexadecimal",
            u8"of\u00f6rv\u00e4ntat tecken i hexlitteral",
        },
    },
    {
        "unexpected characters in number literal"_translatable,
        u8"unexpected characters in number literal",
        {
            u8"Unerwartete Zeichen in Zahlenliteral",
            u8"does not compute \U0001f916",
            u8"caract\u00e8res inattendus dans un litt\u00e9ral num\u00e9rique",
            u8"caracteres inesperados em um n\u00famero",
            u8"of\u00f6rv\u00e4ntat tecken i nummerlitteral",
        },
    },
    {
        "unexpected characters in octal literal"_translatable,
        u8"unexpected characters in octal literal",
        {
            u8"Unerwartete Zeichen in oktalem Zahlenliteral",
            u8"Cthulhu \U0001f419 is not happy",
            u8"caract\u00e8res inattendus dans un litt\u00e9ral octal",
            u8"caracteres inesperados em um n\u00famero octal",
            u8"of\u00f6rv\u00e4ntat tecken i oktallitteral",
        },
    },
    {
        "unexpected control character"_translatable,
        u8"unexpected control character",
        {
            u8"Unerwartetes Steuerzeichen",
            u8"you lost control of your code",
            u8"caract\u00e8re de contr\u00f4le inattendu",
            u8"caracter de control inesperado",
            u8"of\u00f6rv\u00e4ntat kontrolltecken",
        },
    },
    {
        "unexpected expression; missing key for object entry"_translatable,
        u8"unexpected expression; missing key for object entry",
        {
            u8"Ausdruck vor Zeilenumbruch erwartet",
            u8"you forgot the key \U0001f5dd",
            u8"expression inattendue ; cl\u00e9 manquante pour l'entr\u00e9e d'objet",
            u8"express\u00e3o inesperada; falta a chave para a entrada do objeto",
            u8"of\u00f6rv\u00e4ntat uttryck; saknar nyckel f\u00f6r tilltr\u00e4dande objekt",
        },
    },
    {
        "unexpected identifier in expression; missing operator before"_translatable,
        u8"unexpected identifier in expression; missing operator before",
        {
            u8"Unerwarteter Bezeichner in Ausdruck. Operator fehlt davor.",
            u8"you're need to take me out to dinner before you show me this",
            u8"identifiant inattendu dans une expression ; op\u00e9rateur initial manquant",
            u8"identificador inesperado na express\u00e3o; falta o operador",
            u8"of\u00f6rv\u00e4ntad identifierare i uttryck; saknar operat\u00f6r f\u00f6re",
        },
    },
    {
        "unexpected literal in parameter list; expected parameter name"_translatable,
        u8"unexpected literal in parameter list; expected parameter name",
        {
            u8"Unerwartetes Literal in Parameterliste. Parametername erwartet",
            u8"you literally forgot to name your parameter",
            u8"litt\u00e9ral inattendu dans une liste de param\u00e8tres ; nom de param\u00e8tre attendu",
            u8"valor inesperado na lista de par\u00e2metros; esperado o nome de um par\u00e2metro",
            u8"of\u00f6rv\u00e4ntad litteral i parameter lista; f\u00f6rv\u00e4ntade parameter namn",
        },
    },
    {
        "unexpected statement before first switch case, expected 'case' or 'default'"_translatable,
        u8"unexpected statement before first switch case, expected 'case' or 'default'",
        {
            u8"Unerwartetes Statment vor dem ersten Switch-Case. Entweder 'case' oder 'default' erwartet.",
            u8"you got too excited and forgot 'case'",
            u8"unexpected statement before first switch case, expected 'case' or 'default'",
            u8"instru\u00e7\u00e3o inesperada antes do primeiro switch case, esperado 'case' ou 'default'",
            u8"unexpected statement before first switch case, expected 'case' or 'default'",
        },
    },
    {
        "unexpected token"_translatable,
        u8"unexpected token",
        {
            u8"Unerwartetes Token",
            u8"I don't know what to do with this",
            u8"symbole manquant",
            u8"token inesperado",
            u8"of\u00f6rv\u00e4ntad token",
        },
    },
    {
        "unexpected token in export; expected 'export default ...' or 'export {{name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'"_translatable,
        u8"unexpected token in export; expected 'export default ...' or 'export {{name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'",
        {
            u8"Unerwartetes Token in Export. M\u00f6glichkeiten sind: 'export default ...' oder 'export {{name}' oder 'export * from ...' oder 'export class' oder 'export function' oder 'export let'",
            u8"I don't know what you're trying to export",
            u8"symbole inattendu dans export ; 'export default ...' ou 'export {{name}' ou 'export * from ...' ou 'export class' ou 'export function' ou 'export let' attendu",
            u8"token inesperado em export; esperado 'export default ...' ou 'export {{nome}' ou 'export * from ...' ou 'export class' ou 'export function' ou 'export let'",
            u8"of\u00f6rv\u00e4ntad token i export; f\u00f6rv\u00e4ntade 'export default ...' eller 'export {{name}' eller 'export * from ...' eller 'export class' eller 'export function'  'export let'",
        },
    },
    {
        "unexpected token in variable declaration; expected variable name"_translatable,
        u8"unexpected token in variable declaration; expected variable name",
        {
            u8"Unerwartetes Token innerhalb der Variablendeklaration. Variablenname anstattdessen erwartet",
            u8"just name your variable like a normal person",
            u8"symbole inattendu dans une d\u00e9claration de variable ; nom de variable attendu",
            u8"token inesperado em uma declara\u00e7\u00e3o de vari\u00e1vel; esperado um nome de vari\u00e1vel",
            u8"of\u00f6rv\u00e4ntad token i variabel deklaration; f\u00f6rv\u00e4ntade variabel namn",
        },
    },
    {
        "unexpected whitespace between '!' and '=='"_translatable,
        u8"unexpected whitespace between '!' and '=='",
        {
            u8"unexpected whitespace between '!' and '=='",
            u8"unexpected whitespace between '!' and '=='",
            u8"unexpected whitespace between '!' and '=='",
            u8"unexpected whitespace between '!' and '=='",
            u8"unexpected whitespace between '!' and '=='",
        },
    },
    {
        "unicode byte order mark (BOM) cannot appear before #! at beginning of script"_translatable,
        u8"unicode byte order mark (BOM) cannot appear before #! at beginning of script",
        {
            u8"Die Unicode Bytereihenfolge-Markierung (BOM) darf nicht vor #! zu Beginn eines Skripts erscheinen",
            u8"your editor BOMd \U0001f4a3 your s#!t \U0001f4a9",
            u8"un indicateur d'ordre des octets (BOM) ne peut figurer avant #! au d\u00e9but d'un script",
            u8"unicode byte order mark (BOM) n\u00e3o pode aparecer antes do #! no come\u00e7o do script",
            u8"unicode byte ordningsm\u00e4rke (BOM) kan inte f\u00f6rekomma f\u00f6re #! i b\u00f6rjan av skript",
        },
    },
    {
        "unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &"_translatable,
        u8"unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &",
        {
            u8"unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &",
            u8"unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &",
            u8"unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &",
            u8"unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &",
            u8"unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &",
        },
    },
    {
        "unknown JSX mode; try \"none\" or \"react\""_translatable,
        u8"unknown JSX mode; try \"none\" or \"react\"",
        {
            u8"unknown JSX mode; try \"none\" or \"react\"",
            u8"unknown JSX mode; try \"none\" or \"react\"",
            u8"unknown JSX mode; try \"none\" or \"react\"",
            u8"unknown JSX mode; try \"none\" or \"react\"",
            u8"unknown JSX mode; try \"none\" or \"react\"",
        },
    },
    {
        "unmatched '}'"_translatable,
        u8"unmatched '}'",
        {
            u8"Zugeh\u00f6rige geschweifte Klammer fehlt",
            u8"what are you trying to close here?",
            u8"'}' non appari\u00e9",
            u8"'}' n\u00e3o correspondido",
            u8"omatchad '}'",
        },
    },
    {
        "unmatched indexing bracket"_translatable,
        u8"unmatched indexing bracket",
        {
            u8"Zugeh\u00f6rige Indizierungsklammer fehlt",
            u8"unmatched indexing[bracket",
            u8"crochet d'indexation non appari\u00e9",
            u8"colchete n\u00e3o correspondido",
            u8"omatchad indexerande hakparantes",
        },
    },
    {
        "unmatched parenthesis"_translatable,
        u8"unmatched parenthesis",
        {
            u8"Zugeh\u00f6rige Klammer fehlt",
            u8"I have some extra: ) ) ) ) ) ) ) ) ) ) )",
            u8"parenth\u00e8se non appari\u00e9e",
            u8"par\u00eanteses n\u00e3o correspondidos",
            u8"omatchad parantes",
        },
    },
    {
        "unopened block comment"_translatable,
        u8"unopened block comment",
        {
            u8"Blockkommentar ohne Beginn",
            u8"/*",
            u8"commentaire de bloc non ouvert",
            u8"bloco de coment\u00e1rio n\u00e3o foi aberto",
            u8"unopened block comment",
        },
    },
    {
        "upper case letters compared with toLowerCase"_translatable,
        u8"upper case letters compared with toLowerCase",
        {
            u8"Gro\u00dfbuchstaben werden mit toLowerCase verglichen",
            u8"You sure you're getting what toLowerCase does?",
            u8"upper case letters compared with toLowerCase",
            u8"letras mai\u00fasculas comparadas com toLowerCase",
            u8"upper case letters compared with toLowerCase",
        },
    },
    {
        "use ':' instead of '=' in object literals"_translatable,
        u8"use ':' instead of '=' in object literals",
        {
            u8"use ':' instead of '=' in object literals",
            u8"use ':' instead of '=' in object literals",
            u8"use ':' instead of '=' in object literals",
            u8"use ':' em vez de '=' em objetos",
            u8"use ':' instead of '=' in object literals",
        },
    },
    {
        "use ':' instead of '{0}' to type a function parameter"_translatable,
        u8"use ':' instead of '{0}' to type a function parameter",
        {
            u8"use ':' instead of '{0}' to type a function parameter",
            u8"use ':' instead of '{0}' to type a function parameter",
            u8"use ':' instead of '{0}' to type a function parameter",
            u8"use ':' instead of '{0}' to type a function parameter",
            u8"use ':' instead of '{0}' to type a function parameter",
        },
    },
    {
        "use 'while' instead to loop until a condition is false"_translatable,
        u8"use 'while' instead to loop until a condition is false",
        {
            u8"'while' benutzen, um zu iterieren, bis die Bedingung false wird",
            u8"or use 'while', you silly Gopher",
            u8"utiliser plut\u00f4t 'while' pour boucler jusqu'\u00e0 ce qu'une condition soit fausse",
            u8"use 'while' para fazer um loop at\u00e9 a condi\u00e7\u00e3o ser falsa",
            u8"anv\u00e4nd 'while' ist\u00e4llet f\u00f6r att iterera till vilkoren \u00e4r falskt",
        },
    },
    {
        "use of undeclared type: {0}"_translatable,
        u8"use of undeclared type: {0}",
        {
            u8"use of undeclared type: {0}",
            u8"I don't know what this type is",
            u8"use of undeclared type: {0}",
            u8"uso de tipo n\u00e3o declarado: {0}",
            u8"use of undeclared type: {0}",
        },
    },
    {
        "use of undeclared variable: {0}"_translatable,
        u8"use of undeclared variable: {0}",
        {
            u8"Variable {0} wird verwendet, ist jedoch nicht deklariert",
            u8"did you fail spelling class?",
            u8"utilisation d'une variable non d\u00e9clar\u00e9e : {0}",
            u8"uso de vari\u00e1vel n\u00e3o declarada: {0}",
            u8"anv\u00e4ndning av odeklarerad variabel: {0}",
        },
    },
    {
        "using '{0}' against a class literal always returns '{1}'"_translatable,
        u8"using '{0}' against a class literal always returns '{1}'",
        {
            u8"using '{0}' against a class literal always returns '{1}'",
            u8"using '{0}' against a class literal always returns '{1}'",
            u8"using '{0}' against a class literal always returns '{1}'",
            u8"usar '{0}' com uma classe sempre retorna '{1}'",
            u8"using '{0}' against a class literal always returns '{1}'",
        },
    },
    {
        "using '{0}' against a regular expression literal always returns '{1}'"_translatable,
        u8"using '{0}' against a regular expression literal always returns '{1}'",
        {
            u8"using '{0}' against a regular expression literal always returns '{1}'",
            u8"using '{0}' against a regular expression literal always returns '{1}'",
            u8"using '{0}' against a regular expression literal always returns '{1}'",
            u8"usar '{0}' com uma express\u00e3o regular sempre retorna '{1}'",
            u8"using '{0}' against a regular expression literal always returns '{1}'",
        },
    },
    {
        "using '{0}' against an array literal does not compare items"_translatable,
        u8"using '{0}' against an array literal does not compare items",
        {
            u8"using '{0}' against an array literal does not compare items",
            u8"using '{0}' against an array literal does not compare items",
            u8"using '{0}' against an array literal does not compare items",
            u8"usar '{0}' com uma array n\u00e3o compara os itens",
            u8"using '{0}' against an array literal does not compare items",
        },
    },
    {
        "using '{0}' against an arrow function always returns '{1}'"_translatable,
        u8"using '{0}' against an arrow function always returns '{1}'",
        {
            u8"using '{0}' against an arrow function always returns '{1}'",
            u8"using '{0}' against an arrow function always returns '{1}'",
            u8"using '{0}' against an arrow function always returns '{1}'",
            u8"usar '{0}' com uma arrow function sempre retorna '{1}'",
            u8"using '{0}' against an arrow function always returns '{1}'",
        },
    },
    {
        "using '{0}' against an object literal always returns '{1}'"_translatable,
        u8"using '{0}' against an object literal always returns '{1}'",
        {
            u8"using '{0}' against an object literal always returns '{1}'",
            u8"using '{0}' against an object literal always returns '{1}'",
            u8"using '{0}' against an object literal always returns '{1}'",
            u8"usar '{0}' com um objeto sempre retorna '{1}'",
            u8"using '{0}' against an object literal always returns '{1}'",
        },
    },
    {
        "variable"_translatable,
        u8"variable",
        {
            u8"variable",
            u8"variable",
            u8"variable",
            u8"variable",
            u8"variable",
        },
    },
    {
        "variable already declared here"_translatable,
        u8"variable already declared here",
        {
            u8"Variable wurde zuvor hier deklariert",
            u8"here's your first attempt",
            u8"variable d\u00e9j\u00e0 d\u00e9clar\u00e9e ici",
            u8"vari\u00e1vel j\u00e1 foi declarada aqui",
            u8"variabel \u00e4r redan deklarerad h\u00e4r",
        },
    },
    {
        "variable assigned before its declaration"_translatable,
        u8"variable assigned before its declaration",
        {
            u8"Zuweisung an Variable vor Deklaration",
            u8"why are you assignin' before you be makin'? \U0001f90f",
            u8"variable affect\u00e9e avant sa d\u00e9claration",
            u8"vari\u00e1vel atribu\u00edda antes de ser declarada",
            u8"tilldelar variabel f\u00f6re deklaration",
        },
    },
    {
        "variable assignment to self is no-op"_translatable,
        u8"variable assignment to self is no-op",
        {
            u8"variable assignment to self is no-op",
            u8"variable assignment to self is no-op",
            u8"variable assignment to self is no-op",
            u8"variable assignment to self is no-op",
            u8"variable assignment to self is no-op",
        },
    },
    {
        "variable declared here"_translatable,
        u8"variable declared here",
        {
            u8"Variablendeklaration ist hier",
            u8"\U0001f446 it's right here, doofus",
            u8"variable d\u00e9clar\u00e9e ici",
            u8"vari\u00e1vel declarada aqui",
            u8"variabel deklarerades h\u00e4r",
        },
    },
    {
        "variable used before declaration: {0}"_translatable,
        u8"variable used before declaration: {0}",
        {
            u8"Variable '{0}' wird ihrer Deklaration verwendet",
            u8"why are you usin' before you be makin'? \U0001f90f",
            u8"variable utilis\u00e9e avant sa d\u00e9claration : {0}",
            u8"vari\u00e1vel usada antes de ser declarada: {0}",
            u8"variabel anv\u00e4nd f\u00f6re: {0}",
        },
    },
    {
        "what is this '{1}' nonsense?"_translatable,
        u8"what is this '{1}' nonsense?",
        {
            u8"Was soll dieser '{1}' Humbug?",
            u8"what is this '{1}' nonsense?",
            u8"what is this '{1}' nonsense?",
            u8"what is this '{1}' nonsense?",
            u8"what is this '{1}' nonsense?",
        },
    },
    {
        "while loop is missing '{1}' around condition"_translatable,
        u8"while loop is missing '{1}' around condition",
        {
            u8"'{1}' fehlt um Bedingung der while-Schleife",
            u8"surround the condition so it can't run away",
            u8"une boucle while n\u00e9cessite '{1}' autour de la condition",
            u8"falta '{1}' ao redor da condi\u00e7\u00e3o do loop while",
            u8"while loop saknar '{1}' runt vilkoren",
        },
    },
    {
        "while loop needs parentheses around condition"_translatable,
        u8"while loop needs parentheses around condition",
        {
            u8"Klammern fehlen um Bedingung der while-Schleife",
            u8"surround the condition so it can't run away",
            u8"une boucle while n\u00e9cessite des parenth\u00e8ses autour de la condition",
            u8"loop while requer par\u00eanteses ao redor da condi\u00e7\u00e3o",
            u8"while loop beh\u00f6ver paranteser runt vilkoren",
        },
    },
    {
        "with statement is missing '{1}' around expression"_translatable,
        u8"with statement is missing '{1}' around expression",
        {
            u8"'{1}' fehlt um Ausdruck der with-Anweisung",
            u8"with statement needs you to stop programming right now",
            u8"une instruction with n\u00e9cessite '{1}' autour de l'expression",
            u8"falta '{1}' ao redor da express\u00e3o da instru\u00e7\u00e3o with",
            u8"with p\u00e5st\u00e5ende saknar '{1}' runt uttryck",
        },
    },
    {
        "with statement needs parentheses around expression"_translatable,
        u8"with statement needs parentheses around expression",
        {
            u8"Klammern fehlen um Ausdruck der with-Anweisung",
            u8"with statement needs you to stop programming right now",
            u8"une instruction with n\u00e9cessite des parenth\u00e8ses autour de l'expression",
            u8"instru\u00e7\u00e3o with requer par\u00eanteses ao redor da express\u00e3o",
            u8"with p\u00e5st\u00e5ende saknar paranteser runt uttryck",
        },
    },
    {
        "write 'const' instead of '{0}' here"_translatable,
        u8"write 'const' instead of '{0}' here",
        {
            u8"write 'const' instead of '{0}' here",
            u8"write 'const' instead of '{0}' here",
            u8"write 'const' instead of '{0}' here",
            u8"use 'const' em vez de '{0}' aqui",
            u8"write 'const' instead of '{0}' here",
        },
    },
    {
        "write '{1}' here or remove it from the overload signature"_translatable,
        u8"write '{1}' here or remove it from the overload signature",
        {
            u8"write '{1}' here or remove it from the overload signature",
            u8"write '{1}' here or remove it from the overload signature",
            u8"write '{1}' here or remove it from the overload signature",
            u8"write '{1}' here or remove it from the overload signature",
            u8"write '{1}' here or remove it from the overload signature",
        },
    },
    {
        "write the decorator before here"_translatable,
        u8"write the decorator before here",
        {
            u8"write the decorator before here",
            u8"write the decorator before here",
            u8"write the decorator before here",
            u8"write the decorator before here",
            u8"write the decorator before here",
        },
    },
    {
        "write the type assertion with 'as' here instead"_translatable,
        u8"write the type assertion with 'as' here instead",
        {
            u8"write the type assertion with 'as' here instead",
            u8"write the type assertion with 'as' here instead",
            u8"write the type assertion with 'as' here instead",
            u8"escreva a asser\u00e7\u00e3o de tipo aqui como 'as'",
            u8"write the type assertion with 'as' here instead",
        },
    },
    {
        "{0} classes are not allowed in JavaScript"_translatable,
        u8"{0} classes are not allowed in JavaScript",
        {
            u8"{0} classes are not allowed in JavaScript",
            u8"{0} classes are not allowed in JavaScript",
            u8"{0} classes are not allowed in JavaScript",
            u8"classe {0} n\u00e3o \u00e9 permitida em JavaScript",
            u8"{0} classes are not allowed in JavaScript",
        },
    },
    {
        "{0} is not the name of a parameter"_translatable,
        u8"{0} is not the name of a parameter",
        {
            u8"{0} is not the name of a parameter",
            u8"{0} is not the name of a parameter",
            u8"{0} is not the name of a parameter",
            u8"{0} n\u00e3o \u00e9 o nome de um par\u00e2metro",
            u8"{0} is not the name of a parameter",
        },
    },
    {
        "{0} with no bindings"_translatable,
        u8"{0} with no bindings",
        {
            u8"{0} ohne Binding",
            u8"naked {0} \U0001f60a",
            u8"{0} sans liaisons",
            u8"{0} sem bindings",
            u8"{0} utan bindningar",
        },
    },
    {
        "{1:headlinese} declared here"_translatable,
        u8"{1:headlinese} declared here",
        {
            u8"{1:headlinese} declared here",
            u8"{1:headlinese} declared here",
            u8"{1:headlinese} declared here",
            u8"{1:headlinese} declared here",
            u8"{1:headlinese} declared here",
        },
    },
    {
        "{1:headlinese} value must be a compile-time constant"_translatable,
        u8"{1:headlinese} value must be a compile-time constant",
        {
            u8"{1:headlinese} value must be a compile-time constant",
            u8"{1:headlinese} value must be a compile-time constant",
            u8"{1:headlinese} value must be a compile-time constant",
            u8"valor {1:headlinese} precisa ser uma constante em tempo de compila\u00e7\u00e3o",
            u8"{1:headlinese} value must be a compile-time constant",
        },
    },
    {
        "{1} cannot have an initializer in a .d.ts file"_translatable,
        u8"{1} cannot have an initializer in a .d.ts file",
        {
            u8"{1} cannot have an initializer in a .d.ts file",
            u8"{1} cannot have an initializer in a .d.ts file",
            u8"{1} cannot have an initializer in a .d.ts file",
            u8"{1} cannot have an initializer in a .d.ts file",
            u8"{1} cannot have an initializer in a .d.ts file",
        },
    },
    {
        "~~~ invalid string, do not use outside benchmark ~~~"_translatable,
        u8"~~~ invalid string, do not use outside benchmark ~~~",
        {
            u8"~~~ invalid string, do not use outside benchmark ~~~",
            u8"~~~ invalid string, do not use outside benchmark ~~~",
            u8"~~~ invalid string, do not use outside benchmark ~~~",
            u8"~~~ string inv\u00e1lida, n\u00e3o use fora de benchmarks ~~~",
            u8"~~~ invalid string, do not use outside benchmark ~~~",
        },
    },
};
// clang-format on
}

// quick-lint-js finds bugs in JavaScript programs.
// Copyright (C) 2020  Matthew "strager" Glazar
//
// This file is part of quick-lint-js.
//
// quick-lint-js is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// quick-lint-js is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with quick-lint-js.  If not, see <https://www.gnu.org/licenses/>.
