# E0451: misleading use of ',' operator in conditional statement

Using comma operator within a conditional statement of a control block (`if`, `for`, `while`, `switch`) is misleading, because only the last expression will be used to evaluate the condition.

For example:

```javascript
let N = 10;
for (let i = 0, j = N - 1; i < j, j >= 0; ++i, --j) {
  console.log(i, j);
}
```

Here, the statement `i < j, j >= 0` will be evaluated as `j >= 0`, disregarding
the first part (`i < j`) of the statement. In order to have both parts evaluated,
a logical operator should be used instead of the comma operator.

```javascript
let N = 10;
for (let i = 0, j = N - 1; i < j && j >= 0; ++i, --j) {
  console.log(i, j);
}
```
