# E0450: misleading use of ',' operator in index

Using comma operator within an indexing operation is misleading, as it
can be confused with a new array definition, or with access to multiple elements
of the container.

For example:

```javascript
let matrix = [
  [1, 2, 3],
  [4, 5, 6],
  [7, 8, 9],
];
let topLeft = matrix[0, 0];
```
Here, the value of `topLeft` will be equal to `matrix[0] = [1, 2, 3]`.
If the intention is to find the value at the top-left corner of `matrix`, the correct syntax would be:
```javascript
let matrix = [
  [1, 2, 3],
  [4, 5, 6],
  [7, 8, 9],
];
let topLeft = matrix[0][0]; // topLeft = 1
```
