# E0379: optional parameter cannot be followed by a required parameter

Optional parameters need to be placed after the required ones.

```typescript
function f(param1?: number, param2: number) {
  if (param1) {
    return param1
  }
  return param2;
}
```

To fix this warning, we need to place the required parameter(s) first, followed by the optional parameters

```typescript
function f(param2: number, param1?: number) {
  if (param1) {
    return param1
  }
  return param2;
}
```
