# E0373: unexpected whitespace between '!' and '=='; '!' here treated as the TypeScript non-null assertion operator

While `x! == y` is legal TypeScript for a non-null assertion, it may be a typo for a strict inequality, as in `x !== y`:

```typescript
let x = 17;
let y = 38;
if (x! == y) {
    alert('Not equal!');
}
```

To fix the warning, replace `! ==` with ` !==`:

```typescript
let x = 17;
let y = 38;
if (x !== y) {
  alert("Not equal!");
}
```

To suppress this warning, add parentheses around the non-null assertion:

```typescript
let x = 17;
let y = 38;
if ((x!) == y) {
  alert("Not equal!");
}
```

See also: E0374
