# E0343: using '==' against a class literal always returns 'false'

```config-for-examples
{
  "globals": {
    "__DEBUG__": true
  }
}
```

In JavaScript, you can create a class in an expression. The class is a brand new
class, so comparing the class using `==`, `===`, `!=`, or `!==` will always give
the same result (`false` or `true`):

```javascript
let Logger;
if (__DEBUG__) {
  Logger = class {
    log(msg) { console.log(msg); }
  };
} else {
  Logger == class {
    log(msg) { }
  };
}
```

To fix this error, write `=` instead of `==`:

```javascript
let Logger;
if (__DEBUG__) {
  Logger = class {
    log(msg) { console.log(msg); }
  };
} else {
  Logger = class {
    log(msg) { }
  };
}
```

Introduced in quick-lint-js version 2.10.0.
