# E0320: missing name for element in named tuple type

In TypeScript, a tuple type can have names for each element. It is a syntax
error to write `:` but omit the name in a tuple type:

```typescript
function bsearch(a): [: number, hi: number] {
  /* ... */
}
```

To fix this error, write the name for the tuple element:

```typescript
function bsearch(a): [lo: number, hi: number] {
  /* ... */
}
```

Alternatively, delete the `:`, and delete the names of other tuple elements:

```typescript
function bsearch(a): [number, number] {
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
