# E0302: 'this' parameter not allowed when destructuring

```config-for-examples
{
  "globals": {
    "Ring": true,
    "his": true,
    "hisRing": true,
    "herRing": true
  }
}
```

TypeScript allows you to explicitly declare the `this` parameter. It is a syntax
error to destructure the `this` parameter or to include the `this` parameter
when destructuring another parameter:

```typescript
function swapRings([this, hers]) {
  return [hers, his];
}

let newRings = swapRings([hisRing, herRing]);
```

To fix this error, name the parameter something other than `this`:

```typescript
function swapRings([his, hers]) {
  return [hers, his];
}
```

Introduced in quick-lint-js version 2.10.0.
