# E0295: abstract fields cannot have default values

TypeScript abstract fields in classes cannot have initializers. It is a syntax
error to write an initializer for a field marked `abstract`:

```typescript
abstract class Expression {
  abstract readonly op: string = "???";

  left!: Expression;
  right!: Expression;

  toString(): string {
    return `${this.left} ${this.op} ${this.right}`;
  }

  abstract eval(): any;
}

class AddExpression {
  readonly op: string = "+";

  eval(): any {
    return this.left.eval() + this.right.eval();
  }
}
```

To fix this error, remove the initializer:

```typescript
abstract class Expression {
  abstract readonly op: string;

  left!: Expression;
  right!: Expression;

  /* ... */
}
```

Alternatively, keep the initializer but remove the `abstract` keyword:

```typescript
abstract class Expression {
  readonly op: string = "???";

  left!: Expression;
  right!: Expression;

  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
