# E0255: missing parentheses around parameter; TypeScript type annotation requires parentheses

```config-for-examples
{
  "globals": {
    "Friend": true,
    "friends": true
  }
}
```

Arrow functions with one parameter can omit the parentheses around that
parameter. However, if the parameter has a type annotation, it is a syntax error
to omit the parentheses:

```typescript
let friendNames =
  friends.map(f: Friend => f.name);

const toString = thing: string => {
  if (thing === true)  return 'TRUE';
  if (thing === false) return 'FALSE';
  return thing.toString();
};
```

To fix this error, put a pair of parentheses around the parameter name and its
type:

```typescript
let friendNames =
  friends.map((f: Friend) => f.name);
```

Alternatively, put a pair of parentheses around the parameter name, and leave
the `:` and the return type outside:

```typescript
const toString = (thing): string => {
  if (thing === true)  return 'TRUE';
  if (thing === false) return 'FALSE';
  return thing.toString();
};
```

Introduced in quick-lint-js version 2.7.0.
