# E0155: cannot reference private variables without object; use 'this.'

```config-for-examples
{
  "globals": {
    "hashPassword": true
  }
}
```

Classes can contain private properties. Their names start with `#`. It is a
syntax error to use a private property without an object:

```javascript
class Account {
  #email;
  #passwordHash;

  changePassword(newPassword) {
    #passwordHash = hashPassword(newPassword);
  }

  async save(db) {
    await db.saveAccount({
      email: #email,
      passwordHash: #passwordHash,
    });
  }
}
```

To fix this error, write `this.` before the use of the private property:

```javascript
class Account {
  #email;
  #passwordHash;

  changePassword(newPassword) {
    this.#passwordHash = hashPassword(newPassword);
  }

  async save(db) {
    await db.saveAccount({
      email: this.#email,
      passwordHash: this.#passwordHash,
    });
  }
}
```

Introduced in quick-lint-js version 0.3.0.
