# E0144: cannot export variable named keyword

An `export` statement can export a list of classes, functions, and variables. It
is a syntax error to export something with the same name as a keyword:

```javascript
// Import using:
// import {class as makeClass} from "./css.mjs";
function cssClass(classes) {
  return Object.keys(classes).join(" ");
}
export {class};
```

To fix this error, use `as` to name the export different from the declared
class, function, or variable, and ensure importers use the exported name:

```javascript
// Import using:
// import {class as makeClass} from "./css.mjs";
function cssClass(classes) {
  return Object.keys(classes).join(" ");
}
export {cssClass as class};
```

Alternatively, fix the name of the export, and ensure importers use the fixed
name:

```javascript
// Import using:
// import {cssClass as makeClass} from "./css.mjs";
function cssClass(classes) {
  return Object.keys(classes).join(" ");
}
export {cssClass};
```

Introduced in quick-lint-js version 0.2.0.
