# E0089: with statement needs parentheses around expression

```config-for-examples
{
  "globals": {
    "person": true
  }
}
```

`with` statements have an expression after the `with` keyword. It is a syntax
error to write an expression without `(` and `)`:

```javascript
with person {
  console.log(`Hi, ${firstName} ${lastName}!`);
}
```

To fix this error, write `(` before the expression and `)` after the expression:

```javascript
with (person) {
  console.log(`Hi, ${firstName} ${lastName}!`);
}
```

Introduced in quick-lint-js version 0.2.0.
