# E0079: missing name of exported function

```config-for-examples
{
  "globals": {
    "React": true
  }
}
```

In modules, functions can be exported by name or by default. It is an error to
export an unnamed function by name:

```javascript
export function({props}) {
  return React.createElement(
    "h1",
    null,
    `Hello, ${props.name}!`,
  );
}
```

To fix this error, export the function by default:

```javascript
// Import using:
// import MyComponent from "./MyComponent.mjs";
export default function({props}) {
  return React.createElement(
    "h1",
    null,
    `Hello, ${props.name}!`,
  );
}
```

Alternatively, give a name to the function:

```javascript
// Import using:
// import {MyComponent} from "./MyComponent.mjs";
export function MyComponent({props}) {
  return React.createElement(
    "h1",
    null,
    `Hello, ${props.name}!`,
  );
}
```

Introduced in quick-lint-js version 0.2.0.
