# E0062: missing name or parentheses for function

```config-for-examples
{
  "globals": {
    "isEven": true
  }
}
```

If a statement begins with the `function` keyword, the declared function must
have a name. It is an error to start a statement with `function` but not give a
name to the function:

```javascript
function() {  // IIFE for our module
  class PublicClass {}
  class PrivateClass {}
  window.PublicClass = PublicClass;
}()
```

To fix this error, wrap the IIFE (Immediately Invoked Function Expression) in
parentheses:

```javascript
(function() {  // IIFE for our module
  class PublicClass {}
  class PrivateClass {}
  window.PublicClass = PublicClass;
}())
```

Introduced in quick-lint-js version 0.2.0.
