# E0056: unmatched parenthesis

It is an error to write the `(` without its matching `)`:

```javascript
function fma(a, b, c) {
  return (a * b + c;
}
let five = (fma(2, 2, 1);
```

To fix this error, write the closing `)`, or remove the extraneous `(`:

```javascript
function fma(a, b, c) {
  return (a * b) + c;
}
let five = fma(2, 2, 1);
```

Introduced in quick-lint-js version 0.2.0.
