# E0016: expected hexadecimal digits in Unicode escape sequence

In variable names and strings, a Unicode escape sequence must contain only
hexadecimal digits (any of `0123456789abcdefABCDEF`). It is an error if other
characters appear within a Unicode escape sequence:

```javascript
console.log("List of Pok\ue9mon by weight:");
console.log("{Nidoran\u{2642male}");
```

For an escape sequence without `{` and `}`, add `{` and `}`:

```javascript
console.log("List of Pok\u{e9}mon by weight:");
```

Alternatively, for an escape sequence without `{` and `}`, include `0` digits
such that the escape sequence contains exactly four hexadecimal digits:

```javascript
console.log("List of Pok\u00e9mon by weight:");
```

For an escape sequence with `{` and `}`, ensure the `}` appears after the
hexadecimal digits:

```javascript
console.log("{Nidoran\u{2642}male}");
```

Introduced in quick-lint-js version 0.2.0.
