# E0010: cannot import 'let'

An imported function or variable cannot be named `let`:

```javascript
import { let } from "./security.mjs";
```

To fix this error, name the function or variable something other than `let`, or
rename the function or variable using `import`-`as`:

```javascript
import { allow } from "./security.mjs";

import { let as permit } from "./security.mjs";
```

Introduced in quick-lint-js version 0.2.0.
