# E0004: assignment to const variable before its declaration

You cannot reassign variables declared with `const`, and you cannot reference a
variable declared with `const` above its declaration. The assignment will crash
with a `ReferenceError` if you run the code.

```javascript
let timeElapsed = 31;

let pie = "cooking";
if (timeElapsed > 30) {
  pi = "cooked";
}
const pi = 3.14;
```

To fix this error, assign to a different variable or declare a new variable with
a different name:

```javascript
let timeElapsed = 31;

let pie = "cooking";
if (timeElapsed > 30) {
  pie = "cooked";
}
const pi = 3.14;
```

See also: E0001, E0003

Introduced in quick-lint-js version 0.2.0.
