# E0714: 'async' keyword is not allowed on getters or setters

Use of 'async' keyword, defining asynchronous functions, is not allowed on getters or setters.
Getters and setters are synchronous operations and do not support the asynchronous functionality.


```javascript
class C {
  constructor() {
    this._value = 0;
  }

  async get value() {
    return this._value;
  }

  async set value(newValue) {
    this._value = newValue;
  }
}
```

To fix this error simply remove 'async' keyword from getters and setters, 
so they can function properly as synchronous operations.


```javascript
class C {
  constructor() {
    this._value = 0;
  }

  get value() {
    return this._value;
  }

  set value(newValue) {
    this._value = newValue;
  }
}
```

However, if you require asynchronous behavior within getters or setters, 
you can achieve this by implementing separate asynchronous methods.


```javascript
class C {
  constructor() {
    this._value = 0;
  }

  async getValueAsync() {
    return await fetch(this._value);
  }

  async setValueAsync(newValue) {
    this._value = await fetch(newValue);
  }
}
```