# E0383: variable assignment to self is no-op

```config-for-examples
{
  "globals": {
    "previous": true,
    "switchToPage": true
  }
}
```

The following contains a no-op (`next = next;`):

```javascript
let next = 0;
if (previous !== null) {
  next = next;
}
switchToPage(next);
```

To fix this, change the assignment so it's not assigning a variable to itself:

```javascript
let next = 0;
if (previous !== null) {
  next = previous;
}
switchToPage(next);
```
