# E0307: unexpected '?'

In JavaScript, `?` is used for the conditional operator (e.g.
`haveEggs ? takeEgg() : null`). In TypeScript, `?` is also used for optional
properties and parameters. It is a syntax error to write `?` in other contexts:

```javascript
class EggBasket {
  maybeTakeEgg() {
    return this.haveEggs ?
  }
  get haveEggs() { /* ... */ }
  removeEgg() { /* ... */ }
}
```

To fix this error, complete the conditional expression:

```javascript
class EggBasket {
  maybeTakeEgg() {
    return this.haveEggs
         ? this.removeEgg()
         : null;
  }
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
