# E0301: 'this' parameters are not allowed in arrow functions

```config-for-examples
{
  "globals": {
    "DB": true,
    "db": true,
    "User": true
  }
}
```

TypeScript allows you to add a type annotation to the implicit `this` parameter
explicitly. This is possible in methods, in functions declared with the
`function` keyword, and in function types. It is a syntax error to write a
`this` parameter explicitly in an arrow function:

```typescript
// Example from TypeScript documentation. SPDX license: MIT
// Copyright (c) Microsoft Corporation
interface DB {
  filterUsers(filter: (this: User) => boolean): User[];
}
let admins = db.filterUsers((this: User) => {
  return this.admin;
});
```

To fix this error, write a function with the `function` keyword instead of an
arrow function:

```typescript
let admins = db.filterUsers(function (this: User) {
  return this.admin;
});
```

Introduced in quick-lint-js version 2.10.0.
