# E0298: abstract methods cannot be marked 'async'

```config-for-examples
{
  "globals": {
    "LoadedData": true
  }
}
```

The `async` keyword on methods changes the body of that method. Abstract methods
do not have bodies. Therefore, `async` does not make sense on abstract methods,
and it is a syntax error to write it:

```typescript
abstract class DataLoader {
  abstract async load(): Promise<LoadedData>;
}
```

To fix this error, remove the `async` keyword:

```typescript
abstract class DataLoader {
  abstract load(): Promise<LoadedData>;
}
```

Introduced in quick-lint-js version 2.10.0.
