# E0288: TypeScript interface properties are always public and cannot be marked protected

TypeScript interfaces describe the properties of objects usable from outside
that object's class. Therefore, all interface properties must be public.
It is an error to declare a protected property in an interface:

```typescript
interface Painter {
  paintPixel(pos, color);
  protected doPaintPixel(pos, color);
}

class CanvasPainter implements Painter {
  paintPixel(pos, color) {
    this.validatePixel(pos);
    this.doPaintPixel(pos, color);
  }

  private validatePixel(pos) {
    // ...
  }

  protected doPaintPixel(pos, color) {
    // ...
  }
}
```

To fix this error, remove the `protected` keyword from the interface property.

Alternatively, delete the protected property entirely from the interface.

Alternatively, convert the interface into an abstract class:

```typescript
abstract class Painter {
  paintPixel(pos, color) {
    this.validatePixel(pos);
    this.doPaintPixel(pos, color);
  }

  private validatePixel(pos) {
    // ...
  }

  protected abstract doPaintPixel(pos, color);
}

class CanvasPainter extends Painter {
  protected doPaintPixel(pos, color) {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.10.0.
